package org.pdb.beans;

/**
 *  Data items in the CHEM_COMP_TOR category record details about
 *  the torsion angles in a chemical component. As torsion angles
 *  can have more than one target value, the target values are
 *  specified in the CHEM_COMP_TOR_VALUE category.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:chem_comp_torCategory>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_chi1">
 *  <PDBx:atom_id_1>N</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CA</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CB</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CG</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_chi2">
 *  <PDBx:atom_id_1>CA</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CB</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CG</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CD1</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring1">
 *  <PDBx:atom_id_1>CB</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CG</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CD1</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CE1</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring2">
 *  <PDBx:atom_id_1>CB</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CG</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CD2</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CE2</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring3">
 *  <PDBx:atom_id_1>CG</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CD1</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CE1</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CZ</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring4">
 *  <PDBx:atom_id_1>CD1</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CE1</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CZ</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CE2</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  <PDBx:chem_comp_tor comp_id="phe" id="phe_ring5">
 *  <PDBx:atom_id_1>CE1</PDBx:atom_id_1>
 *  <PDBx:atom_id_2>CZ</PDBx:atom_id_2>
 *  <PDBx:atom_id_3>CE2</PDBx:atom_id_3>
 *  <PDBx:atom_id_4>CD2</PDBx:atom_id_4>
 *  </PDBx:chem_comp_tor>
 *  </PDBx:chem_comp_torCategory>
 * </pre>
 */
public class Chem_comp_tor 
{
		protected java.lang.String atom_id_1;


	/**
	 *  The ID of the first of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_1() 
	{
		return atom_id_1;
	}
 
	public void setAtom_id_1(java.lang.String atom_id_1)
	{
		this.atom_id_1 = atom_id_1;
	}

 	protected java.lang.String atom_id_2;


	/**
	 *  The ID of the second of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_2() 
	{
		return atom_id_2;
	}
 
	public void setAtom_id_2(java.lang.String atom_id_2)
	{
		this.atom_id_2 = atom_id_2;
	}

 	protected java.lang.String atom_id_3;


	/**
	 *  The ID of the third of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_3() 
	{
		return atom_id_3;
	}
 
	public void setAtom_id_3(java.lang.String atom_id_3)
	{
		this.atom_id_3 = atom_id_3;
	}

 	protected java.lang.String atom_id_4;


	/**
	 *  The ID of the fourth of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  This data item is a pointer to  attribute atom_id in category chem_comp_atom in the
	 *  CHEM_COMP_ATOM category.
	 */
	public java.lang.String getAtom_id_4() 
	{
		return atom_id_4;
	}
 
	public void setAtom_id_4(java.lang.String atom_id_4)
	{
		this.atom_id_4 = atom_id_4;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category chem_comp_tor must uniquely identify a
	 *  record in the CHEM_COMP_TOR list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
