package org.pdb.beans;

/**
 *  Data items in the CHEM_LINK_ANGLE category record details
 *  about angles in a link between chemical components.
 *  
 * <pre>
 *  Example 1 - Engh & Huber parameters [Acta Cryst. (1991), A47,
 *  392-400] as interpreted by J. P. Priestle (1995). Consistent
 *  Stereochemical Dictionaries for Refinement and Model
 *  Building. CCP4 Daresbury Study Weekend,
 *  DL-CONF-95-001, ISSN 1358-6254. Warrington: Daresbury
 *  Laboratory.
 *  <PDBx:chem_link_angleCategory>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="N" atom_id_2="CA" atom_id_3="C">
 *  <PDBx:value_angle>111.2</PDBx:value_angle>
 *  <PDBx:value_angle_esd>2.8</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>1</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="CA" atom_id_2="C" atom_id_3="O">
 *  <PDBx:value_angle>120.8</PDBx:value_angle>
 *  <PDBx:value_angle_esd>1.7</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>1</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="CA" atom_id_2="C" atom_id_3="N">
 *  <PDBx:value_angle>116.2</PDBx:value_angle>
 *  <PDBx:value_angle_esd>2.0</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>2</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="O" atom_id_2="C" atom_id_3="N">
 *  <PDBx:value_angle>123.0</PDBx:value_angle>
 *  <PDBx:value_angle_esd>1.6</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>1</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>2</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  <PDBx:chem_link_angle link_id="PEPTIDE" atom_id_1="C" atom_id_2="N" atom_id_3="CA">
 *  <PDBx:value_angle>121.7</PDBx:value_angle>
 *  <PDBx:value_angle_esd>1.8</PDBx:value_angle_esd>
 *  <PDBx:atom_1_comp_id>1</PDBx:atom_1_comp_id>
 *  <PDBx:atom_2_comp_id>2</PDBx:atom_2_comp_id>
 *  <PDBx:atom_3_comp_id>2</PDBx:atom_3_comp_id>
 *  </PDBx:chem_link_angle>
 *  </PDBx:chem_link_angleCategory>
 * </pre>
 */
public class Chem_link_angle 
{
		protected java.lang.String atom_1_comp_id;


	/**
	 *  This data item indicates whether atom 1 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_1_comp_id() 
	{
		return atom_1_comp_id;
	}
 
	public void setAtom_1_comp_id(java.lang.String atom_1_comp_id)
	{
		this.atom_1_comp_id = atom_1_comp_id;
	}

 	protected java.lang.String atom_2_comp_id;


	/**
	 *  This data item indicates whether atom 2 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_2_comp_id() 
	{
		return atom_2_comp_id;
	}
 
	public void setAtom_2_comp_id(java.lang.String atom_2_comp_id)
	{
		this.atom_2_comp_id = atom_2_comp_id;
	}

 	protected java.lang.String atom_3_comp_id;


	/**
	 *  This data item indicates whether atom 3 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_3_comp_id() 
	{
		return atom_3_comp_id;
	}
 
	public void setAtom_3_comp_id(java.lang.String atom_3_comp_id)
	{
		this.atom_3_comp_id = atom_3_comp_id;
	}

 	protected java.lang.String atom_id_1;


	/**
	 *  The ID of the first of the three atoms that define the angle.
	 *  
	 *  An atom with this ID must exist in the component of the type
	 *  specified by  attribute type_comp_1 in category chem_comp_link (or
	 *  attribute type_comp_2 in category chem_comp_link where the appropriate data item
	 *  is indicated by the value of  attribute atom_1_comp_id) in category chem_comp_angle.
	 */
	public java.lang.String getAtom_id_1() 
	{
		return atom_id_1;
	}
 
	public void setAtom_id_1(java.lang.String atom_id_1)
	{
		this.atom_id_1 = atom_id_1;
	}

 	protected java.lang.String atom_id_2;


	/**
	 *  The ID of the second of the three atoms that define the angle.
	 *  The second atom is taken to be the apex of the angle.
	 *  
	 *  An atom with this ID must exist in the component of the type
	 *  specified by  attribute type_comp_1 in category chem_comp_link (or
	 *  attribute type_comp_2 in category chem_comp_link where the appropriate data item
	 *  is indicated by the value of  attribute atom_2_comp_id) in category chem_comp_angle.
	 */
	public java.lang.String getAtom_id_2() 
	{
		return atom_id_2;
	}
 
	public void setAtom_id_2(java.lang.String atom_id_2)
	{
		this.atom_id_2 = atom_id_2;
	}

 	protected java.lang.String atom_id_3;


	/**
	 *  The ID of the third of the three atoms that define the angle.
	 *  
	 *  An atom with this ID must exist in the component of the type
	 *  specified by  attribute type_comp_1 in category chem_comp_link (or
	 *  attribute type_comp_2 in category chem_comp_link where the appropriate data item
	 *  is indicated by the value of  attribute atom_3_comp_id) in category chem_comp_angle.
	 */
	public java.lang.String getAtom_id_3() 
	{
		return atom_id_3;
	}
 
	public void setAtom_id_3(java.lang.String atom_id_3)
	{
		this.atom_id_3 = atom_id_3;
	}

 	protected java.lang.String link_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_link in the CHEM_LINK
	 *  category.
	 */
	public java.lang.String getLink_id() 
	{
		return link_id;
	}
 
	public void setLink_id(java.lang.String link_id)
	{
		this.link_id = link_id;
	}

 	protected java.lang.Float value_angle;


	/**
	 *  The value that should be taken as the target value for the angle
	 *  associated with the specified atoms, expressed in degrees.
	 */
	public java.lang.Float getValue_angle() 
	{
		return value_angle;
	}
 
	public void setValue_angle(java.lang.Float value_angle)
	{
		this.value_angle = value_angle;
	}

 	protected java.lang.Float value_angle_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value_angle in category chem_link_angle.
	 */
	public java.lang.Float getValue_angle_esd() 
	{
		return value_angle_esd;
	}
 
	public void setValue_angle_esd(java.lang.Float value_angle_esd)
	{
		this.value_angle_esd = value_angle_esd;
	}

 	protected java.lang.Float value_dist;


	/**
	 *  The value that should be taken as the target value for the angle
	 *  associated with the specified atoms, expressed as the distance
	 *  between the atoms specified by  attribute atom_id_1 in category chem_comp_angle and
	 *  attribute atom_id_3 in category chem_comp_angle.
	 */
	public java.lang.Float getValue_dist() 
	{
		return value_dist;
	}
 
	public void setValue_dist(java.lang.Float value_dist)
	{
		this.value_dist = value_dist;
	}

 	protected java.lang.Float value_dist_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute value_dist in category chem_comp_angle.
	 */
	public java.lang.Float getValue_dist_esd() 
	{
		return value_dist_esd;
	}
 
	public void setValue_dist_esd(java.lang.Float value_dist_esd)
	{
		this.value_dist_esd = value_dist_esd;
	}

 }
