package org.pdb.beans;

/**
 *  Data items in the CHEM_LINK_TOR category record details about
 *  the torsion angles in a link between two chemical components.
 *  As torsion angles can have more than one target value, the
 *  target values are specified in the CHEM_LINK_TOR_VALUE category.
 */
public class Chem_link_tor 
{
		protected java.lang.String atom_1_comp_id;


	/**
	 *  This data item indicates whether atom 1 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_1_comp_id() 
	{
		return atom_1_comp_id;
	}
 
	public void setAtom_1_comp_id(java.lang.String atom_1_comp_id)
	{
		this.atom_1_comp_id = atom_1_comp_id;
	}

 	protected java.lang.String atom_2_comp_id;


	/**
	 *  This data item indicates whether atom 2 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_2_comp_id() 
	{
		return atom_2_comp_id;
	}
 
	public void setAtom_2_comp_id(java.lang.String atom_2_comp_id)
	{
		this.atom_2_comp_id = atom_2_comp_id;
	}

 	protected java.lang.String atom_3_comp_id;


	/**
	 *  This data item indicates whether atom 3 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_3_comp_id() 
	{
		return atom_3_comp_id;
	}
 
	public void setAtom_3_comp_id(java.lang.String atom_3_comp_id)
	{
		this.atom_3_comp_id = atom_3_comp_id;
	}

 	protected java.lang.String atom_4_comp_id;


	/**
	 *  This data item indicates whether atom 4 is found in the first
	 *  or the second of the two components connected by the link.
	 */
	public java.lang.String getAtom_4_comp_id() 
	{
		return atom_4_comp_id;
	}
 
	public void setAtom_4_comp_id(java.lang.String atom_4_comp_id)
	{
		this.atom_4_comp_id = atom_4_comp_id;
	}

 	protected java.lang.String atom_id_1;


	/**
	 *  The ID of the first of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific chemical component, it is not a child in the linkage
	 *  sense.
	 */
	public java.lang.String getAtom_id_1() 
	{
		return atom_id_1;
	}
 
	public void setAtom_id_1(java.lang.String atom_id_1)
	{
		this.atom_id_1 = atom_id_1;
	}

 	protected java.lang.String atom_id_2;


	/**
	 *  The ID of the second of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific chemical component, it is not a child in the linkage
	 *  sense.
	 */
	public java.lang.String getAtom_id_2() 
	{
		return atom_id_2;
	}
 
	public void setAtom_id_2(java.lang.String atom_id_2)
	{
		this.atom_id_2 = atom_id_2;
	}

 	protected java.lang.String atom_id_3;


	/**
	 *  The ID of the third of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific chemical component, it is not a child in the linkage
	 *  sense.
	 */
	public java.lang.String getAtom_id_3() 
	{
		return atom_id_3;
	}
 
	public void setAtom_id_3(java.lang.String atom_id_3)
	{
		this.atom_id_3 = atom_id_3;
	}

 	protected java.lang.String atom_id_4;


	/**
	 *  The ID of the fourth of the four atoms that define the torsion
	 *  angle.
	 *  
	 *  As this data item does not point to a specific atom in a
	 *  specific chemical component, it is not a child in the linkage
	 *  sense.
	 */
	public java.lang.String getAtom_id_4() 
	{
		return atom_id_4;
	}
 
	public void setAtom_id_4(java.lang.String atom_id_4)
	{
		this.atom_id_4 = atom_id_4;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category chem_link_tor must uniquely identify a
	 *  record in the CHEM_LINK_TOR list.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String link_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_link in the CHEM_LINK
	 *  category.
	 */
	public java.lang.String getLink_id() 
	{
		return link_id;
	}
 
	public void setLink_id(java.lang.String link_id)
	{
		this.link_id = link_id;
	}

 }
