package org.pdb.beans;

/**
 *  Data items in the CHEMICAL_CONN_ATOM category would not, in
 *  general, be used in a macromolecular CIF. See instead the
 *  ENTITY data items.
 *  
 *  Data items in the CHEMICAL_CONN_ATOM and CHEMICAL_CONN_BOND
 *  categories record details about the two-dimensional (2D)
 *  chemical structure of the molecular species. They allow
 *  a 2D chemical diagram to be reconstructed for use in a
 *  publication or in a database search for structural and
 *  substructural relationships.
 *  
 *  The CHEMICAL_CONN_ATOM data items provide information about the
 *  chemical properties of the atoms in the structure. In cases
 *  where crystallographic and molecular symmetry elements coincide,
 *  they must also contain symmetry-generated atoms, so that the
 *  CHEMICAL_CONN_ATOM and CHEMICAL_CONN_BOND data items will always
 *  describe a complete chemical entity.
 *  
 * <pre>
 *  Example 1 - based on data set DPTD of Yamin, Suwandi, Fun, Sivakumar &
 *  bin Shawkataly [Acta Cryst. (1996), C52, 951-953].
 *  <PDBx:chemical_conn_atomCategory>
 *  <PDBx:chemical_conn_atom number="1">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.39</PDBx:display_x>
 *  <PDBx:display_y>.81</PDBx:display_y>
 *  <PDBx:NCA>1</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="2">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.39</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="3">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:display_x>.14</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="4">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.33</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="5">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.11</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="6">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.03</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="7">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.03</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="8">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.11</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="9">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.54</PDBx:display_x>
 *  <PDBx:display_y>.81</PDBx:display_y>
 *  <PDBx:NCA>1</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="10">
 *  <PDBx:type_symbol>S</PDBx:type_symbol>
 *  <PDBx:display_x>.54</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="11">
 *  <PDBx:type_symbol>N</PDBx:type_symbol>
 *  <PDBx:display_x>.80</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="12">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.60</PDBx:display_x>
 *  <PDBx:display_y>.88</PDBx:display_y>
 *  <PDBx:NCA>3</PDBx:NCA>
 *  <PDBx:NH>0</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="13">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.84</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="14">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.91</PDBx:display_x>
 *  <PDBx:display_y>.96</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="15">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.91</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  <PDBx:chemical_conn_atom number="16">
 *  <PDBx:type_symbol>C</PDBx:type_symbol>
 *  <PDBx:display_x>.84</PDBx:display_x>
 *  <PDBx:display_y>.80</PDBx:display_y>
 *  <PDBx:NCA>2</PDBx:NCA>
 *  <PDBx:NH>2</PDBx:NH>
 *  </PDBx:chemical_conn_atom>
 *  </PDBx:chemical_conn_atomCategory>
 * </pre>
 */
public class Chemical_conn_atom 
{
		protected java.lang.Integer NCA;


	/**
	 *  The number of connected atoms excluding terminal hydrogen atoms.
	 */
	public java.lang.Integer getNCA() 
	{
		return NCA;
	}
 
	public void setNCA(java.lang.Integer NCA)
	{
		this.NCA = NCA;
	}

 	protected java.lang.Integer NH;


	/**
	 *  The total number of hydrogen atoms attached to this atom,
	 *  regardless of whether they are included in the refinement or
	 *  the ATOM_SITE list. This number is the same as
	 *  attribute attached_hydrogens in category atom_site only if none of the hydrogen
	 *  atoms appear in the ATOM_SITE list.
	 */
	public java.lang.Integer getNH() 
	{
		return NH;
	}
 
	public void setNH(java.lang.Integer NH)
	{
		this.NH = NH;
	}

 	protected java.lang.Integer charge;


	/**
	 *  The net integer charge assigned to this atom. This is the
	 *  formal charge assignment normally found in chemical diagrams.
	 *  for an ammonium nitrogen
	 *  1
	 *  for a chloride ion
	 *  -1
	 */
	public java.lang.Integer getCharge() 
	{
		return charge;
	}
 
	public void setCharge(java.lang.Integer charge)
	{
		this.charge = charge;
	}

 	protected java.lang.Float display_x;


	/**
	 *  The 2D Cartesian x coordinate of the position of this atom in a
	 *  recognizable chemical diagram. The coordinate origin is at the
	 *  lower left corner, the x axis is horizontal and the y axis
	 *  is vertical. The coordinates must lie in the range 0.0 to 1.0.
	 *  These coordinates can be obtained from projections of a suitable
	 *  uncluttered view of the molecular structure.
	 */
	public java.lang.Float getDisplay_x() 
	{
		return display_x;
	}
 
	public void setDisplay_x(java.lang.Float display_x)
	{
		this.display_x = display_x;
	}

 	protected java.lang.Float display_y;


	/**
	 *  The 2D Cartesian y coordinate of the position of this atom in a
	 *  recognizable chemical diagram. The coordinate origin is at the
	 *  lower left corner, the x axis is horizontal and the y axis
	 *  is vertical. The coordinates must lie in the range 0.0 to 1.0.
	 *  These coordinates can be obtained from projections of a suitable
	 *  uncluttered view of the molecular structure.
	 */
	public java.lang.Float getDisplay_y() 
	{
		return display_y;
	}
 
	public void setDisplay_y(java.lang.Float display_y)
	{
		this.display_y = display_y;
	}

 	protected java.lang.Integer number;


	/**
	 *  The chemical sequence number to be associated with this atom.
	 *  Within an ATOM_SITE list, this number must match one of
	 *  the  attribute chemical_conn_number in category atom_site values.
	 */
	public java.lang.Integer getNumber() 
	{
		return number;
	}
 
	public void setNumber(java.lang.Integer number)
	{
		this.number = number;
	}

 	protected java.lang.String type_symbol;


	/**
	 *  This data item is a pointer to  attribute symbol in category atom_type in the
	 *  ATOM_TYPE category.
	 */
	public java.lang.String getType_symbol() 
	{
		return type_symbol;
	}
 
	public void setType_symbol(java.lang.String type_symbol)
	{
		this.type_symbol = type_symbol;
	}

 }
