package org.pdb.beans;

/**
 *  Data items in the CHEMICAL_CONN_BOND category would not, in
 *  general, be used in a macromolecular CIF. See instead the
 *  ENTITY data items.
 *  
 *  Data items in the CHEMICAL_CONN_ATOM and CHEMICAL_CONN_BOND
 *  categories record details about the two-dimensional (2D)
 *  chemical structure of the molecular species. They allow a
 *  2D chemical diagram to be reconstructed for use in a
 *  publication or in a database search for structural and
 *  substructural relationships.
 *  
 *  The CHEMICAL_CONN_BOND data items specify the connections
 *  between the atoms in the CHEMICAL_CONN_ATOM list and the nature
 *  of the chemical bond between these atoms.
 *  
 * <pre>
 *  Example 1 - based on data set DPTD of Yamin, Suwandi, Fun, Sivakumar &
 *  bin Shawkataly [Acta Cryst. (1996), C52, 951-953].
 *  <PDBx:chemical_conn_bondCategory>
 *  <PDBx:chemical_conn_bond atom_1="4" atom_2="1">
 *  <PDBx:type>doub</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="4" atom_2="3">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="4" atom_2="2">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="5" atom_2="3">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="6" atom_2="5">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="7" atom_2="6">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="8" atom_2="7">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="8" atom_2="3">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="10" atom_2="2">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="12" atom_2="9">
 *  <PDBx:type>doub</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="12" atom_2="11">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="12" atom_2="10">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="13" atom_2="11">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="14" atom_2="13">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="15" atom_2="14">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="16" atom_2="15">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="16" atom_2="11">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="17" atom_2="5">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="18" atom_2="5">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="19" atom_2="6">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="20" atom_2="6">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="21" atom_2="7">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="22" atom_2="7">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="23" atom_2="8">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="24" atom_2="8">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="25" atom_2="13">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="26" atom_2="13">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="27" atom_2="14">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="28" atom_2="14">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="29" atom_2="15">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="30" atom_2="15">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="31" atom_2="16">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="32" atom_2="16">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  </PDBx:chemical_conn_bondCategory>
 * </pre>
 */
public class Chemical_conn_bond 
{
		protected java.lang.Integer atom_1;


	/**
	 *  This data item is a pointer to  attribute number in category chemical_conn_atom in the
	 *  CHEMICAL_CONN_ATOM category.
	 */
	public java.lang.Integer getAtom_1() 
	{
		return atom_1;
	}
 
	public void setAtom_1(java.lang.Integer atom_1)
	{
		this.atom_1 = atom_1;
	}

 	protected java.lang.Integer atom_2;


	/**
	 *  This data item is a pointer to  attribute number in category chemical_conn_atom in the
	 *  CHEMICAL_CONN_ATOM category.
	 */
	public java.lang.Integer getAtom_2() 
	{
		return atom_2;
	}
 
	public void setAtom_2(java.lang.Integer atom_2)
	{
		this.atom_2 = atom_2;
	}

 	protected java.lang.String type;


	/**
	 *  The chemical bond type associated with the connection between
	 *  the two sites  attribute atom_1 in category chemical_conn_bond and
	 *  attribute atom_2 in category chemical_conn_bond.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
