package org.pdb.beans;

/**
 *  Data items in the CHEMICAL_FORMULA category would not, in
 *  general, be used in a macromolecular CIF. See instead the
 *  ENTITY data items.
 *  
 *  Data items in the CHEMICAL_FORMULA category specify the
 *  composition and chemical properties of the compound. The formula
 *  data items must agree with those that specify the density,
 *  unit-cell and Z values.
 *  
 *  The following rules apply to the construction of the data items
 *  _chemical_formula.analytical, _chemical_formula.structural and
 *  attribute sum in category chemical_formula.  For the data item
 *  attribute moiety in category chemical_formula the formula construction is broken up
 *  into residues or moieties, i.e. groups of atoms that form a
 *  molecular unit or molecular ion. The rules given below apply
 *  within each moiety but different requirements apply to the way
 *  that moieties are connected (see  attribute moiety).
 *  in category chemical_formula
 *  (1) Only recognized element symbols may be used.
 *  
 *  (2) Each element symbol is followed by a 'count' number. A count
 *  of '1' may be omitted.
 *  
 *  (3) A space or parenthesis must separate each cluster of (element
 *  symbol + count).
 *  
 *  (4) Where a group of elements is enclosed in parentheses, the
 *  multiplier for the group must follow the closing parenthesis.
 *  That is, all element and group multipliers are assumed to be
 *  printed as subscripted numbers. (An exception to this rule
 *  exists for  attribute moiety in category chemical_formula formulae where pre- and
 *  post-multipliers are permitted for molecular units.)
 *  
 *  (5) Unless the elements are ordered in a manner that corresponds
 *  to their chemical structure, as in
 *  attribute structural in category chemical_formula the order of the elements within
 *  any group or moiety should be:  C, then H, then the other
 *  elements in alphabetical order of their symbol. This is the
 *  'Hill' system used by Chemical Abstracts. This ordering is
 *  used in _chemical_formula.moiety and _chemical_formula.sum.
 *  
 * <pre>
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer [(1991).
 *  Acta Cryst. C47, 2276-2277].
 *  <PDBx:chemical_formulaCategory>
 *  <PDBx:chemical_formula entry_id="TOZ">
 *  <PDBx:moiety>C18 H25 N O3</PDBx:moiety>
 *  <PDBx:sum>C18 H25 N O3</PDBx:sum>
 *  <PDBx:weight>303.40</PDBx:weight>
 *  </PDBx:chemical_formula>
 *  </PDBx:chemical_formulaCategory>
 * </pre>
 */
public class Chemical_formula 
{
		protected java.lang.String analytical;


	/**
	 *  Formula determined by standard chemical analysis including trace
	 *  elements. See the CHEMICAL_FORMULA category description for
	 *  rules for writing chemical formulae. Parentheses are used only
	 *  for standard uncertainties (estimated standard deviations).
	 *  Fe2.45(2)  Ni1.60(3)  S4
	 */
	public java.lang.String getAnalytical() 
	{
		return analytical;
	}
 
	public void setAnalytical(java.lang.String analytical)
	{
		this.analytical = analytical;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String iupac;


	/**
	 *  Formula expressed in conformance with IUPAC rules for inorganic
	 *  and metal-organic compounds where these conflict with the rules
	 *  for any other CHEMICAL_FORMULA entries. Typically used for
	 *  formatting a formula in accordance with journal rules. This
	 *  should appear in the data block in addition to the most
	 *  appropriate of the other CHEMICAL_FORMULA data names.
	 *  
	 *  Ref: IUPAC (1990). Nomenclature of Inorganic Chemistry.
	 *  Oxford: Blackwell Scientific Publications.
	 *  [Co Re (C12 H22 P)2 (C O)6].0.5C H3 O H
	 */
	public java.lang.String getIupac() 
	{
		return iupac;
	}
 
	public void setIupac(java.lang.String iupac)
	{
		this.iupac = iupac;
	}

 	protected java.lang.String moiety;


	/**
	 *  Formula with each discrete bonded residue or ion shown as a
	 *  separate moiety. See the CHEMICAL_FORMULA category description
	 *  for rules for writing chemical formulae. In addition to the
	 *  general formulae requirements, the following rules apply:
	 *  (1) Moieties are separated by commas ','.
	 *  (2) The order of elements within a moiety follows general rule
	 *  (5) in the CHEMICAL_FORMULA category description.
	 *  (3) Parentheses are not used within moieties but may surround
	 *  a moiety. Parentheses may not be nested.
	 *  (4) Charges should be placed at the end of the moiety. The
	 *  charge '+' or '-' may be preceded by a numerical multiplier
	 *  and should be separated from the last (element symbol +
	 *  count) by a space. Pre- or post-multipliers may be used for
	 *  individual moieties.
	 *  C7 H4 Cl Hg N O3 S
	 *  C12 H17 N4 O S 1+, C6 H2 N3 O7 1-
	 *  C12 H16 N2 O6, 5(H2 O1)
	 *  (Cd 2+)3, (C6 N6 Cr 3-)2, 2(H2 O)
	 */
	public java.lang.String getMoiety() 
	{
		return moiety;
	}
 
	public void setMoiety(java.lang.String moiety)
	{
		this.moiety = moiety;
	}

 	protected java.lang.String structural;


	/**
	 *  See the CHEMICAL_FORMULA category description for the rules for
	 *  writing chemical formulae for inorganics, organometallics, metal
	 *  complexes etc., in which bonded groups are preserved as
	 *  discrete entities within parentheses, with post-multipliers as
	 *  required. The order of the elements should give as much
	 *  information as possible about the chemical structure.
	 *  Parentheses may be used and nested as required. This formula
	 *  should correspond to the structure as actually reported, i.e.
	 *  trace elements not included in atom-type and atom-site data
	 *  should not be included in this formula (see also
	 *  attribute analytical) in category chemical_formula.
	 *  Ca ((Cl O3)2 O)2 (H2 O)6
	 *  (Pt (N H3)2 (C5 H7 N3 O)2) (Cl O4)2
	 */
	public java.lang.String getStructural() 
	{
		return structural;
	}
 
	public void setStructural(java.lang.String structural)
	{
		this.structural = structural;
	}

 	protected java.lang.String sum;


	/**
	 *  See the CHEMICAL_FORMULA category description for the rules
	 *  for writing chemical formulae in which all discrete bonded
	 *  residues and ions are summed over the constituent elements,
	 *  following the ordering given in general rule (5) in the
	 *  CHEMICAL_FORMULA category description. Parentheses are not
	 *  normally used.
	 *  C18 H19 N7 O8 S
	 */
	public java.lang.String getSum() 
	{
		return sum;
	}
 
	public void setSum(java.lang.String sum)
	{
		this.sum = sum;
	}

 	protected java.lang.Float weight;


	/**
	 *  Formula mass in daltons. This mass should correspond to the
	 *  formulae given under  attribute structural,
	 *  in category chemical_formula _chemical_formula.moiety or _chemical_formula.sum and,
	 *  together with the Z value and cell parameters, should
	 *  yield the density given as  attribute density_diffrn in category exptl_crystal.
	 */
	public java.lang.Float getWeight() 
	{
		return weight;
	}
 
	public void setWeight(java.lang.Float weight)
	{
		this.weight = weight;
	}

 	protected java.lang.Float weight_meas;


	/**
	 *  Formula mass in daltons measured by a non-diffraction experiment.
	 */
	public java.lang.Float getWeight_meas() 
	{
		return weight_meas;
	}
 
	public void setWeight_meas(java.lang.Float weight_meas)
	{
		this.weight_meas = weight_meas;
	}

 }
