package org.pdb.beans;

/**
 *  Data items in the CITATION category record details about the
 *  literature cited as being relevant to the contents of the data
 *  block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:citationCategory>
 *  <PDBx:citation id="primary">
 *  <PDBx:coordinate_linkage>yes</PDBx:coordinate_linkage>
 *  <PDBx:title> Crystallographic analysis of a complex between human
 *  immunodeficiency virus type 1 protease and acetyl-pepstatin
 *  at 2.0-Angstroms resolution.</PDBx:title>
 *  <PDBx:country>US</PDBx:country>
 *  <PDBx:journal_abbrev>J. Biol. Chem.</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>265</PDBx:journal_volume>
 *  <PDBx:page_first>14209</PDBx:page_first>
 *  <PDBx:page_last>14219</PDBx:page_last>
 *  <PDBx:year>1990</PDBx:year>
 *  <PDBx:journal_id_ASTM>HBCHA3</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0021-9258</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>071</PDBx:journal_id_CSD>
 *  <PDBx:details> The publication that directly relates to this coordinate
 *  set.</PDBx:details>
 *  </PDBx:citation>
 *  <PDBx:citation id="2">
 *  <PDBx:coordinate_linkage>no</PDBx:coordinate_linkage>
 *  <PDBx:title> Three-dimensional structure of aspartyl-protease from human
 *  immunodeficiency virus HIV-1.</PDBx:title>
 *  <PDBx:country>UK</PDBx:country>
 *  <PDBx:journal_abbrev>Nature</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>337</PDBx:journal_volume>
 *  <PDBx:page_first>615</PDBx:page_first>
 *  <PDBx:page_last>619</PDBx:page_last>
 *  <PDBx:year>1989</PDBx:year>
 *  <PDBx:journal_id_ASTM>NATUAS</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0028-0836</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>006</PDBx:journal_id_CSD>
 *  <PDBx:details> Determination of the structure of the unliganded enzyme.</PDBx:details>
 *  </PDBx:citation>
 *  <PDBx:citation id="3">
 *  <PDBx:coordinate_linkage>no</PDBx:coordinate_linkage>
 *  <PDBx:title> Crystallization of the aspartylprotease from human
 *  immunodeficiency virus, HIV-1.</PDBx:title>
 *  <PDBx:country>US</PDBx:country>
 *  <PDBx:journal_abbrev>J. Biol. Chem.</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>264</PDBx:journal_volume>
 *  <PDBx:page_first>1919</PDBx:page_first>
 *  <PDBx:page_last>1921</PDBx:page_last>
 *  <PDBx:year>1989</PDBx:year>
 *  <PDBx:journal_id_ASTM>HBCHA3</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0021-9258</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>071</PDBx:journal_id_CSD>
 *  <PDBx:details> Crystallization of the unliganded enzyme.</PDBx:details>
 *  </PDBx:citation>
 *  <PDBx:citation id="4">
 *  <PDBx:coordinate_linkage>no</PDBx:coordinate_linkage>
 *  <PDBx:title> Human immunodeficiency virus protease. Bacterial expression
 *  and characterization of the purified aspartic protease.</PDBx:title>
 *  <PDBx:country>US</PDBx:country>
 *  <PDBx:journal_abbrev>J. Biol. Chem.</PDBx:journal_abbrev>
 *  <PDBx:journal_volume>264</PDBx:journal_volume>
 *  <PDBx:page_first>2307</PDBx:page_first>
 *  <PDBx:page_last>2312</PDBx:page_last>
 *  <PDBx:year>1989</PDBx:year>
 *  <PDBx:journal_id_ASTM>HBCHA3</PDBx:journal_id_ASTM>
 *  <PDBx:journal_id_ISSN>0021-9258</PDBx:journal_id_ISSN>
 *  <PDBx:journal_id_CSD>071</PDBx:journal_id_CSD>
 *  <PDBx:details> Expression and purification of the enzyme.</PDBx:details>
 *  </PDBx:citation>
 *  </PDBx:citationCategory>
 * </pre>
 */
public class Citation 
{
		protected java.lang.String abstract_;


	/**
	 *  Abstract for the citation. This is used most when the
	 *  citation is extracted from a bibliographic database that
	 *  contains full text or abstract information.
	 */
	public java.lang.String getAbstract_() 
	{
		return abstract_;
	}
 
	public void setAbstract_(java.lang.String abstract_)
	{
		this.abstract_ = abstract_;
	}

 	protected java.lang.String abstract_id_CAS;


	/**
	 *  The Chemical Abstracts Service (CAS) abstract identifier;
	 *  relevant for journal articles.
	 */
	public java.lang.String getAbstract_id_CAS() 
	{
		return abstract_id_CAS;
	}
 
	public void setAbstract_id_CAS(java.lang.String abstract_id_CAS)
	{
		this.abstract_id_CAS = abstract_id_CAS;
	}

 	protected java.lang.String book_id_ISBN;


	/**
	 *  The International Standard Book Number (ISBN) code assigned to
	 *  the book cited; relevant for books or book chapters.
	 */
	public java.lang.String getBook_id_ISBN() 
	{
		return book_id_ISBN;
	}
 
	public void setBook_id_ISBN(java.lang.String book_id_ISBN)
	{
		this.book_id_ISBN = book_id_ISBN;
	}

 	protected java.lang.String book_publisher;


	/**
	 *  The name of the publisher of the citation; relevant
	 *  for books or book chapters.
	 *  John Wiley and Sons
	 */
	public java.lang.String getBook_publisher() 
	{
		return book_publisher;
	}
 
	public void setBook_publisher(java.lang.String book_publisher)
	{
		this.book_publisher = book_publisher;
	}

 	protected java.lang.String book_publisher_city;


	/**
	 *  The location of the publisher of the citation; relevant
	 *  for books or book chapters.
	 *  London
	 */
	public java.lang.String getBook_publisher_city() 
	{
		return book_publisher_city;
	}
 
	public void setBook_publisher_city(java.lang.String book_publisher_city)
	{
		this.book_publisher_city = book_publisher_city;
	}

 	protected java.lang.String book_title;


	/**
	 *  The title of the book in which the citation appeared; relevant
	 *  for books or book chapters.
	 */
	public java.lang.String getBook_title() 
	{
		return book_title;
	}
 
	public void setBook_title(java.lang.String book_title)
	{
		this.book_title = book_title;
	}

 	protected java.lang.String coordinate_linkage;


	/**
	 *  attribute coordinate_linkage in category citation states whether this citation
	 *  is concerned with precisely the set of coordinates given in the
	 *  data block. If, for instance, the publication described the same
	 *  structure, but the coordinates had undergone further refinement
	 *  prior to the creation of the data block, the value of this data
	 *  item would be 'no'.
	 */
	public java.lang.String getCoordinate_linkage() 
	{
		return coordinate_linkage;
	}
 
	public void setCoordinate_linkage(java.lang.String coordinate_linkage)
	{
		this.coordinate_linkage = coordinate_linkage;
	}

 	protected java.lang.String country;


	/**
	 *  The country of publication; relevant for books
	 *  and book chapters.
	 */
	public java.lang.String getCountry() 
	{
		return country;
	}
 
	public void setCountry(java.lang.String country)
	{
		this.country = country;
	}

 	protected java.lang.String database_id_CSD;


	/**
	 *  Identifier ('refcode') of the database record in the Cambridge
	 *  Structural Database that contains details of the cited structure.
	 *  LEKKUH
	 */
	public java.lang.String getDatabase_id_CSD() 
	{
		return database_id_CSD;
	}
 
	public void setDatabase_id_CSD(java.lang.String database_id_CSD)
	{
		this.database_id_CSD = database_id_CSD;
	}

 	protected java.lang.Integer database_id_Medline;


	/**
	 *  Accession number used by Medline to categorize a specific
	 *  bibliographic entry.
	 *  89064067
	 */
	public java.lang.Integer getDatabase_id_Medline() 
	{
		return database_id_Medline;
	}
 
	public void setDatabase_id_Medline(java.lang.Integer database_id_Medline)
	{
		this.database_id_Medline = database_id_Medline;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the relationship
	 *  of the contents of the data block to the literature item cited.
	 *  citation relates to this precise
	 *  coordinate set
	 *  citation relates to earlier low-resolution
	 *  structure
	 *  citation relates to further refinement of
	 *  structure reported in citation 2
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category citation must uniquely identify a record in the
	 *  CITATION list.
	 *  
	 *  The  attribute id in category citation 'primary' should be used to indicate the
	 *  citation that the author(s) consider to be the most pertinent to
	 *  the contents of the data block.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  primary
	 *  1
	 *  2
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String journal_abbrev;


	/**
	 *  Abbreviated name of the cited journal as given in the
	 *  Chemical Abstracts Service Source Index.
	 *  J. Mol. Biol.
	 */
	public java.lang.String getJournal_abbrev() 
	{
		return journal_abbrev;
	}
 
	public void setJournal_abbrev(java.lang.String journal_abbrev)
	{
		this.journal_abbrev = journal_abbrev;
	}

 	protected java.lang.String journal_full;


	/**
	 *  Full name of the cited journal; relevant for journal articles.
	 *  Journal of Molecular Biology
	 */
	public java.lang.String getJournal_full() 
	{
		return journal_full;
	}
 
	public void setJournal_full(java.lang.String journal_full)
	{
		this.journal_full = journal_full;
	}

 	protected java.lang.String journal_id_ASTM;


	/**
	 *  The American Society for Testing and Materials (ASTM) code
	 *  assigned to the journal cited (also referred to as the CODEN
	 *  designator of the Chemical Abstracts Service); relevant for
	 *  journal articles.
	 */
	public java.lang.String getJournal_id_ASTM() 
	{
		return journal_id_ASTM;
	}
 
	public void setJournal_id_ASTM(java.lang.String journal_id_ASTM)
	{
		this.journal_id_ASTM = journal_id_ASTM;
	}

 	protected java.lang.String journal_id_CSD;


	/**
	 *  The Cambridge Structural Database (CSD) code assigned to the
	 *  journal cited; relevant for journal articles. This is also the
	 *  system used at the Protein Data Bank (PDB).
	 *  0070
	 */
	public java.lang.String getJournal_id_CSD() 
	{
		return journal_id_CSD;
	}
 
	public void setJournal_id_CSD(java.lang.String journal_id_CSD)
	{
		this.journal_id_CSD = journal_id_CSD;
	}

 	protected java.lang.String journal_id_ISSN;


	/**
	 *  The International Standard Serial Number (ISSN) code assigned to
	 *  the journal cited; relevant for journal articles.
	 */
	public java.lang.String getJournal_id_ISSN() 
	{
		return journal_id_ISSN;
	}
 
	public void setJournal_id_ISSN(java.lang.String journal_id_ISSN)
	{
		this.journal_id_ISSN = journal_id_ISSN;
	}

 	protected java.lang.String journal_issue;


	/**
	 *  Issue number of the journal cited; relevant for journal
	 *  articles.
	 *  2
	 */
	public java.lang.String getJournal_issue() 
	{
		return journal_issue;
	}
 
	public void setJournal_issue(java.lang.String journal_issue)
	{
		this.journal_issue = journal_issue;
	}

 	protected java.lang.String journal_volume;


	/**
	 *  Volume number of the journal cited; relevant for journal
	 *  articles.
	 *  174
	 */
	public java.lang.String getJournal_volume() 
	{
		return journal_volume;
	}
 
	public void setJournal_volume(java.lang.String journal_volume)
	{
		this.journal_volume = journal_volume;
	}

 	protected java.lang.String language;


	/**
	 *  Language in which the cited article is written.
	 *  German
	 */
	public java.lang.String getLanguage() 
	{
		return language;
	}
 
	public void setLanguage(java.lang.String language)
	{
		this.language = language;
	}

 	protected java.lang.String page_first;


	/**
	 *  The first page of the citation; relevant for journal
	 *  articles, books and book chapters.
	 */
	public java.lang.String getPage_first() 
	{
		return page_first;
	}
 
	public void setPage_first(java.lang.String page_first)
	{
		this.page_first = page_first;
	}

 	protected java.lang.String page_last;


	/**
	 *  The last page of the citation; relevant for journal
	 *  articles, books and book chapters.
	 */
	public java.lang.String getPage_last() 
	{
		return page_last;
	}
 
	public void setPage_last(java.lang.String page_last)
	{
		this.page_last = page_last;
	}

 	protected java.lang.String pdbx_database_id_DOI;


	/**
	 *  Document Object Identifier used by doi.org to uniquely
	 *  specify bibliographic entry.
	 *  DOI:10.2345/S1384107697000225
	 */
	public java.lang.String getPdbx_database_id_DOI() 
	{
		return pdbx_database_id_DOI;
	}
 
	public void setPdbx_database_id_DOI(java.lang.String pdbx_database_id_DOI)
	{
		this.pdbx_database_id_DOI = pdbx_database_id_DOI;
	}

 	protected java.lang.Integer pdbx_database_id_PubMed;


	/**
	 *  Ascession number used by PubMed to categorize a specific
	 *  bibliographic entry.
	 *  12627512
	 */
	public java.lang.Integer getPdbx_database_id_PubMed() 
	{
		return pdbx_database_id_PubMed;
	}
 
	public void setPdbx_database_id_PubMed(java.lang.Integer pdbx_database_id_PubMed)
	{
		this.pdbx_database_id_PubMed = pdbx_database_id_PubMed;
	}

 	protected java.lang.String title;


	/**
	 *  The title of the citation; relevant for journal articles, books
	 *  and book chapters.
	 *  Structure of diferric duck ovotransferrin
	 *  at 2.35 \%A resolution.
	 */
	public java.lang.String getTitle() 
	{
		return title;
	}
 
	public void setTitle(java.lang.String title)
	{
		this.title = title;
	}

 	protected java.lang.String unpublished_flag;


	/**
	 *  Flag to indicate that this citation will not be published.
	 */
	public java.lang.String getUnpublished_flag() 
	{
		return unpublished_flag;
	}
 
	public void setUnpublished_flag(java.lang.String unpublished_flag)
	{
		this.unpublished_flag = unpublished_flag;
	}

 	protected java.lang.Integer year;


	/**
	 *  The year of the citation; relevant for journal articles, books
	 *  and book chapters.
	 *  1984
	 */
	public java.lang.Integer getYear() 
	{
		return year;
	}
 
	public void setYear(java.lang.Integer year)
	{
		this.year = year;
	}

 }
