package org.pdb.beans;

/**
 *  Data items in the CITATION_AUTHOR category record details
 *  about the authors associated with the citations in the
 *  CITATION list.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:citation_authorCategory>
 *  <PDBx:citation_author citation_id="primary" ordinal="1" name="Fitzgerald, P.M.D."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="2" name="McKeever, B.M."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="3" name="Van Middlesworth, J.F."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="4" name="Springer, J.P."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="5" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="6" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="7" name="Herber, W.K."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="8" name="Dixon, R.A.F."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="9" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="1" name="Navia, M.A."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="2" name="Fitzgerald, P.M.D."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="3" name="McKeever, B.M."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="4" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="5" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="6" name="Herber, W.K."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="7" name="Sigal, I.S."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="8" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="9" name="Springer, J.P."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="1" name="McKeever, B.M."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="2" name="Navia, M.A."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="3" name="Fitzgerald, P.M.D."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="4" name="Springer, J.P."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="5" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="6" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="7" name="Herber, W.K."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="8" name="Sigal, I.S."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="9" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="1" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="2" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="3" name="Davis, L.J."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="4" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="5" name="Diehl, R.E."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="6" name="Hill, W.S."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="7" name="Dixon, R.A.F."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="8" name="Sigal, I.S."></PDBx:citation_author>
 *  </PDBx:citation_authorCategory>
 * </pre>
 */
public class Citation_author 
{
		protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id in category citation in the CITATION
	 *  category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String name;


	/**
	 *  Name of an author of the citation; relevant for journal
	 *  articles, books and book chapters.
	 *  
	 *  The family name(s), followed by a comma and including any
	 *  dynastic components, precedes the first name(s) or initial(s).
	 *  Bleary, Percival R.
	 *  O'Neil, F.K.
	 *  Van den Bossche, G.
	 *  Yang, D.-L.
	 *  Simonov, Yu.A
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.Integer ordinal;


	/**
	 *  This data item defines the order of the author's name in the
	 *  list of authors of a citation.
	 */
	public java.lang.Integer getOrdinal() 
	{
		return ordinal;
	}
 
	public void setOrdinal(java.lang.Integer ordinal)
	{
		this.ordinal = ordinal;
	}

 }
