package org.pdb.beans;

/**
 *  Data items in the DATABASE_PDB_REMARK category record details
 *  about the data block as archived by the Protein Data Bank (PDB).
 *  
 *  Some data appearing in PDB REMARK records can be
 *  algorithmically extracted into the appropriate data items
 *  in the data block.
 *  
 *  These data items are included only for consistency with older
 *  PDB format files. They should appear in a data block only if
 *  that data block was created by reformatting a PDB format file.
 *  
 *  NOTE: These remark records in this category are not uniformly
 *  annotated by the PDB and may not be consistent with
 *  nomenclature or labeling used in the entry.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:database_PDB_remarkCategory>
 *  <PDBx:database_PDB_remark id="3">
 *  <PDBx:text> REFINEMENT. BY THE RESTRAINED LEAST-SQUARES PROCEDURE OF J.
 *  KONNERT AND W. HENDRICKSON (PROGRAM *PROLSQ*).  THE R
 *  VALUE IS 0.176 FOR 12901 REFLECTIONS IN THE RESOLUTION
 *  RANGE 8.0 TO 2.0 ANGSTROMS WITH I .GT. SIGMA(I).
 *  RMS DEVIATIONS FROM IDEAL VALUES (THE VALUES OF
 *  SIGMA, IN PARENTHESES, ARE THE INPUT ESTIMATED
 *  STANDARD DEVIATIONS THAT DETERMINE THE RELATIVE
 *  WEIGHTS OF THE CORRESPONDING RESTRAINTS)
 *  DISTANCE RESTRAINTS (ANGSTROMS)
 *  BOND DISTANCE                            0.018(0.020)
 *  ANGLE DISTANCE                           0.038(0.030)
 *  PLANAR 1-4 DISTANCE                      0.043(0.040)
 *  PLANE RESTRAINT (ANGSTROMS)                0.015(0.020)
 *  CHIRAL-CENTER RESTRAINT (ANGSTROMS**3)     0.177(0.150)
 *  NON-BONDED CONTACT RESTRAINTS (ANGSTROMS)
 *  SINGLE TORSION CONTACT                   0.216(0.500)
 *  MULTIPLE TORSION CONTACT                 0.207(0.500)
 *  POSSIBLE HYDROGEN BOND                   0.245(0.500)
 *  CONFORMATIONAL TORSION ANGLE RESTRAINT (DEGREES)
 *  PLANAR (OMEGA)                             2.6(3.0)
 *  STAGGERED                                 17.4(15.0)
 *  ORTHONORMAL                               18.1(20.0)</PDBx:text>
 *  </PDBx:database_PDB_remark>
 *  <PDBx:database_PDB_remark id="4">
 *  <PDBx:text> THE TWO CHAINS OF THE DIMERIC ENZYME HAS BEEN ASSIGNED THE
 *  THE CHAIN INDICATORS *A* AND *B*.</PDBx:text>
 *  </PDBx:database_PDB_remark>
 *  </PDBx:database_PDB_remarkCategory>
 * </pre>
 */
public class Database_PDB_remark 
{
		protected java.lang.Integer id_;


	/**
	 *  A unique identifier for the PDB remark record.
	 */
	public java.lang.Integer getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.Integer id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String text;


	/**
	 *  The full text of the PDB remark record.
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 }
