package org.pdb.beans;

/**
 *  Data items in the DATABASE_PDB_REV_RECORD category record
 *  details about specific record types that were changed in a
 *  given revision of a PDB entry.
 *  
 *  These data items are assigned by the PDB database managers and
 *  should only appear in a data block if they originate from that
 *  source.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:database_PDB_rev_recordCategory>
 *  <PDBx:database_PDB_rev_record rev_num="1" type="CONECT">
 *  <PDBx:details> Error fix - incorrect connection between
 *  atoms 2312 and 2317</PDBx:details>
 *  </PDBx:database_PDB_rev_record>
 *  <PDBx:database_PDB_rev_record rev_num="2" type="MATRIX">
 *  <PDBx:details>For consistency with 1995-08-04 style-guide</PDBx:details>
 *  </PDBx:database_PDB_rev_record>
 *  <PDBx:database_PDB_rev_record rev_num="3" type="ORIGX">
 *  <PDBx:details>Based on new data from author</PDBx:details>
 *  </PDBx:database_PDB_rev_record>
 *  </PDBx:database_PDB_rev_recordCategory>
 * </pre>
 */
public class Database_PDB_rev_record 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the revision of records in
	 *  this PDB entry.
	 *  Based on new data from author
	 *  For consistency with 1995-08-04 style-guide
	 *  For consistency with structural class
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Integer rev_num;


	/**
	 *  This data item is a pointer to  attribute num in category database_PDB_rev in the
	 *  DATABASE_PDB_REV category.
	 */
	public java.lang.Integer getRev_num() 
	{
		return rev_num;
	}
 
	public void setRev_num(java.lang.Integer rev_num)
	{
		this.rev_num = rev_num;
	}

 	protected java.lang.String type;


	/**
	 *  The types of records that were changed in this revision to a
	 *  PDB entry.
	 *  CRYST1
	 *  SCALE
	 *  MTRIX
	 *  ATOM
	 *  HETATM
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
