package org.pdb.beans;

/**
 *  Data items in the DIFFRN category record details about the
 *  diffraction data and their measurement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrnCategory>
 *  <PDBx:diffrn id="Set1">
 *  <PDBx:ambient_temp>293(3).</PDBx:ambient_temp>
 *  <PDBx:ambient_environment> Mother liquor from the reservoir of the vapor diffusion experiment, mounted in room air</PDBx:ambient_environment>
 *  <PDBx:crystal_support> 0.7 mm glass capillary, sealed with dental wax</PDBx:crystal_support>
 *  <PDBx:crystal_treatment> Equilibrated in rotating anode radiation enclosure for
 *  18 hours prior to beginning of data collection</PDBx:crystal_treatment>
 *  </PDBx:diffrn>
 *  </PDBx:diffrnCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer [(1991).
 *  Acta Cryst. C47, 2276-2277].
 *  <PDBx:diffrnCategory>
 *  <PDBx:diffrn id="d1">
 *  <PDBx:details> \q scan width (1.0 + 0.14tan\q)\&#37;, \q scan rate 1.2\&#37; per
 *  min. Background counts for 5 sec on each side every scan.</PDBx:details>
 *  <PDBx:ambient_temp>293.</PDBx:ambient_temp>
 *  </PDBx:diffrn>
 *  </PDBx:diffrnCategory>
 * </pre>
 */
public class Diffrn 
{
		protected java.lang.String ambient_environment;


	/**
	 *  The gas or liquid surrounding the sample, if not air.
	 */
	public java.lang.String getAmbient_environment() 
	{
		return ambient_environment;
	}
 
	public void setAmbient_environment(java.lang.String ambient_environment)
	{
		this.ambient_environment = ambient_environment;
	}

 	protected java.lang.Float ambient_pressure;


	/**
	 *  The mean hydrostatic pressure in kilopascals at which the
	 *  intensities were measured.
	 */
	public java.lang.Float getAmbient_pressure() 
	{
		return ambient_pressure;
	}
 
	public void setAmbient_pressure(java.lang.Float ambient_pressure)
	{
		this.ambient_pressure = ambient_pressure;
	}

 	protected java.lang.Float ambient_pressure_esd;


	/**
	 *  The estimated standard deviation of  attribute ambient_pressure in category diffrn.
	 */
	public java.lang.Float getAmbient_pressure_esd() 
	{
		return ambient_pressure_esd;
	}
 
	public void setAmbient_pressure_esd(java.lang.Float ambient_pressure_esd)
	{
		this.ambient_pressure_esd = ambient_pressure_esd;
	}

 	protected java.lang.Float ambient_pressure_gt;


	/**
	 *  The mean hydrostatic pressure in kilopascals above which
	 *  the intensities were measured.  attribute ambient_pressure_gt in category diffrn and
	 *  attribute ambient_pressure_lt in category diffrn allow a pressure range to be given.
	 *  
	 *  attribute ambient_pressure in category diffrn should always be used in
	 *  preference to these two items whenever possible.
	 */
	public java.lang.Float getAmbient_pressure_gt() 
	{
		return ambient_pressure_gt;
	}
 
	public void setAmbient_pressure_gt(java.lang.Float ambient_pressure_gt)
	{
		this.ambient_pressure_gt = ambient_pressure_gt;
	}

 	protected java.lang.Float ambient_pressure_lt;


	/**
	 *  The mean hydrostatic pressure in kilopascals below which
	 *  the intensities were measured.  attribute ambient_pressure_gt in category diffrn and
	 *  attribute ambient_pressure_lt in category diffrn allow a pressure range to be given.
	 *  
	 *  attribute ambient_pressure in category diffrn should always be used in
	 *  preference to these two items whenever possible.
	 */
	public java.lang.Float getAmbient_pressure_lt() 
	{
		return ambient_pressure_lt;
	}
 
	public void setAmbient_pressure_lt(java.lang.Float ambient_pressure_lt)
	{
		this.ambient_pressure_lt = ambient_pressure_lt;
	}

 	protected java.lang.Float ambient_temp;


	/**
	 *  The mean temperature in kelvins at which the intensities were
	 *  measured.
	 */
	public java.lang.Float getAmbient_temp() 
	{
		return ambient_temp;
	}
 
	public void setAmbient_temp(java.lang.Float ambient_temp)
	{
		this.ambient_temp = ambient_temp;
	}

 	protected java.lang.String ambient_temp_details;


	/**
	 *  A description of special aspects of temperature control during
	 *  data collection.
	 */
	public java.lang.String getAmbient_temp_details() 
	{
		return ambient_temp_details;
	}
 
	public void setAmbient_temp_details(java.lang.String ambient_temp_details)
	{
		this.ambient_temp_details = ambient_temp_details;
	}

 	protected java.lang.Float ambient_temp_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute ambient_temp in category diffrn.
	 */
	public java.lang.Float getAmbient_temp_esd() 
	{
		return ambient_temp_esd;
	}
 
	public void setAmbient_temp_esd(java.lang.Float ambient_temp_esd)
	{
		this.ambient_temp_esd = ambient_temp_esd;
	}

 	protected java.lang.Float ambient_temp_gt;


	/**
	 *  The mean temperature in kelvins above which the intensities were
	 *  measured.  _diffrn.ambient_temp_gt and _diffrn.ambient_temp_lt
	 *  allow a range of temperatures to be given.
	 *  
	 *  attribute ambient_temp in category diffrn should always be used in preference
	 *  to these two items whenever possible.
	 */
	public java.lang.Float getAmbient_temp_gt() 
	{
		return ambient_temp_gt;
	}
 
	public void setAmbient_temp_gt(java.lang.Float ambient_temp_gt)
	{
		this.ambient_temp_gt = ambient_temp_gt;
	}

 	protected java.lang.Float ambient_temp_lt;


	/**
	 *  The mean temperature in kelvins below which the intensities were
	 *  measured. _diffrn.ambient_temp_gt and _diffrn.ambient_temp_lt
	 *  allow a range of temperatures to be given.
	 *  
	 *  attribute ambient_temp in category diffrn should always be used in preference
	 *  to these two items whenever possible.
	 */
	public java.lang.Float getAmbient_temp_lt() 
	{
		return ambient_temp_lt;
	}
 
	public void setAmbient_temp_lt(java.lang.Float ambient_temp_lt)
	{
		this.ambient_temp_lt = ambient_temp_lt;
	}

 	protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.String crystal_support;


	/**
	 *  The physical device used to support the crystal during data
	 *  collection.
	 *  glass capillary
	 *  quartz capillary
	 *  fiber
	 *  metal loop
	 */
	public java.lang.String getCrystal_support() 
	{
		return crystal_support;
	}
 
	public void setCrystal_support(java.lang.String crystal_support)
	{
		this.crystal_support = crystal_support;
	}

 	protected java.lang.String crystal_treatment;


	/**
	 *  Remarks about how the crystal was treated prior to intensity
	 *  measurement. Particularly relevant when intensities were
	 *  measured at low temperature.
	 *  equilibrated in hutch for 24 hours
	 *  flash frozen in liquid nitrogen
	 *  slow cooled with direct air stream
	 */
	public java.lang.String getCrystal_treatment() 
	{
		return crystal_treatment;
	}
 
	public void setCrystal_treatment(java.lang.String crystal_treatment)
	{
		this.crystal_treatment = crystal_treatment;
	}

 	protected java.lang.String details;


	/**
	 *  Special details of the diffraction measurement process. Should
	 *  include information about source instability, crystal motion,
	 *  degradation and so on.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  This data item uniquely identifies a set of diffraction
	 *  data.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
