package org.pdb.beans;

/**
 *  Data items in the DIFFRN_ATTENUATOR category record details
 *  about the diffraction attenuator scales employed.
 *  
 * <pre>
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_attenuatorCategory>
 *  <PDBx:diffrn_attenuator code="1">
 *  <PDBx:scale>16.976</PDBx:scale>
 *  </PDBx:diffrn_attenuator>
 *  </PDBx:diffrn_attenuatorCategory>
 * </pre>
 */
public class Diffrn_attenuator 
{
		protected java.lang.String code;


	/**
	 *  A code associated with a particular attenuator setting. This
	 *  code is referenced by the  attribute attenuator_code in category diffrn_refln which is
	 *  stored with the diffraction data. See  attribute scale in category diffrn_attenuator.
	 */
	public java.lang.String getCode() 
	{
		return code;
	}
 
	public void setCode(java.lang.String code)
	{
		this.code = code;
	}

 	protected java.lang.String material;


	/**
	 *  Material from which the attenuator is made.
	 */
	public java.lang.String getMaterial() 
	{
		return material;
	}
 
	public void setMaterial(java.lang.String material)
	{
		this.material = material;
	}

 	protected java.lang.Float scale;


	/**
	 *  The scale factor applied when an intensity measurement is
	 *  reduced by an attenuator identified by  attribute code.
	 *  in category diffrn_attenuator The measured intensity must be multiplied by this scale to
	 *  convert it to the same scale as unattenuated intensities.
	 */
	public java.lang.Float getScale() 
	{
		return scale;
	}
 
	public void setScale(java.lang.Float scale)
	{
		this.scale = scale;
	}

 }
