package org.pdb.beans;

/**
 *  Data items in the DIFFRN_DETECTOR category describe the
 *  detector used to measure the scattered radiation, including
 *  any analyser and post-sample collimation.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_detectorCategory>
 *  <PDBx:diffrn_detector diffrn_id="d1">
 *  <PDBx:detector>multiwire</PDBx:detector>
 *  <PDBx:type>Siemens</PDBx:type>
 *  </PDBx:diffrn_detector>
 *  </PDBx:diffrn_detectorCategory>
 * </pre>
 */
public class Diffrn_detector 
{
		protected java.lang.Float area_resol_mean;


	/**
	 *  The resolution of an area detector, in pixels/mm.
	 */
	public java.lang.Float getArea_resol_mean() 
	{
		return area_resol_mean;
	}
 
	public void setArea_resol_mean(java.lang.Float area_resol_mean)
	{
		this.area_resol_mean = area_resol_mean;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the radiation detector.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String detector;


	/**
	 *  The general class of the radiation detector.
	 *  photographic film
	 *  scintillation counter
	 *  CCD plate
	 *  BF~3~ counter
	 */
	public java.lang.String getDetector() 
	{
		return detector;
	}
 
	public void setDetector(java.lang.String detector)
	{
		this.detector = detector;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Float dtime;


	/**
	 *  The deadtime in microseconds of the detector used to measure
	 *  the diffraction intensities.
	 */
	public java.lang.Float getDtime() 
	{
		return dtime;
	}
 
	public void setDtime(java.lang.Float dtime)
	{
		this.dtime = dtime;
	}

 	protected java.lang.String pdbx_collection_date;


	/**
	 *  The date of data collection.
	 *  1996-12-25
	 */
	public java.lang.String getPdbx_collection_date() 
	{
		return pdbx_collection_date;
	}
 
	public void setPdbx_collection_date(java.lang.String pdbx_collection_date)
	{
		this.pdbx_collection_date = pdbx_collection_date;
	}

 	protected java.lang.Float pdbx_collection_time_total;


	/**
	 *  The total number of seconds required to measure this
	 *  data set.
	 *  120.0
	 */
	public java.lang.Float getPdbx_collection_time_total() 
	{
		return pdbx_collection_time_total;
	}
 
	public void setPdbx_collection_time_total(java.lang.Float pdbx_collection_time_total)
	{
		this.pdbx_collection_time_total = pdbx_collection_time_total;
	}

 	protected java.lang.Integer pdbx_frames_total;


	/**
	 *  The total number of data frames collected for this
	 *  data set.
	 *  20
	 *  100
	 */
	public java.lang.Integer getPdbx_frames_total() 
	{
		return pdbx_frames_total;
	}
 
	public void setPdbx_frames_total(java.lang.Integer pdbx_frames_total)
	{
		this.pdbx_frames_total = pdbx_frames_total;
	}

 	protected java.lang.String type;


	/**
	 *  The make, model or name of the detector device used.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
