package org.pdb.beans;

/**
 *  Data items in the DIFFRN_MEASUREMENT category record details
 *  about the device used to orient and/or position the crystal
 *  during data measurement and the manner in which the diffraction
 *  data were measured.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_measurementCategory>
 *  <PDBx:diffrn_measurement diffrn_id="d1">
 *  <PDBx:device>3-circle camera</PDBx:device>
 *  <PDBx:device_type>Supper model x</PDBx:device_type>
 *  <PDBx:device_details>none</PDBx:device_details>
 *  <PDBx:method>omega scan</PDBx:method>
 *  <PDBx:details> 440 frames, 0.20 degrees, 150 sec, detector distance 12 cm,
 *  detector angle 22.5 degrees</PDBx:details>
 *  </PDBx:diffrn_measurement>
 *  </PDBx:diffrn_measurementCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_measurementCategory>
 *  <PDBx:diffrn_measurement diffrn_id="s1">
 *  <PDBx:device_type>Philips PW1100/20 diffractometer</PDBx:device_type>
 *  <PDBx:method>\q/2\q</PDBx:method>
 *  </PDBx:diffrn_measurement>
 *  </PDBx:diffrn_measurementCategory>
 * </pre>
 */
public class Diffrn_measurement 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the intensity measurement.
	 *  440 frames, 0.20 degrees, 150 sec, detector
	 *  distance 12 cm, detector angle 22.5 degrees
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String device;


	/**
	 *  The general class of  goniometer or device used to support and
	 *  orient the specimen.
	 *  3-circle camera
	 *  4-circle camera
	 *  kappa-geometry camera
	 *  oscillation camera
	 *  precession camera
	 */
	public java.lang.String getDevice() 
	{
		return device;
	}
 
	public void setDevice(java.lang.String device)
	{
		this.device = device;
	}

 	protected java.lang.String device_details;


	/**
	 *  A description of special aspects of the device used to measure
	 *  the diffraction intensities.
	 *  commercial goniometer modified locally to
	 *  allow for 90\% \t arc
	 */
	public java.lang.String getDevice_details() 
	{
		return device_details;
	}
 
	public void setDevice_details(java.lang.String device_details)
	{
		this.device_details = device_details;
	}

 	protected java.lang.String device_type;


	/**
	 *  The make, model or name of the measurement device
	 *  (goniometer) used.
	 *  Supper model q
	 *  Huber model r
	 *  Enraf-Nonius model s
	 *  homemade
	 */
	public java.lang.String getDevice_type() 
	{
		return device_type;
	}
 
	public void setDevice_type(java.lang.String device_type)
	{
		this.device_type = device_type;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.String method;


	/**
	 *  Method used to measure intensities.
	 *  profile data from theta/2theta scans
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.String specimen_support;


	/**
	 *  The physical device used to support the crystal during data
	 *  collection.
	 *  glass capillary
	 *  quartz capillary
	 *  fiber
	 *  metal loop
	 */
	public java.lang.String getSpecimen_support() 
	{
		return specimen_support;
	}
 
	public void setSpecimen_support(java.lang.String specimen_support)
	{
		this.specimen_support = specimen_support;
	}

 }
