package org.pdb.beans;

/**
 *  Data items in the DIFFRN_ORIENT_MATRIX category record details
 *  about the orientation matrix used in the measurement of the
 *  diffraction data.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4.
 *  <PDBx:diffrn_orient_matrixCategory>
 *  <PDBx:diffrn_orient_matrix diffrn_id="set1">
 *  <PDBx:type> reciprocal axis matrix, multiplies hkl vector to generate
 *  diffractometer xyz vector and diffractometer angles</PDBx:type>
 *  <PDBx:UB11>-0.071479</PDBx:UB11>
 *  <PDBx:UB12>0.020208</PDBx:UB12>
 *  <PDBx:UB13>0.039076</PDBx:UB13>
 *  <PDBx:UB21>0.035372</PDBx:UB21>
 *  <PDBx:UB22>0.056209</PDBx:UB22>
 *  <PDBx:UB23>0.078324</PDBx:UB23>
 *  <PDBx:UB31>-0.007470</PDBx:UB31>
 *  <PDBx:UB32>0.067854</PDBx:UB32>
 *  <PDBx:UB33>-0.017832</PDBx:UB33>
 *  </PDBx:diffrn_orient_matrix>
 *  </PDBx:diffrn_orient_matrixCategory>
 * </pre>
 */
public class Diffrn_orient_matrix 
{
		protected java.lang.Float UB11;


	/**
	 *  The [1][1] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB11() 
	{
		return UB11;
	}
 
	public void setUB11(java.lang.Float UB11)
	{
		this.UB11 = UB11;
	}

 	protected java.lang.Float UB12;


	/**
	 *  The [1][2] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB12() 
	{
		return UB12;
	}
 
	public void setUB12(java.lang.Float UB12)
	{
		this.UB12 = UB12;
	}

 	protected java.lang.Float UB13;


	/**
	 *  The [1][3] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB13() 
	{
		return UB13;
	}
 
	public void setUB13(java.lang.Float UB13)
	{
		this.UB13 = UB13;
	}

 	protected java.lang.Float UB21;


	/**
	 *  The [2][1] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB21() 
	{
		return UB21;
	}
 
	public void setUB21(java.lang.Float UB21)
	{
		this.UB21 = UB21;
	}

 	protected java.lang.Float UB22;


	/**
	 *  The [2][2] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB22() 
	{
		return UB22;
	}
 
	public void setUB22(java.lang.Float UB22)
	{
		this.UB22 = UB22;
	}

 	protected java.lang.Float UB23;


	/**
	 *  The [2][3] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB23() 
	{
		return UB23;
	}
 
	public void setUB23(java.lang.Float UB23)
	{
		this.UB23 = UB23;
	}

 	protected java.lang.Float UB31;


	/**
	 *  The [3][1] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB31() 
	{
		return UB31;
	}
 
	public void setUB31(java.lang.Float UB31)
	{
		this.UB31 = UB31;
	}

 	protected java.lang.Float UB32;


	/**
	 *  The [3][2] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB32() 
	{
		return UB32;
	}
 
	public void setUB32(java.lang.Float UB32)
	{
		this.UB32 = UB32;
	}

 	protected java.lang.Float UB33;


	/**
	 *  The [3][3] element of the 3x3 matrix that defines the dimensions
	 *  of the reciprocal cell and its orientation with respect to the
	 *  local diffractometer axes. See also  attribute type in category diffrn_orient_matrix.
	 */
	public java.lang.Float getUB33() 
	{
		return UB33;
	}
 
	public void setUB33(java.lang.Float UB33)
	{
		this.UB33 = UB33;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.String type;


	/**
	 *  A description of the orientation matrix type and how it should
	 *  be applied to define the orientation of the crystal precisely
	 *  with respect to the diffractometer axes.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
