package org.pdb.beans;

/**
 *  Data items in the DIFFRN_REFLN category record details about
 *  the intensities in the diffraction data set
 *  identified by  attribute diffrn_id.
 *  in category diffrn_refln
 *  The DIFFRN_REFLN data items refer to individual intensity
 *  measurements and must be included in looped lists.
 *  
 *  The DIFFRN_REFLNS data items specify the parameters that apply
 *  to all intensity  measurements in the particular diffraction
 *  data set identified by  attribute diffrn_id in category diffrn_reflns.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4  for data set 'set1' reflection 1102.
 *  <PDBx:diffrn_reflnCategory>
 *  <PDBx:diffrn_refln diffrn_id="set1" id="1102">
 *  <PDBx:wavelength_id>Cu1fixed</PDBx:wavelength_id>
 *  <PDBx:angle_chi>32.21</PDBx:angle_chi>
 *  <PDBx:angle_kappa>20.12</PDBx:angle_kappa>
 *  <PDBx:angle_omega>11.54</PDBx:angle_omega>
 *  <PDBx:angle_phi>176.02</PDBx:angle_phi>
 *  <PDBx:angle_psi>0.00</PDBx:angle_psi>
 *  <PDBx:angle_theta>23.08</PDBx:angle_theta>
 *  <PDBx:attenuator_code>Ni.005</PDBx:attenuator_code>
 *  <PDBx:counts_bg_1>22</PDBx:counts_bg_1>
 *  <PDBx:counts_bg_2>25</PDBx:counts_bg_2>
 *  <PDBx:counts_net>3450</PDBx:counts_net>
 *  <PDBx:counts_peak>321</PDBx:counts_peak>
 *  <PDBx:counts_total>3499</PDBx:counts_total>
 *  <PDBx:detect_slit_horiz>0.04</PDBx:detect_slit_horiz>
 *  <PDBx:detect_slit_vert>0.02</PDBx:detect_slit_vert>
 *  <PDBx:elapsed_time>1.00</PDBx:elapsed_time>
 *  <PDBx:index_h>4</PDBx:index_h>
 *  <PDBx:index_k>0</PDBx:index_k>
 *  <PDBx:index_l>2</PDBx:index_l>
 *  <PDBx:intensity_net>202.56</PDBx:intensity_net>
 *  <PDBx:intensity_sigma>2.18</PDBx:intensity_sigma>
 *  <PDBx:scale_group_code>A24</PDBx:scale_group_code>
 *  <PDBx:scan_mode>om</PDBx:scan_mode>
 *  <PDBx:scan_mode_backgd>mo</PDBx:scan_mode_backgd>
 *  <PDBx:scan_rate>1.2</PDBx:scan_rate>
 *  <PDBx:scan_time_backgd>900.00</PDBx:scan_time_backgd>
 *  <PDBx:scan_width>1.0</PDBx:scan_width>
 *  <PDBx:sint_over_lambda>0.25426</PDBx:sint_over_lambda>
 *  <PDBx:standard_code>1</PDBx:standard_code>
 *  <PDBx:wavelength>1.54184</PDBx:wavelength>
 *  </PDBx:diffrn_refln>
 *  </PDBx:diffrn_reflnCategory>
 * </pre>
 */
public class Diffrn_refln 
{
		protected java.lang.Float angle_chi;


	/**
	 *  The diffractometer angle chi of a reflection in degrees. This
	 *  angle corresponds to the specified orientation matrix
	 *  and the original measured cell before any subsequent cell
	 *  transformations.
	 */
	public java.lang.Float getAngle_chi() 
	{
		return angle_chi;
	}
 
	public void setAngle_chi(java.lang.Float angle_chi)
	{
		this.angle_chi = angle_chi;
	}

 	protected java.lang.Float angle_kappa;


	/**
	 *  The diffractometer angle kappa of a reflection in degrees. This
	 *  angle corresponds to the specified orientation matrix
	 *  and the original measured cell before any subsequent cell
	 *  transformations.
	 */
	public java.lang.Float getAngle_kappa() 
	{
		return angle_kappa;
	}
 
	public void setAngle_kappa(java.lang.Float angle_kappa)
	{
		this.angle_kappa = angle_kappa;
	}

 	protected java.lang.Float angle_omega;


	/**
	 *  The diffractometer angle omega of a reflection in degrees. This
	 *  angle corresponds to the specified orientation matrix
	 *  and the original measured cell before any subsequent cell
	 *  transformations.
	 */
	public java.lang.Float getAngle_omega() 
	{
		return angle_omega;
	}
 
	public void setAngle_omega(java.lang.Float angle_omega)
	{
		this.angle_omega = angle_omega;
	}

 	protected java.lang.Float angle_phi;


	/**
	 *  The diffractometer angle phi of a reflection in degrees. This
	 *  angle corresponds to the specified orientation matrix
	 *  and the original measured cell before any subsequent cell
	 *  transformations.
	 */
	public java.lang.Float getAngle_phi() 
	{
		return angle_phi;
	}
 
	public void setAngle_phi(java.lang.Float angle_phi)
	{
		this.angle_phi = angle_phi;
	}

 	protected java.lang.Float angle_psi;


	/**
	 *  The diffractometer angle psi of a reflection in degrees. This
	 *  angle corresponds  to the specified orientation matrix
	 *  and the original measured cell before any subsequent cell
	 *  transformations.
	 */
	public java.lang.Float getAngle_psi() 
	{
		return angle_psi;
	}
 
	public void setAngle_psi(java.lang.Float angle_psi)
	{
		this.angle_psi = angle_psi;
	}

 	protected java.lang.Float angle_theta;


	/**
	 *  The diffractometer angle theta of a reflection in degrees. This
	 *  angle corresponds  to the specified orientation matrix
	 *  and the original measured cell before any subsequent cell
	 *  transformations.
	 */
	public java.lang.Float getAngle_theta() 
	{
		return angle_theta;
	}
 
	public void setAngle_theta(java.lang.Float angle_theta)
	{
		this.angle_theta = angle_theta;
	}

 	protected java.lang.String attenuator_code;


	/**
	 *  The code identifying the attenuator setting for this reflection.
	 *  This code must match one of the  attribute code in category diffrn_attenuator values.
	 */
	public java.lang.String getAttenuator_code() 
	{
		return attenuator_code;
	}
 
	public void setAttenuator_code(java.lang.String attenuator_code)
	{
		this.attenuator_code = attenuator_code;
	}

 	protected java.lang.String class_code;


	/**
	 *  The code identifying the class to which this reflection has
	 *  been assigned. This code must match a value of
	 *  attribute code in category diffrn_reflns_class.  Reflections may be grouped into
	 *  classes for a variety of purposes. For example, for modulated
	 *  structures each reflection class may be defined by the
	 *  number m=sum|m~i~|, where the m~i~ are the integer coefficients
	 *  that, in addition to h,k,l, index the corresponding diffraction
	 *  vector in the basis defined for the reciprocal lattice.
	 */
	public java.lang.String getClass_code() 
	{
		return class_code;
	}
 
	public void setClass_code(java.lang.String class_code)
	{
		this.class_code = class_code;
	}

 	protected java.lang.Integer counts_bg_1;


	/**
	 *  The diffractometer counts for the measurement of the background
	 *  before the peak.
	 */
	public java.lang.Integer getCounts_bg_1() 
	{
		return counts_bg_1;
	}
 
	public void setCounts_bg_1(java.lang.Integer counts_bg_1)
	{
		this.counts_bg_1 = counts_bg_1;
	}

 	protected java.lang.Integer counts_bg_2;


	/**
	 *  The diffractometer counts for the measurement of the background
	 *  after the peak.
	 */
	public java.lang.Integer getCounts_bg_2() 
	{
		return counts_bg_2;
	}
 
	public void setCounts_bg_2(java.lang.Integer counts_bg_2)
	{
		this.counts_bg_2 = counts_bg_2;
	}

 	protected java.lang.Integer counts_net;


	/**
	 *  The diffractometer counts for the measurement of net counts after
	 *  background removal.
	 */
	public java.lang.Integer getCounts_net() 
	{
		return counts_net;
	}
 
	public void setCounts_net(java.lang.Integer counts_net)
	{
		this.counts_net = counts_net;
	}

 	protected java.lang.Integer counts_peak;


	/**
	 *  The diffractometer counts for the measurement of counts for the
	 *  peak scan or position.
	 */
	public java.lang.Integer getCounts_peak() 
	{
		return counts_peak;
	}
 
	public void setCounts_peak(java.lang.Integer counts_peak)
	{
		this.counts_peak = counts_peak;
	}

 	protected java.lang.Integer counts_total;


	/**
	 *  The diffractometer counts for the measurement of total counts
	 *  (background plus peak).
	 */
	public java.lang.Integer getCounts_total() 
	{
		return counts_total;
	}
 
	public void setCounts_total(java.lang.Integer counts_total)
	{
		this.counts_total = counts_total;
	}

 	protected java.lang.Float detect_slit_horiz;


	/**
	 *  Total slit aperture in degrees in the diffraction plane.
	 */
	public java.lang.Float getDetect_slit_horiz() 
	{
		return detect_slit_horiz;
	}
 
	public void setDetect_slit_horiz(java.lang.Float detect_slit_horiz)
	{
		this.detect_slit_horiz = detect_slit_horiz;
	}

 	protected java.lang.Float detect_slit_vert;


	/**
	 *  Total slit aperture in degrees perpendicular to the
	 *  diffraction plane.
	 */
	public java.lang.Float getDetect_slit_vert() 
	{
		return detect_slit_vert;
	}
 
	public void setDetect_slit_vert(java.lang.Float detect_slit_vert)
	{
		this.detect_slit_vert = detect_slit_vert;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Float elapsed_time;


	/**
	 *  Elapsed time in minutes from the start of the diffraction
	 *  experiment to the measurement of this intensity.
	 */
	public java.lang.Float getElapsed_time() 
	{
		return elapsed_time;
	}
 
	public void setElapsed_time(java.lang.Float elapsed_time)
	{
		this.elapsed_time = elapsed_time;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category diffrn_refln must uniquely identify the
	 *  reflection in the data set identified by the item
	 *  attribute diffrn_id.
	 *  in category diffrn_refln
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer index_h;


	/**
	 *  Miller index h of a reflection. The values of
	 *  the Miller indices in the DIFFRN_REFLN category need not match
	 *  the values of the Miller indices in the REFLN category if a
	 *  transformation of the original measured cell has taken place.
	 *  Details of the cell transformation are given in
	 *  attribute reduction_process in category diffrn_reflns.  See also
	 *  attribute transf_matrix[][] in category diffrn_reflns.
	 */
	public java.lang.Integer getIndex_h() 
	{
		return index_h;
	}
 
	public void setIndex_h(java.lang.Integer index_h)
	{
		this.index_h = index_h;
	}

 	protected java.lang.Integer index_k;


	/**
	 *  Miller index k of a reflection. The values of
	 *  the Miller indices in the DIFFRN_REFLN category need not match
	 *  the values of the Miller indices in the REFLN category if a
	 *  transformation of the original measured cell has taken place.
	 *  Details of the cell transformation are given in
	 *  attribute reduction_process in category diffrn_reflns.  See also
	 *  attribute transf_matrix[][] in category diffrn_reflns.
	 */
	public java.lang.Integer getIndex_k() 
	{
		return index_k;
	}
 
	public void setIndex_k(java.lang.Integer index_k)
	{
		this.index_k = index_k;
	}

 	protected java.lang.Integer index_l;


	/**
	 *  Miller index l of a reflection. The values of
	 *  the Miller indices in the DIFFRN_REFLN category need not match
	 *  the values of the Miller indices in the REFLN category if a
	 *  transformation of the original measured cell has taken place.
	 *  Details of the cell transformation are given in
	 *  attribute reduction_process in category diffrn_reflns.  See also
	 *  attribute transf_matrix[][] in category diffrn_reflns.
	 */
	public java.lang.Integer getIndex_l() 
	{
		return index_l;
	}
 
	public void setIndex_l(java.lang.Integer index_l)
	{
		this.index_l = index_l;
	}

 	protected java.lang.Float intensity_net;


	/**
	 *  Net intensity calculated from the diffraction counts after the
	 *  attenuator and standard scales have been applied.
	 */
	public java.lang.Float getIntensity_net() 
	{
		return intensity_net;
	}
 
	public void setIntensity_net(java.lang.Float intensity_net)
	{
		this.intensity_net = intensity_net;
	}

 	protected java.lang.Float intensity_sigma;


	/**
	 *  Standard uncertainty (estimated standard deviation) of the
	 *  intensity calculated from the diffraction counts after the
	 *  attenuator and standard scales have been applied.
	 */
	public java.lang.Float getIntensity_sigma() 
	{
		return intensity_sigma;
	}
 
	public void setIntensity_sigma(java.lang.Float intensity_sigma)
	{
		this.intensity_sigma = intensity_sigma;
	}

 	protected java.lang.Float intensity_u;


	/**
	 *  Standard uncertainty of the net intensity calculated from
	 *  the diffraction counts after the attenuator and standard
	 *  scales have been applied.
	 */
	public java.lang.Float getIntensity_u() 
	{
		return intensity_u;
	}
 
	public void setIntensity_u(java.lang.Float intensity_u)
	{
		this.intensity_u = intensity_u;
	}

 	protected java.lang.String scale_group_code;


	/**
	 *  The code identifying the scale applying to this reflection.
	 *  
	 *  This data item is a pointer to  attribute code in category diffrn_scale_group in the
	 *  DIFFRN_SCALE_GROUP category.
	 */
	public java.lang.String getScale_group_code() 
	{
		return scale_group_code;
	}
 
	public void setScale_group_code(java.lang.String scale_group_code)
	{
		this.scale_group_code = scale_group_code;
	}

 	protected java.lang.String scan_mode;


	/**
	 *  The code identifying the mode of scanning for measurements
	 *  using a diffractometer.
	 *  See _diffrn_refln.scan_width and _diffrn_refln.scan_mode_backgd.
	 */
	public java.lang.String getScan_mode() 
	{
		return scan_mode;
	}
 
	public void setScan_mode(java.lang.String scan_mode)
	{
		this.scan_mode = scan_mode;
	}

 	protected java.lang.String scan_mode_backgd;


	/**
	 *  The code identifying the mode of scanning a reflection to
	 *  measure the background intensity.
	 */
	public java.lang.String getScan_mode_backgd() 
	{
		return scan_mode_backgd;
	}
 
	public void setScan_mode_backgd(java.lang.String scan_mode_backgd)
	{
		this.scan_mode_backgd = scan_mode_backgd;
	}

 	protected java.lang.Float scan_rate;


	/**
	 *  The rate of scanning a reflection in degrees per minute
	 *  to measure the intensity.
	 */
	public java.lang.Float getScan_rate() 
	{
		return scan_rate;
	}
 
	public void setScan_rate(java.lang.Float scan_rate)
	{
		this.scan_rate = scan_rate;
	}

 	protected java.lang.Float scan_time_backgd;


	/**
	 *  The time spent measuring each background in seconds.
	 */
	public java.lang.Float getScan_time_backgd() 
	{
		return scan_time_backgd;
	}
 
	public void setScan_time_backgd(java.lang.Float scan_time_backgd)
	{
		this.scan_time_backgd = scan_time_backgd;
	}

 	protected java.lang.Float scan_width;


	/**
	 *  The scan width in degrees of the scan mode defined by the code
	 *  attribute scan_mode in category diffrn_refln.
	 */
	public java.lang.Float getScan_width() 
	{
		return scan_width;
	}
 
	public void setScan_width(java.lang.Float scan_width)
	{
		this.scan_width = scan_width;
	}

 	protected java.lang.Float sint_over_lambda;


	/**
	 *  The (sin theta)/lambda value in reciprocal angstroms for this
	 *  reflection.
	 */
	public java.lang.Float getSint_over_lambda() 
	{
		return sint_over_lambda;
	}
 
	public void setSint_over_lambda(java.lang.Float sint_over_lambda)
	{
		this.sint_over_lambda = sint_over_lambda;
	}

 	protected java.lang.String standard_code;


	/**
	 *  The code identifying that this reflection was measured as a
	 *  standard intensity.
	 *  
	 *  This data item is a pointer to  attribute code in category diffrn_standard_refln in the
	 *  DIFFRN_STANDARD_REFLN category.
	 */
	public java.lang.String getStandard_code() 
	{
		return standard_code;
	}
 
	public void setStandard_code(java.lang.String standard_code)
	{
		this.standard_code = standard_code;
	}

 	protected java.lang.Float wavelength;


	/**
	 *  The mean wavelength in angstroms of the radiation used to measure
	 *  the intensity of this reflection. This is an important parameter
	 *  for data collected using energy-dispersive detectors or the
	 *  Laue method.
	 */
	public java.lang.Float getWavelength() 
	{
		return wavelength;
	}
 
	public void setWavelength(java.lang.Float wavelength)
	{
		this.wavelength = wavelength;
	}

 	protected java.lang.String wavelength_id;


	/**
	 *  This data item is a pointer to  attribute wavelength_id in category diffrn_radiation in
	 *  the DIFFRN_RADIATION category.
	 */
	public java.lang.String getWavelength_id() 
	{
		return wavelength_id;
	}
 
	public void setWavelength_id(java.lang.String wavelength_id)
	{
		this.wavelength_id = wavelength_id;
	}

 }
