package org.pdb.beans;

/**
 *  Data items in the DIFFRN_STANDARDS category record details
 *  about the set of standard reflections used to monitor intensity
 *  stability during the measurement of diffraction intensities.
 *  
 *  Note that these records describe properties common to the set of
 *  standard reflections, not the standard reflections themselves.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_standardsCategory>
 *  <PDBx:diffrn_standards diffrn_id="s1">
 *  <PDBx:number>3</PDBx:number>
 *  <PDBx:interval_time>120.</PDBx:interval_time>
 *  <PDBx:decay_>0.</PDBx:decay_>
 *  </PDBx:diffrn_standards>
 *  </PDBx:diffrn_standardsCategory>
 * </pre>
 */
public class Diffrn_standards 
{
		protected java.lang.Float decay_;


	/**
	 *  The percentage decrease in the mean of the intensities
	 *  for the set of standard reflections from the start of the
	 *  measurement process to the end. This value usually
	 *  affords a measure of the overall decay in crystal quality
	 *  during the diffraction measurement process. Negative values
	 *  are used in exceptional instances where the final intensities
	 *  are greater than the initial ones.
	 */
	public java.lang.Float getDecay_() 
	{
		return decay_;
	}
 
	public void setDecay_(java.lang.Float decay_)
	{
		this.decay_ = decay_;
	}

 	protected java.lang.String diffrn_id;


	/**
	 *  This data item is a pointer to  attribute id in category diffrn in the DIFFRN
	 *  category.
	 */
	public java.lang.String getDiffrn_id() 
	{
		return diffrn_id;
	}
 
	public void setDiffrn_id(java.lang.String diffrn_id)
	{
		this.diffrn_id = diffrn_id;
	}

 	protected java.lang.Integer interval_count;


	/**
	 *  The number of reflection intensities between the measurement of
	 *  standard reflection intensities.
	 */
	public java.lang.Integer getInterval_count() 
	{
		return interval_count;
	}
 
	public void setInterval_count(java.lang.Integer interval_count)
	{
		this.interval_count = interval_count;
	}

 	protected java.lang.Float interval_time;


	/**
	 *  The time in minutes between the measurement of standard
	 *  reflection intensities.
	 */
	public java.lang.Float getInterval_time() 
	{
		return interval_time;
	}
 
	public void setInterval_time(java.lang.Float interval_time)
	{
		this.interval_time = interval_time;
	}

 	protected java.lang.Integer number;


	/**
	 *  The number of unique standard reflections used during the
	 *  measurement of  the diffraction intensities.
	 */
	public java.lang.Integer getNumber() 
	{
		return number;
	}
 
	public void setNumber(java.lang.Integer number)
	{
		this.number = number;
	}

 	protected java.lang.Float scale_sigma;


	/**
	 *  The standard uncertainty (estimated standard deviation) of
	 *  the individual mean standard scales applied to the intensity
	 *  data.
	 */
	public java.lang.Float getScale_sigma() 
	{
		return scale_sigma;
	}
 
	public void setScale_sigma(java.lang.Float scale_sigma)
	{
		this.scale_sigma = scale_sigma;
	}

 	protected java.lang.Float scale_u;


	/**
	 *  The standard uncertainty of the individual mean
	 *  standard scales applied to the intensity data.
	 */
	public java.lang.Float getScale_u() 
	{
		return scale_u;
	}
 
	public void setScale_u(java.lang.Float scale_u)
	{
		this.scale_u = scale_u;
	}

 }
