package org.pdb.beans;

/**
 *  Data items in the EM_2D_CRYSTAL_GROW category
 *  record details of growth conditions for 2d crystal samples.
 * <pre>
 *  Example 1 - based on PDB entry 1AT9 and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_2d_crystal_growCategory>
 *  <PDBx:em_2d_crystal_grow id="1">
 *  <PDBx:atmosphere>room air</PDBx:atmosphere>
 *  <PDBx:pH>5.2</PDBx:pH>
 *  <PDBx:temp>18.</PDBx:temp>
 *  <PDBx:buffer_id>2</PDBx:buffer_id>
 *  <PDBx:details>on grid</PDBx:details>
 *  <PDBx:number_2d_crystals>129</PDBx:number_2d_crystals>
 *  <PDBx:citation_id>2</PDBx:citation_id>
 *  </PDBx:em_2d_crystal_grow>
 *  </PDBx:em_2d_crystal_growCategory>
 * </pre>
 */
public class Em_2d_crystal_grow 
{
		protected java.lang.String apparatus;


	/**
	 *  The type of the apparatus used for growing the crystals.
	 *  Langmuir trough
	 */
	public java.lang.String getApparatus() 
	{
		return apparatus;
	}
 
	public void setApparatus(java.lang.String apparatus)
	{
		this.apparatus = apparatus;
	}

 	protected java.lang.String atmosphere;


	/**
	 *  The type of atmosphere in which crystals were grown.
	 *  room air
	 */
	public java.lang.String getAtmosphere() 
	{
		return atmosphere;
	}
 
	public void setAtmosphere(java.lang.String atmosphere)
	{
		this.atmosphere = atmosphere;
	}

 	protected java.lang.String buffer_id;


	/**
	 *  This data item is a pointer to  attribute id in category em_buffer in the
	 *  BUFFER category.
	 */
	public java.lang.String getBuffer_id() 
	{
		return buffer_id;
	}
 
	public void setBuffer_id(java.lang.String buffer_id)
	{
		this.buffer_id = buffer_id;
	}

 	protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id
	 *  in category citation in the CITATION category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String details;


	/**
	 *  Any additional items concerning 2d crystal growth.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute crystal_id
	 *  in category em_2d_crystal_grow must uniquely identify the sample 2d crystal.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Float mean_2d_crystal_size;


	/**
	 *  The approximate size (microns squared) of 2d crystals imaged.
	 */
	public java.lang.Float getMean_2d_crystal_size() 
	{
		return mean_2d_crystal_size;
	}
 
	public void setMean_2d_crystal_size(java.lang.Float mean_2d_crystal_size)
	{
		this.mean_2d_crystal_size = mean_2d_crystal_size;
	}

 	protected java.lang.String method;


	/**
	 *  The method used for growing the crystals.
	 *  lipid monolayer
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Integer number_2d_crystals;


	/**
	 *  The number of 2d crystals imaged.
	 */
	public java.lang.Integer getNumber_2d_crystals() 
	{
		return number_2d_crystals;
	}
 
	public void setNumber_2d_crystals(java.lang.Integer number_2d_crystals)
	{
		this.number_2d_crystals = number_2d_crystals;
	}

 	protected java.lang.Float pH;


	/**
	 *  the pH value used for growing the crystals.
	 *  4.7
	 */
	public java.lang.Float getPH() 
	{
		return pH;
	}
 
	public void setPH(java.lang.Float pH)
	{
		this.pH = pH;
	}

 	protected java.lang.Float temp;


	/**
	 *  The value of the temperature in degrees Kelvin used for
	 *  growing the crystals.
	 *  293
	 */
	public java.lang.Float getTemp() 
	{
		return temp;
	}
 
	public void setTemp(java.lang.Float temp)
	{
		this.temp = temp;
	}

 	protected java.lang.String time;


	/**
	 *  The length of time required to grow the crystals.
	 *  approximately 2 days
	 */
	public java.lang.String getTime() 
	{
		return time;
	}
 
	public void setTime(java.lang.String time)
	{
		this.time = time;
	}

 }
