package org.pdb.beans;

/**
 *  Data items in the EM_2D_PROJECTION_SELECTION category
 *  record details of images from scanned micrographs and the
 *  number of particles selected from a scanned set of micrographs.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_2d_projection_selectionCategory>
 *  <PDBx:em_2d_projection_selection entry_id="1">
 *  <PDBx:software_name>1</PDBx:software_name>
 *  <PDBx:method>INTERACTIVE</PDBx:method>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  </PDBx:em_2d_projection_selection>
 *  </PDBx:em_2d_projection_selectionCategory>
 * </pre>
 */
public class Em_2d_projection_selection 
{
		protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id in category citation in the
	 *  CITATION category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String details;


	/**
	 *  Any additional details used for selecting observed assemblies.
	 *  negative monitor contrast facilitated particle picking
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category em_2d_projection_selection points to
	 *  the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method;


	/**
	 *  The method used for selecting observed assemblies.
	 *  particles picked interactively from monitor
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Integer num_particles;


	/**
	 *  The number of particles selected from the projection set of images.
	 *  840
	 */
	public java.lang.Integer getNum_particles() 
	{
		return num_particles;
	}
 
	public void setNum_particles(java.lang.Integer num_particles)
	{
		this.num_particles = num_particles;
	}

 	protected java.lang.String software_name;


	/**
	 *  This data item is a pointer to  attribute name in category software in the
	 *  SOFTWARE category.
	 */
	public java.lang.String getSoftware_name() 
	{
		return software_name;
	}
 
	public void setSoftware_name(java.lang.String software_name)
	{
		this.software_name = software_name;
	}

 }
