package org.pdb.beans;

/**
 *  Data items in the EM_ELECTRON_DIFFRACTION category
 *  record details about the electron diffraction data
 *  from the electron crystallography experiment.
 * <pre>
 *  Example 1 - based on PDB entry 1TUB and laboratory records for the
 *  structure corresponding to PDB entry 1TUB
 *  <PDBx:em_electron_diffractionCategory>
 *  <PDBx:em_electron_diffraction entry_id="1TUB" id="1">
 *  <PDBx:num_structure_factors>12000</PDBx:num_structure_factors>
 *  <PDBx:details xsi:nil="true" />
 *  </PDBx:em_electron_diffraction>
 *  </PDBx:em_electron_diffractionCategory>
 * </pre>
 */
public class Em_electron_diffraction 
{
		protected java.lang.String details;


	/**
	 *  Details of the electron diffraction experiment
	 *  THE MODEL WAS DERIVED USING ELECTRON DIFFRACTION
	 *  AND IMAGE DATA FROM TWO DIMENSIONAL CRYSTALS OF TUBULIN
	 *  INDUCED BY THE PRESENCE OF ZN++ IONS.
	 *  WHAT FOLLOWS ARE THE COORDINATES FOR THE AB-TUBULIN DIMER
	 *  BOUND TO TAXOL AS OBTAINED BY ELECTRON CRYSTALLOGRAPHY OF
	 *  ZINC-INDUCED SHEETS.  THIS IS THE UNREFINED MODEL, BUILT
	 *  INTO A RAW DENSITY MAP WHERE THE RESOLUTION IN THE PLANE
	 *  OF THE SHEET WAS 3.7 ANGSTROMS AND THAT PERPENDICULAR TO
	 *  THE SHEET ABOUT 4.8 ANGSTROMS.  THE MODEL DOES NOT CONTAIN
	 *  MOST OF THE C-TERMINAL RESIDUES OF EITHER MONOMER WHICH
	 *  WERE DISORDERED IN THE MAP.  THE LOOP BETWEEN HELIX H1 AND
	 *  STRAND S2, AND THAT BETWEEN H2 AND S3 ARE PRESENT FOR
	 *  COMPLETENESS BUT WERE BUILT INTO VERY WEAK DENSITY.
	 *  GIVEN THE LIMITED RESOLUTION OF THE MAP, THE CONFORMATION
	 *  OF THE SIDE CHAINS, ESPECIALLY THOSE CORRESPONDING TO
	 *  RESIDUES ON THE SURFACE OF THE DIMER, MUST BE TAKEN
	 *  CAUTIOUSLY.  IN ADDITION, BECAUSE THIS IS AN UNREFINED
	 *  MODEL, CERTAIN GEOMETRY ERRORS MAY STILL BE PRESENT IN THE
	 *  STRUCTURE.  PLEASE TAKE THIS INTO ACCOUNT WHEN
	 *  INTERPRETING YOUR OWN DATA BASED ON THE PRESENT TUBULIN
	 *  STRUCTURE.  ALTHOUGH THE POSITION OF RESIDUES (WITH THE
	 *  EXCEPTION OF THOSE IN THE LOOPS MENTIONED ABOVE) SHOULD
	 *  NOT CHANGE SIGNIFICANTLY UPON REFINEMENT, DRAWING
	 *  INFORMATION AT THE LEVEL OF SIDE CHAIN CONFORMATION IS
	 *  CLEARLY NOT ADVISED.  FINALLY, PLEASE NOTICE THAT THE
	 *  TAXOID IN THE MODEL IS THE TAXOL DERIVATIVE TAXOTERE.
	 *  1
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category electron_diffraction must
	 *  uniquely identify the electron diffraction experiment.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer num_diff_patterns;


	/**
	 *  The number of diffraction patterns used from the electron
	 *  diffraction experiment.
	 */
	public java.lang.Integer getNum_diff_patterns() 
	{
		return num_diff_patterns;
	}
 
	public void setNum_diff_patterns(java.lang.Integer num_diff_patterns)
	{
		this.num_diff_patterns = num_diff_patterns;
	}

 	protected java.lang.Integer num_structure_factors;


	/**
	 *  The number of structure factors from the electron diffraction experiment.
	 *  12000
	 */
	public java.lang.Integer getNum_structure_factors() 
	{
		return num_structure_factors;
	}
 
	public void setNum_structure_factors(java.lang.Integer num_structure_factors)
	{
		this.num_structure_factors = num_structure_factors;
	}

 }
