package org.pdb.beans;

/**
 *  Data items in the EM_IMAGING category record details about
 *  the parameters used in imaging the sample in the electron microscope.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_imagingCategory>
 *  <PDBx:em_imaging entry_id="1DYL" id="1">
 *  <PDBx:sample_support_id>1</PDBx:sample_support_id>
 *  <PDBx:microscope_model>FEI/PHILIPS CM200 FEG</PDBx:microscope_model>
 *  <PDBx:specimen_holder_type>cryotransfer</PDBx:specimen_holder_type>
 *  <PDBx:specimen_holder_model>gatan 626-0300</PDBx:specimen_holder_model>
 *  <PDBx:date>1998-15-06</PDBx:date>
 *  <PDBx:accelerating_voltage>200</PDBx:accelerating_voltage>
 *  <PDBx:illumination_mode>bright field</PDBx:illumination_mode>
 *  <PDBx:mode>low dose</PDBx:mode>
 *  <PDBx:nominal_cs>2.0</PDBx:nominal_cs>
 *  <PDBx:nominal_defocus_min>975.</PDBx:nominal_defocus_min>
 *  <PDBx:nominal_defocus_max>7600.</PDBx:nominal_defocus_max>
 *  <PDBx:tilt_angle_min>0.</PDBx:tilt_angle_min>
 *  <PDBx:tilt_angle_max>0.</PDBx:tilt_angle_max>
 *  <PDBx:nominal_magnification>50000</PDBx:nominal_magnification>
 *  <PDBx:electron_source>FEG</PDBx:electron_source>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  <PDBx:temperature>95.</PDBx:temperature>
 *  </PDBx:em_imaging>
 *  </PDBx:em_imagingCategory>
 * </pre>
 */
public class Em_imaging 
{
		protected java.lang.Float accelerating_voltage;


	/**
	 *  A value of accelerating voltage (in kV) used for imaging.
	 *  300
	 */
	public java.lang.Float getAccelerating_voltage() 
	{
		return accelerating_voltage;
	}
 
	public void setAccelerating_voltage(java.lang.Float accelerating_voltage)
	{
		this.accelerating_voltage = accelerating_voltage;
	}

 	protected java.lang.Integer calibrated_magnification;


	/**
	 *  The magnification value obtained for a known standard just
	 *  prior to, during or just after the imaging experiment.
	 *  61200
	 */
	public java.lang.Integer getCalibrated_magnification() 
	{
		return calibrated_magnification;
	}
 
	public void setCalibrated_magnification(java.lang.Integer calibrated_magnification)
	{
		this.calibrated_magnification = calibrated_magnification;
	}

 	protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id in category citation in
	 *  the CITATION category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String date;


	/**
	 *  Date (YYYY-MM-DD) of imaging experiment or the date at which
	 *  a series of experiments began.
	 *  2001-05-08
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String details;


	/**
	 *  Any additional imaging details.
	 *  weak beam illumination
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.Float detector_distance;


	/**
	 *  The camera length (in millimetres). The camera length is the
	 *  product of the objective focal length and the combined magnification
	 *  of the intermediate and projector lenses when the microscope is
	 *  operated in the diffraction mode.
	 */
	public java.lang.Float getDetector_distance() 
	{
		return detector_distance;
	}
 
	public void setDetector_distance(java.lang.Float detector_distance)
	{
		this.detector_distance = detector_distance;
	}

 	protected java.lang.String detector_id;


	/**
	 *  The value of  attribute detector_id in category em_imaging must uniquely identify
	 *  the type of detector used in the experiment.
	 */
	public java.lang.String getDetector_id() 
	{
		return detector_id;
	}
 
	public void setDetector_id(java.lang.String detector_id)
	{
		this.detector_id = detector_id;
	}

 	protected java.lang.Float electron_dose;


	/**
	 *  The electron dose received by the specimen (electrons per square angstrom).
	 *  0.9
	 */
	public java.lang.Float getElectron_dose() 
	{
		return electron_dose;
	}
 
	public void setElectron_dose(java.lang.Float electron_dose)
	{
		this.electron_dose = electron_dose;
	}

 	protected java.lang.String electron_source;


	/**
	 *  The source of electrons. The electron gun.
	 *  FIELD EMISSION GUN
	 *  LAB6
	 *  TUNGSTEN HAIRPIN
	 *  SCHOTTKY FIELD EMISSION GUN
	 *  OTHER
	 */
	public java.lang.String getElectron_source() 
	{
		return electron_source;
	}
 
	public void setElectron_source(java.lang.String electron_source)
	{
		this.electron_source = electron_source;
	}

 	protected java.lang.String energy_filter;


	/**
	 *  The type of energy filter spectrometer apparatus.
	 *  FEI
	 */
	public java.lang.String getEnergy_filter() 
	{
		return energy_filter;
	}
 
	public void setEnergy_filter(java.lang.String energy_filter)
	{
		this.energy_filter = energy_filter;
	}

 	protected java.lang.Float energy_window;


	/**
	 *  The energy filter range in electron volts (eV)set by spectrometer.
	 *  0 - 15
	 */
	public java.lang.Float getEnergy_window() 
	{
		return energy_window;
	}
 
	public void setEnergy_window(java.lang.Float energy_window)
	{
		this.energy_window = energy_window;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_imaging must uniquely identify
	 *  each imaging experiment.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String illumination_mode;


	/**
	 *  The mode of illumination.
	 *  FLOOD BEAM
	 *  FLOOD BEAM LOW DOSE
	 *  SPOT SCAN
	 *  OTHER
	 */
	public java.lang.String getIllumination_mode() 
	{
		return illumination_mode;
	}
 
	public void setIllumination_mode(java.lang.String illumination_mode)
	{
		this.illumination_mode = illumination_mode;
	}

 	protected java.lang.String microscope_model;


	/**
	 *  The name of the model of microscope.
	 *  HITACHI H8100
	 *  HITACHI HF2000
	 *  HITACHI HF2000-UHR
	 *  HITACHI H9000-UHR
	 *  HITACHI H9000-NAR
	 *  HITACHI 300KEV FEG
	 *  HITACHI HU1250
	 *  HITACHI H-1500
	 *  JEOL 2000EX
	 *  JEOL 2010HT
	 *  JEOL 2010UHR
	 *  JEOL 2010F
	 *  JEOL 3010HT
	 *  JEOL 3010UHR
	 *  JEOL KYOTO-3000SFF
	 *  JEOL 4000EX
	 *  JEOL HAREM
	 *  JEOL ARM-1000
	 *  JEOL KYOTO-1000
	 *  JEOL ARM-1250
	 *  FEI/PHILIPS CM120T
	 *  FEI/PHILIPS CM200T
	 *  FEI/PHILIPS CM20/ST
	 *  FEI/PHILIPS CM20/SOPHIE
	 *  FEI/PHILIPS CM200FEG/ST
	 *  FEI/PHILIPS CM20/UT
	 *  FEI/PHILIPS CM200FEG/UT
	 *  FEI/PHILIPS CM30/T
	 *  FEI/PHILIPS CM300FEG/T
	 *  FEI/PHILIPS CM300FEG/HE
	 *  FEI/PHILIPS CM30/ST
	 *  FEI/PHILIPS CM300FEG/ST
	 *  FEI/PHILIPS CM300FEG/UT
	 *  FEI TECNAI 12
	 *  FEI TECNAI 20
	 *  FEI TECNAI F20
	 *  FEI TECNAI F30
	 *  FEI MORGAGNI
	 */
	public java.lang.String getMicroscope_model() 
	{
		return microscope_model;
	}
 
	public void setMicroscope_model(java.lang.String microscope_model)
	{
		this.microscope_model = microscope_model;
	}

 	protected java.lang.String mode;


	/**
	 *  The mode of imaging.
	 *  BRIGHT FIELD
	 *  DARK FIELD
	 *  DIFFRACTION
	 *  OTHER
	 */
	public java.lang.String getMode() 
	{
		return mode;
	}
 
	public void setMode(java.lang.String mode)
	{
		this.mode = mode;
	}

 	protected java.lang.Float nominal_cs;


	/**
	 *  The spherical aberration coefficient (Cs) in millimetres,
	 *  of the objective lens.
	 *  1.4
	 */
	public java.lang.Float getNominal_cs() 
	{
		return nominal_cs;
	}
 
	public void setNominal_cs(java.lang.Float nominal_cs)
	{
		this.nominal_cs = nominal_cs;
	}

 	protected java.lang.Float nominal_defocus_max;


	/**
	 *  The maximum defocus value of the objective lens (in nanometres) used
	 *  to obtain the recorded images.
	 *  7600
	 */
	public java.lang.Float getNominal_defocus_max() 
	{
		return nominal_defocus_max;
	}
 
	public void setNominal_defocus_max(java.lang.Float nominal_defocus_max)
	{
		this.nominal_defocus_max = nominal_defocus_max;
	}

 	protected java.lang.Float nominal_defocus_min;


	/**
	 *  The minimum defocus value of the objective lens (in nanometres) used
	 *  to obtain the recorded images.
	 *  975
	 */
	public java.lang.Float getNominal_defocus_min() 
	{
		return nominal_defocus_min;
	}
 
	public void setNominal_defocus_min(java.lang.Float nominal_defocus_min)
	{
		this.nominal_defocus_min = nominal_defocus_min;
	}

 	protected java.lang.Integer nominal_magnification;


	/**
	 *  The magnification indicated by the microscope readout.
	 *  60000
	 */
	public java.lang.Integer getNominal_magnification() 
	{
		return nominal_magnification;
	}
 
	public void setNominal_magnification(java.lang.Integer nominal_magnification)
	{
		this.nominal_magnification = nominal_magnification;
	}

 	protected java.lang.Float recording_temperature_maximum;


	/**
	 *  The specimen temperature maximum (degrees Kelvin) for the duration
	 *  of imaging.
	 */
	public java.lang.Float getRecording_temperature_maximum() 
	{
		return recording_temperature_maximum;
	}
 
	public void setRecording_temperature_maximum(java.lang.Float recording_temperature_maximum)
	{
		this.recording_temperature_maximum = recording_temperature_maximum;
	}

 	protected java.lang.Float recording_temperature_minimum;


	/**
	 *  The specimen temperature minimum (degrees Kelvin) for the duration
	 *  of imaging.
	 */
	public java.lang.Float getRecording_temperature_minimum() 
	{
		return recording_temperature_minimum;
	}
 
	public void setRecording_temperature_minimum(java.lang.Float recording_temperature_minimum)
	{
		this.recording_temperature_minimum = recording_temperature_minimum;
	}

 	protected java.lang.String sample_support_id;


	/**
	 *  This data item is a pointer to  attribute id in category em_sample_support in
	 *  the EM_SAMPLE_SUPPORT category.
	 */
	public java.lang.String getSample_support_id() 
	{
		return sample_support_id;
	}
 
	public void setSample_support_id(java.lang.String sample_support_id)
	{
		this.sample_support_id = sample_support_id;
	}

 	protected java.lang.String scans_id;


	/**
	 *  The value of  attribute scans_id in category em_imaging must uniquely identify
	 *  the image_scans used in the experiment.
	 */
	public java.lang.String getScans_id() 
	{
		return scans_id;
	}
 
	public void setScans_id(java.lang.String scans_id)
	{
		this.scans_id = scans_id;
	}

 	protected java.lang.String specimen_holder_model;


	/**
	 *  The name of the model of specimen holder used during imaging.
	 */
	public java.lang.String getSpecimen_holder_model() 
	{
		return specimen_holder_model;
	}
 
	public void setSpecimen_holder_model(java.lang.String specimen_holder_model)
	{
		this.specimen_holder_model = specimen_holder_model;
	}

 	protected java.lang.String specimen_holder_type;


	/**
	 *  The type of specimen holder used during imaging.
	 *  cryo
	 */
	public java.lang.String getSpecimen_holder_type() 
	{
		return specimen_holder_type;
	}
 
	public void setSpecimen_holder_type(java.lang.String specimen_holder_type)
	{
		this.specimen_holder_type = specimen_holder_type;
	}

 	protected java.lang.Float temperature;


	/**
	 *  The mean specimen stage temperature (degrees Kelvin) during imaging
	 *  in the microscope.
	 */
	public java.lang.Float getTemperature() 
	{
		return temperature;
	}
 
	public void setTemperature(java.lang.Float temperature)
	{
		this.temperature = temperature;
	}

 	protected java.lang.Float tilt_angle_max;


	/**
	 *  The maximum angle at which the specimen was tilted to obtain
	 *  recorded images.
	 *  60
	 */
	public java.lang.Float getTilt_angle_max() 
	{
		return tilt_angle_max;
	}
 
	public void setTilt_angle_max(java.lang.Float tilt_angle_max)
	{
		this.tilt_angle_max = tilt_angle_max;
	}

 	protected java.lang.Float tilt_angle_min;


	/**
	 *  The minimum angle at which the specimen was tilted to obtain
	 *  recorded images.
	 *  0
	 */
	public java.lang.Float getTilt_angle_min() 
	{
		return tilt_angle_min;
	}
 
	public void setTilt_angle_min(java.lang.Float tilt_angle_min)
	{
		this.tilt_angle_min = tilt_angle_min;
	}

 }
