package org.pdb.beans;

/**
 *  Data items in the EM_VIRUS_ENTITY category record details
 *  of the icosahedral virus.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_virus_entityCategory>
 *  <PDBx:em_virus_entity id="1" entity_assembly_id="1">
 *  <PDBx:virus_host_category>VERTERBRATES</PDBx:virus_host_category>
 *  <PDBx:virus_host_species>HOMO SAPIENS</PDBx:virus_host_species>
 *  <PDBx:virus_type>VIRUS</PDBx:virus_type>
 *  <PDBx:virus_isolate>STRAIN</PDBx:virus_isolate>
 *  <PDBx:ictvdb_id>00.073.0.01.023</PDBx:ictvdb_id>
 *  <PDBx:enveloped>YES</PDBx:enveloped>
 *  <PDBx:empty>NO</PDBx:empty>
 *  </PDBx:em_virus_entity>
 *  </PDBx:em_virus_entityCategory>
 * </pre>
 */
public class Em_virus_entity 
{
		protected java.lang.String details;


	/**
	 *  Additional details about this virus entity
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String empty;


	/**
	 *  Flag to indicate if the virus is empty or not.
	 */
	public java.lang.String getEmpty() 
	{
		return empty;
	}
 
	public void setEmpty(java.lang.String empty)
	{
		this.empty = empty;
	}

 	protected java.lang.String entity_assembly_id;


	/**
	 *  This data item is a pointer to  attribute id in category em_virus_entity in the
	 *  ENTITY_ASSEMBLY category.
	 */
	public java.lang.String getEntity_assembly_id() 
	{
		return entity_assembly_id;
	}
 
	public void setEntity_assembly_id(java.lang.String entity_assembly_id)
	{
		this.entity_assembly_id = entity_assembly_id;
	}

 	protected java.lang.String enveloped;


	/**
	 *  Flag to indicate if the virus is enveloped or not.
	 */
	public java.lang.String getEnveloped() 
	{
		return enveloped;
	}
 
	public void setEnveloped(java.lang.String enveloped)
	{
		this.enveloped = enveloped;
	}

 	protected java.lang.String ictvdb_id;


	/**
	 *  The International Committee on Taxonomy of Viruses
	 *  (ICTV) Taxon Identifier is the Virus Code used throughout the
	 *  ICTV database (ICTVdb). The ICTVdb id is the appropriate
	 *  identifier used by the International Committee on Taxonomy of Viruses
	 *  Resource. Reference: Virus Taxonomy, Academic Press (1999).
	 *  ISBN:0123702003.
	 *  01.0.2.0.001
	 *  01.0.2.0.002
	 */
	public java.lang.String getIctvdb_id() 
	{
		return ictvdb_id;
	}
 
	public void setIctvdb_id(java.lang.String ictvdb_id)
	{
		this.ictvdb_id = ictvdb_id;
	}

 	protected java.lang.String id_;


	/**
	 *  Is the unique identifier for VIRUS_ENTITY category.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String virus_host_category;


	/**
	 *  The host category description for the virus.
	 *  ALGAE
	 *  ARCHAEA
	 *  BACTERIA(EUBACTERIA)
	 *  FUNGI
	 *  INVERTEBRATES
	 *  PLANTAE (HIGHER PLANTS)
	 *  PROTOZOA
	 *  VERTEBRATES
	 */
	public java.lang.String getVirus_host_category() 
	{
		return virus_host_category;
	}
 
	public void setVirus_host_category(java.lang.String virus_host_category)
	{
		this.virus_host_category = virus_host_category;
	}

 	protected java.lang.String virus_host_growth_cell;


	/**
	 *  The host cell from which the virus was isolated.
	 *  HELA
	 *  CHO
	 */
	public java.lang.String getVirus_host_growth_cell() 
	{
		return virus_host_growth_cell;
	}
 
	public void setVirus_host_growth_cell(java.lang.String virus_host_growth_cell)
	{
		this.virus_host_growth_cell = virus_host_growth_cell;
	}

 	protected java.lang.String virus_host_species;


	/**
	 *  The host species from which the virus was isolated.
	 *  homo sapiens
	 *  gallus gallus
	 */
	public java.lang.String getVirus_host_species() 
	{
		return virus_host_species;
	}
 
	public void setVirus_host_species(java.lang.String virus_host_species)
	{
		this.virus_host_species = virus_host_species;
	}

 	protected java.lang.String virus_isolate;


	/**
	 *  The isolate from which the virus was obtained.
	 */
	public java.lang.String getVirus_isolate() 
	{
		return virus_isolate;
	}
 
	public void setVirus_isolate(java.lang.String virus_isolate)
	{
		this.virus_isolate = virus_isolate;
	}

 	protected java.lang.String virus_type;


	/**
	 *  The type of virus.
	 *  VIRION
	 *  SATELLITE
	 *  PRION
	 *  VIROID
	 *  VIRUS-LIKE PARTICLE
	 */
	public java.lang.String getVirus_type() 
	{
		return virus_type;
	}
 
	public void setVirus_type(java.lang.String virus_type)
	{
		this.virus_type = virus_type;
	}

 }
