package org.pdb.beans;

/**
 *  Data items in the EM_VITRIFICATION category
 *  record details about the method and cryogen used in
 *  rapid freezing of the sample on the grid prior to its
 *  insertion in the electron microscope
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_vitrificationCategory>
 *  <PDBx:em_vitrification entry_id="1DYL" id="1">
 *  <PDBx:sample_preparation_id>1</PDBx:sample_preparation_id>
 *  <PDBx:cryogen_name>ETHANE</PDBx:cryogen_name>
 *  <PDBx:humidity>90</PDBx:humidity>
 *  <PDBx:temp>95.</PDBx:temp>
 *  <PDBx:method>PLUNGE VITRIFICATION</PDBx:method>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  <PDBx:details> SAMPLES WERE PREPARED AS THIN
 *  LAYERS OF VITREOUS ICE AND
 *  MAINTAINED AT NEAR LIQUID NITROGEN
 *  TEMPERATURE IN THE ELECTRON MICROSCOPE
 *  WITH A GATAN 626-0300 CRYOTRANSFER
 *  HOLDER.                            </PDBx:details>
 *  </PDBx:em_vitrification>
 *  </PDBx:em_vitrificationCategory>
 * </pre>
 */
public class Em_vitrification 
{
		protected java.lang.String citation_id;


	/**
	 *  This data item is a pointer to  attribute id in category citation in the
	 *  CITATION category.
	 */
	public java.lang.String getCitation_id() 
	{
		return citation_id;
	}
 
	public void setCitation_id(java.lang.String citation_id)
	{
		this.citation_id = citation_id;
	}

 	protected java.lang.String cryogen_name;


	/**
	 *  This is the name of the cryogen.
	 */
	public java.lang.String getCryogen_name() 
	{
		return cryogen_name;
	}
 
	public void setCryogen_name(java.lang.String cryogen_name)
	{
		this.cryogen_name = cryogen_name;
	}

 	protected java.lang.String details;


	/**
	 *  Any additional details relating to vitrification.
	 *  argon atmosphere
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String humidity;


	/**
	 *  The humidity (%) in the vicinity of the vitrification process.
	 *  90
	 */
	public java.lang.String getHumidity() 
	{
		return humidity;
	}
 
	public void setHumidity(java.lang.String humidity)
	{
		this.humidity = humidity;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category em_vitrification must uniquely identify
	 *  the vitrification procedure.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String instrument;


	/**
	 *  The type of instrument used in the vitrification process.
	 *  Reichert plunger
	 */
	public java.lang.String getInstrument() 
	{
		return instrument;
	}
 
	public void setInstrument(java.lang.String instrument)
	{
		this.instrument = instrument;
	}

 	protected java.lang.String method;


	/**
	 *  The procedure for vitrification.
	 *  blot for 2 seconds before plunging
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.String sample_preparation_id;


	/**
	 *  This data item is a pointer to  attribute id in category em_sample_preparation in the
	 *  EM_SAMPLE_PREPARATION category.
	 */
	public java.lang.String getSample_preparation_id() 
	{
		return sample_preparation_id;
	}
 
	public void setSample_preparation_id(java.lang.String sample_preparation_id)
	{
		this.sample_preparation_id = sample_preparation_id;
	}

 	protected java.lang.Float temp;


	/**
	 *  The temperature (in degrees Kelvin) at which vitrification took place.
	 *  4.2
	 */
	public java.lang.Float getTemp() 
	{
		return temp;
	}
 
	public void setTemp(java.lang.Float temp)
	{
		this.temp = temp;
	}

 	protected java.lang.String time_resolved_state;


	/**
	 *  The length of time after an event effecting the sample that
	 *  vitrification was induced and a description of the event.
	 *  30 msec after spraying with effector'
	 */
	public java.lang.String getTime_resolved_state() 
	{
		return time_resolved_state;
	}
 
	public void setTime_resolved_state(java.lang.String time_resolved_state)
	{
		this.time_resolved_state = time_resolved_state;
	}

 }
