package org.pdb.beans;

/**
 *  Data items in the ENTITY_NAME_SYS category record the systematic
 *  name or names associated with the entity and the system that
 *  was used to construct the systematic name. In some cases, the
 *  entity name may not be the same as the name of the biological
 *  structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_name_sysCategory>
 *  <PDBx:entity_name_sys entity_id="1" name="EC 3.4.23.16"></PDBx:entity_name_sys>
 *  <PDBx:entity_name_sys entity_id="2" name="acetyl-Ile-Val-Asp-Sta-Ala-Ile-Sta"></PDBx:entity_name_sys>
 *  <PDBx:entity_name_sys entity_id="3" name="water"></PDBx:entity_name_sys>
 *  </PDBx:entity_name_sysCategory>
 * </pre>
 */
public class Entity_name_sys 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String name;


	/**
	 *  The systematic name for the entity.
	 *  hydroquinone-beta-D-pyranoside
	 *  EC 2.1.1.1
	 *  2-fluoro-1,4-dichlorobenzene
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String system;


	/**
	 *  The system used to generate the systematic name of the entity.
	 *  Chemical Abstracts conventions
	 *  enzyme convention
	 *  Sigma catalog
	 */
	public java.lang.String getSystem() 
	{
		return system;
	}
 
	public void setSystem(java.lang.String system)
	{
		this.system = system;
	}

 }
