package org.pdb.beans;

/**
 *  Data items in the ENTITY_SRC_GEN category record details of
 *  the source from which the entity was obtained in cases
 *  where the source was genetically manipulated.  The
 *  following are treated separately:  items pertaining to the tissue
 *  from which the gene was obtained, items pertaining to the host
 *  organism for gene expression and items pertaining to the actual
 *  producing organism (plasmid).
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_src_genCategory>
 *  <PDBx:entity_src_gen entity_id="1">
 *  <PDBx:gene_src_common_name>HIV-1</PDBx:gene_src_common_name>
 *  <PDBx:gene_src_strain>NY-5</PDBx:gene_src_strain>
 *  <PDBx:host_org_common_name>bacteria</PDBx:host_org_common_name>
 *  <PDBx:host_org_genus>Escherichia</PDBx:host_org_genus>
 *  <PDBx:host_org_species>coli</PDBx:host_org_species>
 *  <PDBx:plasmid_name>pB322</PDBx:plasmid_name>
 *  </PDBx:entity_src_gen>
 *  </PDBx:entity_src_genCategory>
 * </pre>
 */
public class Entity_src_gen 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String expression_system_id;


	/**
	 *  A unique identifier for the expression system. This
	 *  should be extracted from a local list of expression
	 *  systems.
	 */
	public java.lang.String getExpression_system_id() 
	{
		return expression_system_id;
	}
 
	public void setExpression_system_id(java.lang.String expression_system_id)
	{
		this.expression_system_id = expression_system_id;
	}

 	protected java.lang.String gene_src_common_name;


	/**
	 *  The common name of the natural organism from which the gene was
	 *  obtained.
	 *  man
	 *  yeast
	 *  bacteria
	 */
	public java.lang.String getGene_src_common_name() 
	{
		return gene_src_common_name;
	}
 
	public void setGene_src_common_name(java.lang.String gene_src_common_name)
	{
		this.gene_src_common_name = gene_src_common_name;
	}

 	protected java.lang.String gene_src_details;


	/**
	 *  A description of special aspects of the natural organism from
	 *  which the gene was obtained.
	 */
	public java.lang.String getGene_src_details() 
	{
		return gene_src_details;
	}
 
	public void setGene_src_details(java.lang.String gene_src_details)
	{
		this.gene_src_details = gene_src_details;
	}

 	protected java.lang.String gene_src_dev_stage;


	/**
	 *  A string to indicate the life-cycle or cell development
	 *  cycle in which the gene is expressed and the mature
	 *  protein is active.
	 */
	public java.lang.String getGene_src_dev_stage() 
	{
		return gene_src_dev_stage;
	}
 
	public void setGene_src_dev_stage(java.lang.String gene_src_dev_stage)
	{
		this.gene_src_dev_stage = gene_src_dev_stage;
	}

 	protected java.lang.String gene_src_genus;


	/**
	 *  The genus of the natural organism from which the gene was
	 *  obtained.
	 *  Homo
	 *  Saccharomyces
	 *  Escherichia
	 */
	public java.lang.String getGene_src_genus() 
	{
		return gene_src_genus;
	}
 
	public void setGene_src_genus(java.lang.String gene_src_genus)
	{
		this.gene_src_genus = gene_src_genus;
	}

 	protected java.lang.String gene_src_species;


	/**
	 *  The species of the natural organism from which the gene was
	 *  obtained.
	 *  sapiens
	 *  cerevisiae
	 *  coli
	 */
	public java.lang.String getGene_src_species() 
	{
		return gene_src_species;
	}
 
	public void setGene_src_species(java.lang.String gene_src_species)
	{
		this.gene_src_species = gene_src_species;
	}

 	protected java.lang.String gene_src_strain;


	/**
	 *  The strain of the natural organism from which the gene was
	 *  obtained, if relevant.
	 *  DH5a
	 *  BMH 71-18
	 */
	public java.lang.String getGene_src_strain() 
	{
		return gene_src_strain;
	}
 
	public void setGene_src_strain(java.lang.String gene_src_strain)
	{
		this.gene_src_strain = gene_src_strain;
	}

 	protected java.lang.String gene_src_tissue;


	/**
	 *  The tissue of the natural organism from which the gene was
	 *  obtained.
	 *  heart
	 *  liver
	 *  eye lens
	 */
	public java.lang.String getGene_src_tissue() 
	{
		return gene_src_tissue;
	}
 
	public void setGene_src_tissue(java.lang.String gene_src_tissue)
	{
		this.gene_src_tissue = gene_src_tissue;
	}

 	protected java.lang.String gene_src_tissue_fraction;


	/**
	 *  The subcellular fraction of the tissue of the natural organism
	 *  from which the gene was obtained.
	 *  mitochondria
	 *  nucleus
	 *  membrane
	 */
	public java.lang.String getGene_src_tissue_fraction() 
	{
		return gene_src_tissue_fraction;
	}
 
	public void setGene_src_tissue_fraction(java.lang.String gene_src_tissue_fraction)
	{
		this.gene_src_tissue_fraction = gene_src_tissue_fraction;
	}

 	protected java.lang.String host_org_common_name;


	/**
	 *  The common name of the organism that served as host for the
	 *  production of the entity.  Where full details of the protein
	 *  production are available it would be expected that this item
	 *  be derived from  attribute host_org_common_name
	 *  in category entity_src_gen_express or via  attribute host_org_tax_id in category entity_src_gen_express
	 *  yeast
	 *  bacteria
	 */
	public java.lang.String getHost_org_common_name() 
	{
		return host_org_common_name;
	}
 
	public void setHost_org_common_name(java.lang.String host_org_common_name)
	{
		this.host_org_common_name = host_org_common_name;
	}

 	protected java.lang.String host_org_details;


	/**
	 *  A description of special aspects of the organism that served as
	 *  host for the production of the entity. Where full details of
	 *  the protein production are available it would be expected that
	 *  this item would derived from  attribute host_org_details in category entity_src_gen_express
	 */
	public java.lang.String getHost_org_details() 
	{
		return host_org_details;
	}
 
	public void setHost_org_details(java.lang.String host_org_details)
	{
		this.host_org_details = host_org_details;
	}

 	protected java.lang.String host_org_genus;


	/**
	 *  The genus of the organism that served as host for the production
	 *  of the entity.
	 *  Saccharomyces
	 *  Escherichia
	 */
	public java.lang.String getHost_org_genus() 
	{
		return host_org_genus;
	}
 
	public void setHost_org_genus(java.lang.String host_org_genus)
	{
		this.host_org_genus = host_org_genus;
	}

 	protected java.lang.String host_org_species;


	/**
	 *  The species of the organism that served as host for the
	 *  production of the entity.
	 *  cerevisiae
	 *  coli
	 */
	public java.lang.String getHost_org_species() 
	{
		return host_org_species;
	}
 
	public void setHost_org_species(java.lang.String host_org_species)
	{
		this.host_org_species = host_org_species;
	}

 	protected java.lang.String host_org_strain;


	/**
	 *  The strain of the organism in which the entity was expressed.
	 *  Where full details of the protein production are available
	 *  it would be expected that this item be derived from
	 *  attribute host_org_strain in category entity_src_gen_express or via
	 *  attribute host_org_tax_id in category entity_src_gen_express
	 *  DH5a
	 *  BMH 71-18
	 */
	public java.lang.String getHost_org_strain() 
	{
		return host_org_strain;
	}
 
	public void setHost_org_strain(java.lang.String host_org_strain)
	{
		this.host_org_strain = host_org_strain;
	}

 	protected java.lang.String pdbx_description;


	/**
	 *  Information on the source which is not given elsewhere.
	 */
	public java.lang.String getPdbx_description() 
	{
		return pdbx_description;
	}
 
	public void setPdbx_description(java.lang.String pdbx_description)
	{
		this.pdbx_description = pdbx_description;
	}

 	protected java.lang.String pdbx_gene_src_atcc;


	/**
	 *  American Type Culture Collection tissue culture number.
	 *  6051
	 */
	public java.lang.String getPdbx_gene_src_atcc() 
	{
		return pdbx_gene_src_atcc;
	}
 
	public void setPdbx_gene_src_atcc(java.lang.String pdbx_gene_src_atcc)
	{
		this.pdbx_gene_src_atcc = pdbx_gene_src_atcc;
	}

 	protected java.lang.String pdbx_gene_src_cell;


	/**
	 *  Cell type.
	 *  ENDOTHELIAL
	 */
	public java.lang.String getPdbx_gene_src_cell() 
	{
		return pdbx_gene_src_cell;
	}
 
	public void setPdbx_gene_src_cell(java.lang.String pdbx_gene_src_cell)
	{
		this.pdbx_gene_src_cell = pdbx_gene_src_cell;
	}

 	protected java.lang.String pdbx_gene_src_cell_line;


	/**
	 *  The specific line of cells.
	 *  HELA CELLS
	 */
	public java.lang.String getPdbx_gene_src_cell_line() 
	{
		return pdbx_gene_src_cell_line;
	}
 
	public void setPdbx_gene_src_cell_line(java.lang.String pdbx_gene_src_cell_line)
	{
		this.pdbx_gene_src_cell_line = pdbx_gene_src_cell_line;
	}

 	protected java.lang.String pdbx_gene_src_cellular_location;


	/**
	 *  Identifies the location inside (or outside) the cell.
	 *  CYTOPLASM
	 *  NUCLEUS
	 */
	public java.lang.String getPdbx_gene_src_cellular_location() 
	{
		return pdbx_gene_src_cellular_location;
	}
 
	public void setPdbx_gene_src_cellular_location(java.lang.String pdbx_gene_src_cellular_location)
	{
		this.pdbx_gene_src_cellular_location = pdbx_gene_src_cellular_location;
	}

 	protected java.lang.String pdbx_gene_src_fragment;


	/**
	 *  A domain or fragment of the molecule.
	 *  CYTOPLASM
	 *  NUCLEUS
	 */
	public java.lang.String getPdbx_gene_src_fragment() 
	{
		return pdbx_gene_src_fragment;
	}
 
	public void setPdbx_gene_src_fragment(java.lang.String pdbx_gene_src_fragment)
	{
		this.pdbx_gene_src_fragment = pdbx_gene_src_fragment;
	}

 	protected java.lang.String pdbx_gene_src_gene;


	/**
	 *  Identifies the gene.
	 */
	public java.lang.String getPdbx_gene_src_gene() 
	{
		return pdbx_gene_src_gene;
	}
 
	public void setPdbx_gene_src_gene(java.lang.String pdbx_gene_src_gene)
	{
		this.pdbx_gene_src_gene = pdbx_gene_src_gene;
	}

 	protected java.lang.String pdbx_gene_src_ncbi_taxonomy_id;


	/**
	 *  NCBI Taxonomy identifier for the gene source organism.
	 *  
	 *  Reference:
	 *  
	 *  Wheeler DL, Chappey C, Lash AE, Leipe DD, Madden TL, Schuler GD,
	 *  Tatusova TA, Rapp BA (2000). Database resources of the National
	 *  Center for Biotechnology Information. Nucleic Acids Res 2000 Jan
	 *  1;28(1):10-4
	 *  
	 *  Benson DA, Karsch-Mizrachi I, Lipman DJ, Ostell J, Rapp BA,
	 *  Wheeler DL (2000). GenBank. Nucleic Acids Res 2000 Jan 1;28(1):15-18.
	 */
	public java.lang.String getPdbx_gene_src_ncbi_taxonomy_id() 
	{
		return pdbx_gene_src_ncbi_taxonomy_id;
	}
 
	public void setPdbx_gene_src_ncbi_taxonomy_id(java.lang.String pdbx_gene_src_ncbi_taxonomy_id)
	{
		this.pdbx_gene_src_ncbi_taxonomy_id = pdbx_gene_src_ncbi_taxonomy_id;
	}

 	protected java.lang.String pdbx_gene_src_organ;


	/**
	 *  Organized group of tissues that carries on a specialized function.
	 *  KIDNEY
	 *  LIVER
	 *  PANCREAS
	 */
	public java.lang.String getPdbx_gene_src_organ() 
	{
		return pdbx_gene_src_organ;
	}
 
	public void setPdbx_gene_src_organ(java.lang.String pdbx_gene_src_organ)
	{
		this.pdbx_gene_src_organ = pdbx_gene_src_organ;
	}

 	protected java.lang.String pdbx_gene_src_organelle;


	/**
	 *  Organized structure within cell.
	 *  MITOCHONDRIA
	 */
	public java.lang.String getPdbx_gene_src_organelle() 
	{
		return pdbx_gene_src_organelle;
	}
 
	public void setPdbx_gene_src_organelle(java.lang.String pdbx_gene_src_organelle)
	{
		this.pdbx_gene_src_organelle = pdbx_gene_src_organelle;
	}

 	protected java.lang.String pdbx_gene_src_plasmid;


	/**
	 *  The source plasmid.
	 */
	public java.lang.String getPdbx_gene_src_plasmid() 
	{
		return pdbx_gene_src_plasmid;
	}
 
	public void setPdbx_gene_src_plasmid(java.lang.String pdbx_gene_src_plasmid)
	{
		this.pdbx_gene_src_plasmid = pdbx_gene_src_plasmid;
	}

 	protected java.lang.String pdbx_gene_src_plasmid_name;


	/**
	 *  The source plasmid.
	 */
	public java.lang.String getPdbx_gene_src_plasmid_name() 
	{
		return pdbx_gene_src_plasmid_name;
	}
 
	public void setPdbx_gene_src_plasmid_name(java.lang.String pdbx_gene_src_plasmid_name)
	{
		this.pdbx_gene_src_plasmid_name = pdbx_gene_src_plasmid_name;
	}

 	protected java.lang.String pdbx_gene_src_scientific_name;


	/**
	 *  Scientific name of the organism.
	 *  
	 *  ESCHERICHIA COLI
	 *  HOMO SAPIENS
	 *  SACCHAROMYCES CEREVISIAE
	 */
	public java.lang.String getPdbx_gene_src_scientific_name() 
	{
		return pdbx_gene_src_scientific_name;
	}
 
	public void setPdbx_gene_src_scientific_name(java.lang.String pdbx_gene_src_scientific_name)
	{
		this.pdbx_gene_src_scientific_name = pdbx_gene_src_scientific_name;
	}

 	protected java.lang.String pdbx_gene_src_variant;


	/**
	 *  Identifies the variant.
	 *  DELTAH1DELTATRP
	 */
	public java.lang.String getPdbx_gene_src_variant() 
	{
		return pdbx_gene_src_variant;
	}
 
	public void setPdbx_gene_src_variant(java.lang.String pdbx_gene_src_variant)
	{
		this.pdbx_gene_src_variant = pdbx_gene_src_variant;
	}

 	protected java.lang.String pdbx_host_org_atcc;


	/**
	 *  Americal Tissue Culture Collection of the expression system. Where
	 *  full details of the protein production are available it would
	 *  be expected that this item  would be derived from
	 *  attribute host_org_culture_collection in category entity_src_gen_express
	 */
	public java.lang.String getPdbx_host_org_atcc() 
	{
		return pdbx_host_org_atcc;
	}
 
	public void setPdbx_host_org_atcc(java.lang.String pdbx_host_org_atcc)
	{
		this.pdbx_host_org_atcc = pdbx_host_org_atcc;
	}

 	protected java.lang.String pdbx_host_org_cell;


	/**
	 *  Cell type from which the gene is derived. Where
	 *  entity.target_id is provided this should be derived from
	 *  details of the target.
	 *  ENDOTHELIAL
	 */
	public java.lang.String getPdbx_host_org_cell() 
	{
		return pdbx_host_org_cell;
	}
 
	public void setPdbx_host_org_cell(java.lang.String pdbx_host_org_cell)
	{
		this.pdbx_host_org_cell = pdbx_host_org_cell;
	}

 	protected java.lang.String pdbx_host_org_cell_line;


	/**
	 *  A specific line of cells used as the expression system. Where
	 *  full details of the protein production are available it would
	 *  be expected that this item would be derived from
	 *  entity_src_gen_express.host_org_cell_line
	 *  HELA
	 */
	public java.lang.String getPdbx_host_org_cell_line() 
	{
		return pdbx_host_org_cell_line;
	}
 
	public void setPdbx_host_org_cell_line(java.lang.String pdbx_host_org_cell_line)
	{
		this.pdbx_host_org_cell_line = pdbx_host_org_cell_line;
	}

 	protected java.lang.String pdbx_host_org_cellular_location;


	/**
	 *  Identifies the location inside (or outside) the cell which
	 *  expressed the molecule.
	 *  CYTOPLASM
	 *  NUCLEUS
	 */
	public java.lang.String getPdbx_host_org_cellular_location() 
	{
		return pdbx_host_org_cellular_location;
	}
 
	public void setPdbx_host_org_cellular_location(java.lang.String pdbx_host_org_cellular_location)
	{
		this.pdbx_host_org_cellular_location = pdbx_host_org_cellular_location;
	}

 	protected java.lang.String pdbx_host_org_culture_collection;


	/**
	 *  Culture collection of the expression system. Where
	 *  full details of the protein production are available it would
	 *  be expected that this item  would be derived somehwere, but
	 *  exactly where is not clear.
	 */
	public java.lang.String getPdbx_host_org_culture_collection() 
	{
		return pdbx_host_org_culture_collection;
	}
 
	public void setPdbx_host_org_culture_collection(java.lang.String pdbx_host_org_culture_collection)
	{
		this.pdbx_host_org_culture_collection = pdbx_host_org_culture_collection;
	}

 	protected java.lang.String pdbx_host_org_gene;


	/**
	 *  Specific gene which expressed the molecule.
	 *  HIV-1 POL
	 *  GLNS7
	 *  U1A (2-98, Y31H, Q36R)
	 */
	public java.lang.String getPdbx_host_org_gene() 
	{
		return pdbx_host_org_gene;
	}
 
	public void setPdbx_host_org_gene(java.lang.String pdbx_host_org_gene)
	{
		this.pdbx_host_org_gene = pdbx_host_org_gene;
	}

 	protected java.lang.String pdbx_host_org_ncbi_taxonomy_id;


	/**
	 *  NCBI Taxonomy identifier for the expression system organism.
	 *  
	 *  Reference:
	 *  
	 *  Wheeler DL, Chappey C, Lash AE, Leipe DD, Madden TL, Schuler GD,
	 *  Tatusova TA, Rapp BA (2000). Database resources of the National
	 *  Center for Biotechnology Information. Nucleic Acids Res 2000 Jan
	 *  1;28(1):10-4
	 *  
	 *  Benson DA, Karsch-Mizrachi I, Lipman DJ, Ostell J, Rapp BA,
	 *  Wheeler DL (2000). GenBank. Nucleic Acids Res 2000 Jan 1;28(1):15-18.
	 */
	public java.lang.String getPdbx_host_org_ncbi_taxonomy_id() 
	{
		return pdbx_host_org_ncbi_taxonomy_id;
	}
 
	public void setPdbx_host_org_ncbi_taxonomy_id(java.lang.String pdbx_host_org_ncbi_taxonomy_id)
	{
		this.pdbx_host_org_ncbi_taxonomy_id = pdbx_host_org_ncbi_taxonomy_id;
	}

 	protected java.lang.String pdbx_host_org_organ;


	/**
	 *  Specific organ which expressed the molecule.
	 *  KIDNEY
	 */
	public java.lang.String getPdbx_host_org_organ() 
	{
		return pdbx_host_org_organ;
	}
 
	public void setPdbx_host_org_organ(java.lang.String pdbx_host_org_organ)
	{
		this.pdbx_host_org_organ = pdbx_host_org_organ;
	}

 	protected java.lang.String pdbx_host_org_organelle;


	/**
	 *  Specific organelle which expressed the molecule.
	 *  MITOCHONDRIA
	 */
	public java.lang.String getPdbx_host_org_organelle() 
	{
		return pdbx_host_org_organelle;
	}
 
	public void setPdbx_host_org_organelle(java.lang.String pdbx_host_org_organelle)
	{
		this.pdbx_host_org_organelle = pdbx_host_org_organelle;
	}

 	protected java.lang.String pdbx_host_org_scientific_name;


	/**
	 *  The scientific name of the organism that served as host for the
	 *  production of the entity. Where full details of the protein
	 *  production are available it would be expected that this item
	 *  would be derived from  attribute host_org_scientific_name
	 *  in category entity_src_gen_express or via  attribute host_org_tax_id in category entity_src_gen_express
	 *  ESCHERICHIA COLI
	 *  SACCHAROMYCES CEREVISIAE
	 */
	public java.lang.String getPdbx_host_org_scientific_name() 
	{
		return pdbx_host_org_scientific_name;
	}
 
	public void setPdbx_host_org_scientific_name(java.lang.String pdbx_host_org_scientific_name)
	{
		this.pdbx_host_org_scientific_name = pdbx_host_org_scientific_name;
	}

 	protected java.lang.String pdbx_host_org_strain;


	/**
	 *  The strain of the organism in which the entity was
	 *  expressed.
	 *  AR120
	 */
	public java.lang.String getPdbx_host_org_strain() 
	{
		return pdbx_host_org_strain;
	}
 
	public void setPdbx_host_org_strain(java.lang.String pdbx_host_org_strain)
	{
		this.pdbx_host_org_strain = pdbx_host_org_strain;
	}

 	protected java.lang.String pdbx_host_org_tissue;


	/**
	 *  The specific tissue which expressed the molecule. Where full details
	 *  of the protein production are available it would be expected that this
	 *  item would be derived from  attribute host_org_tissue in category entity_src_gen_express
	 *  heart
	 *  liver
	 *  eye lens
	 */
	public java.lang.String getPdbx_host_org_tissue() 
	{
		return pdbx_host_org_tissue;
	}
 
	public void setPdbx_host_org_tissue(java.lang.String pdbx_host_org_tissue)
	{
		this.pdbx_host_org_tissue = pdbx_host_org_tissue;
	}

 	protected java.lang.String pdbx_host_org_tissue_fraction;


	/**
	 *  The fraction of the tissue which expressed the
	 *  molecule.
	 *  mitochondria
	 *  nucleus
	 *  membrane
	 */
	public java.lang.String getPdbx_host_org_tissue_fraction() 
	{
		return pdbx_host_org_tissue_fraction;
	}
 
	public void setPdbx_host_org_tissue_fraction(java.lang.String pdbx_host_org_tissue_fraction)
	{
		this.pdbx_host_org_tissue_fraction = pdbx_host_org_tissue_fraction;
	}

 	protected java.lang.String pdbx_host_org_variant;


	/**
	 *  Variant of the organism used as the expression system. Where
	 *  full details of the protein production are available it would
	 *  be expected that this item be derived from
	 *  entity_src_gen_express.host_org_variant or via
	 *  attribute host_org_tax_id in category entity_src_gen_express
	 *  TRP-LAC
	 *  LAMBDA DE3
	 */
	public java.lang.String getPdbx_host_org_variant() 
	{
		return pdbx_host_org_variant;
	}
 
	public void setPdbx_host_org_variant(java.lang.String pdbx_host_org_variant)
	{
		this.pdbx_host_org_variant = pdbx_host_org_variant;
	}

 	protected java.lang.String pdbx_host_org_vector;


	/**
	 *  Identifies the vector used. Where full details of the protein
	 *  production are available it would be expected that this item
	 *  would be derived from  attribute vector_name in category entity_src_gen_clone.
	 *  PBIT36
	 *  PET15B
	 *  PUC18
	 */
	public java.lang.String getPdbx_host_org_vector() 
	{
		return pdbx_host_org_vector;
	}
 
	public void setPdbx_host_org_vector(java.lang.String pdbx_host_org_vector)
	{
		this.pdbx_host_org_vector = pdbx_host_org_vector;
	}

 	protected java.lang.String pdbx_host_org_vector_type;


	/**
	 *  Identifies the type of vector used (plasmid, virus, or cosmid).
	 *  Where full details of the protein production are available it
	 *  would be expected that this item would be derived from
	 *  attribute vector_type in category entity_src_gen_express.
	 *  COSMID
	 *  PLASMID
	 */
	public java.lang.String getPdbx_host_org_vector_type() 
	{
		return pdbx_host_org_vector_type;
	}
 
	public void setPdbx_host_org_vector_type(java.lang.String pdbx_host_org_vector_type)
	{
		this.pdbx_host_org_vector_type = pdbx_host_org_vector_type;
	}

 	protected java.lang.String plasmid_details;


	/**
	 *  A description of special aspects of the plasmid that produced the
	 *  entity in the host organism. Where full details of the protein
	 *  production are available it would be expected that this item
	 *  would be derived from  attribute details in category pdbx_construct of the construct
	 *  pointed to from  attribute plasmid_id in category entity_src_gen_express.
	 */
	public java.lang.String getPlasmid_details() 
	{
		return plasmid_details;
	}
 
	public void setPlasmid_details(java.lang.String plasmid_details)
	{
		this.plasmid_details = plasmid_details;
	}

 	protected java.lang.String plasmid_name;


	/**
	 *  The name of the plasmid that produced the entity in the host
	 *  organism. Where full details of the protein production are available
	 *  it would be expected that this item would be derived from
	 *  attribute name in category pdbx_construct of the construct pointed to from
	 *  attribute plasmid_id in category entity_src_gen_express.
	 *  pET3C
	 *  pT123sab
	 */
	public java.lang.String getPlasmid_name() 
	{
		return plasmid_name;
	}
 
	public void setPlasmid_name(java.lang.String plasmid_name)
	{
		this.plasmid_name = plasmid_name;
	}

 	protected java.lang.String start_construct_id;


	/**
	 *  A pointer to  attribute id in category pdbx_construct in the PDBX_CONSTRUCT category.
	 *  The indentified sequence is the initial construct.
	 */
	public java.lang.String getStart_construct_id() 
	{
		return start_construct_id;
	}
 
	public void setStart_construct_id(java.lang.String start_construct_id)
	{
		this.start_construct_id = start_construct_id;
	}

 }
