package org.pdb.beans;

/**
 *  Data items in the ENTITY_SRC_NAT category record details of
 *  the source from which the entity was obtained in cases
 *  where the entity was isolated directly from a natural tissue.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_src_natCategory>
 *  <PDBx:entity_src_nat entity_id="2">
 *  <PDBx:common_name>bacteria</PDBx:common_name>
 *  <PDBx:genus>Actinomycetes</PDBx:genus>
 *  <PDBx:species xsi:nil="true" />
 *  <PDBx:details>    Acetyl-pepstatin was isolated by Dr. K. Oda, Osaka
 *  Prefecture University, and provided to us by Dr. Ben
 *  Dunn, University of Florida, and Dr. J. Kay, University
 *  of Wales.</PDBx:details>
 *  </PDBx:entity_src_nat>
 *  </PDBx:entity_src_natCategory>
 * </pre>
 */
public class Entity_src_nat 
{
		protected java.lang.String common_name;


	/**
	 *  The common name of the organism from which the entity
	 *  was isolated.
	 *  man
	 *  yeast
	 *  bacteria
	 */
	public java.lang.String getCommon_name() 
	{
		return common_name;
	}
 
	public void setCommon_name(java.lang.String common_name)
	{
		this.common_name = common_name;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the organism from which the
	 *  entity was isolated.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String genus;


	/**
	 *  The genus of the organism from which the entity was isolated.
	 *  Homo
	 *  Saccharomyces
	 *  Escherichia
	 */
	public java.lang.String getGenus() 
	{
		return genus;
	}
 
	public void setGenus(java.lang.String genus)
	{
		this.genus = genus;
	}

 	protected java.lang.String pdbx_atcc;


	/**
	 *  Americal Tissue Culture Collection number.
	 *  6051
	 */
	public java.lang.String getPdbx_atcc() 
	{
		return pdbx_atcc;
	}
 
	public void setPdbx_atcc(java.lang.String pdbx_atcc)
	{
		this.pdbx_atcc = pdbx_atcc;
	}

 	protected java.lang.String pdbx_cell;


	/**
	 *  A particular cell type.
	 *  BHK-21
	 */
	public java.lang.String getPdbx_cell() 
	{
		return pdbx_cell;
	}
 
	public void setPdbx_cell(java.lang.String pdbx_cell)
	{
		this.pdbx_cell = pdbx_cell;
	}

 	protected java.lang.String pdbx_cell_line;


	/**
	 *  The specific line of cells.
	 *  HELA
	 */
	public java.lang.String getPdbx_cell_line() 
	{
		return pdbx_cell_line;
	}
 
	public void setPdbx_cell_line(java.lang.String pdbx_cell_line)
	{
		this.pdbx_cell_line = pdbx_cell_line;
	}

 	protected java.lang.String pdbx_cellular_location;


	/**
	 *  Identifies the location inside (or outside) the cell.
	 */
	public java.lang.String getPdbx_cellular_location() 
	{
		return pdbx_cellular_location;
	}
 
	public void setPdbx_cellular_location(java.lang.String pdbx_cellular_location)
	{
		this.pdbx_cellular_location = pdbx_cellular_location;
	}

 	protected java.lang.String pdbx_fragment;


	/**
	 *  A domain or fragment of the molecule.
	 */
	public java.lang.String getPdbx_fragment() 
	{
		return pdbx_fragment;
	}
 
	public void setPdbx_fragment(java.lang.String pdbx_fragment)
	{
		this.pdbx_fragment = pdbx_fragment;
	}

 	protected java.lang.String pdbx_ncbi_taxonomy_id;


	/**
	 *  NCBI Taxonomy identifier for the source organism.
	 *  
	 *  Reference:
	 *  
	 *  Wheeler DL, Chappey C, Lash AE, Leipe DD, Madden TL, Schuler GD,
	 *  Tatusova TA, Rapp BA (2000). Database resources of the National
	 *  Center for Biotechnology Information. Nucleic Acids Res 2000 Jan
	 *  1;28(1):10-4
	 *  
	 *  Benson DA, Karsch-Mizrachi I, Lipman DJ, Ostell J, Rapp BA,
	 *  Wheeler DL (2000). GenBank. Nucleic Acids Res 2000 Jan 1;28(1):15-18.
	 */
	public java.lang.String getPdbx_ncbi_taxonomy_id() 
	{
		return pdbx_ncbi_taxonomy_id;
	}
 
	public void setPdbx_ncbi_taxonomy_id(java.lang.String pdbx_ncbi_taxonomy_id)
	{
		this.pdbx_ncbi_taxonomy_id = pdbx_ncbi_taxonomy_id;
	}

 	protected java.lang.String pdbx_organ;


	/**
	 *  Organized group of tissues that carries on a specialized function.
	 *  KIDNEY
	 */
	public java.lang.String getPdbx_organ() 
	{
		return pdbx_organ;
	}
 
	public void setPdbx_organ(java.lang.String pdbx_organ)
	{
		this.pdbx_organ = pdbx_organ;
	}

 	protected java.lang.String pdbx_organelle;


	/**
	 *  Organized structure within cell.
	 *  MITOCHONDRIA
	 */
	public java.lang.String getPdbx_organelle() 
	{
		return pdbx_organelle;
	}
 
	public void setPdbx_organelle(java.lang.String pdbx_organelle)
	{
		this.pdbx_organelle = pdbx_organelle;
	}

 	protected java.lang.String pdbx_organism_scientific;


	/**
	 *  Scientific name of the organism of the natural source.
	 *  BOS TAURUS
	 *  SUS SCROFA
	 *  ASPERGILLUS ORYZAE
	 */
	public java.lang.String getPdbx_organism_scientific() 
	{
		return pdbx_organism_scientific;
	}
 
	public void setPdbx_organism_scientific(java.lang.String pdbx_organism_scientific)
	{
		this.pdbx_organism_scientific = pdbx_organism_scientific;
	}

 	protected java.lang.String pdbx_plasmid_details;


	/**
	 *  Details about the plasmid.
	 *  PLC28 DERIVATIVE
	 */
	public java.lang.String getPdbx_plasmid_details() 
	{
		return pdbx_plasmid_details;
	}
 
	public void setPdbx_plasmid_details(java.lang.String pdbx_plasmid_details)
	{
		this.pdbx_plasmid_details = pdbx_plasmid_details;
	}

 	protected java.lang.String pdbx_plasmid_name;


	/**
	 *  The plasmid containing the gene.
	 *  pB322
	 */
	public java.lang.String getPdbx_plasmid_name() 
	{
		return pdbx_plasmid_name;
	}
 
	public void setPdbx_plasmid_name(java.lang.String pdbx_plasmid_name)
	{
		this.pdbx_plasmid_name = pdbx_plasmid_name;
	}

 	protected java.lang.String pdbx_secretion;


	/**
	 *  Identifies the secretion from which the molecule was isolated.
	 *  saliva
	 *  urine
	 *  venom
	 */
	public java.lang.String getPdbx_secretion() 
	{
		return pdbx_secretion;
	}
 
	public void setPdbx_secretion(java.lang.String pdbx_secretion)
	{
		this.pdbx_secretion = pdbx_secretion;
	}

 	protected java.lang.String pdbx_variant;


	/**
	 *  Identifies the variant.
	 */
	public java.lang.String getPdbx_variant() 
	{
		return pdbx_variant;
	}
 
	public void setPdbx_variant(java.lang.String pdbx_variant)
	{
		this.pdbx_variant = pdbx_variant;
	}

 	protected java.lang.String species;


	/**
	 *  The species of the organism from which the entity was isolated.
	 *  sapiens
	 *  cerevisiae
	 *  coli
	 */
	public java.lang.String getSpecies() 
	{
		return species;
	}
 
	public void setSpecies(java.lang.String species)
	{
		this.species = species;
	}

 	protected java.lang.String strain;


	/**
	 *  The strain of the organism from which the entity was isolated.
	 *  DH5a
	 *  BMH 71-18
	 */
	public java.lang.String getStrain() 
	{
		return strain;
	}
 
	public void setStrain(java.lang.String strain)
	{
		this.strain = strain;
	}

 	protected java.lang.String tissue;


	/**
	 *  The tissue of the organism from which the entity was isolated.
	 *  heart
	 *  liver
	 *  eye lens
	 */
	public java.lang.String getTissue() 
	{
		return tissue;
	}
 
	public void setTissue(java.lang.String tissue)
	{
		this.tissue = tissue;
	}

 	protected java.lang.String tissue_fraction;


	/**
	 *  The subcellular fraction of the tissue of the organism from
	 *  which the entity was isolated.
	 *  mitochondria
	 *  nucleus
	 *  membrane
	 */
	public java.lang.String getTissue_fraction() 
	{
		return tissue_fraction;
	}
 
	public void setTissue_fraction(java.lang.String tissue_fraction)
	{
		this.tissue_fraction = tissue_fraction;
	}

 }
