package org.pdb.beans;

/**
 *  Data items in the EXPTL category record details about the
 *  experimental work prior to the intensity measurements and
 *  details about the absorption-correction technique employed.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for Yb(S-C5H4N)2(THF)4.
 *  <PDBx:exptlCategory>
 *  <PDBx:exptl entry_id="datablock1">
 *  <PDBx:absorpt_coefficient_mu>1.22</PDBx:absorpt_coefficient_mu>
 *  <PDBx:absorpt_correction_T_max>0.896</PDBx:absorpt_correction_T_max>
 *  <PDBx:absorpt_correction_T_min>0.802</PDBx:absorpt_correction_T_min>
 *  <PDBx:absorpt_correction_type>integration</PDBx:absorpt_correction_type>
 *  <PDBx:absorpt_process_details> Gaussian grid method from SHELX76
 *  Sheldrick, G. M., &quot;SHELX-76: structure determination and
 *  refinement program&quot;, Cambridge University, UK, 1976</PDBx:absorpt_process_details>
 *  <PDBx:crystals_number>1</PDBx:crystals_number>
 *  <PDBx:details> Enraf-Nonius LT2 liquid nitrogen variable-temperature
 *  device used</PDBx:details>
 *  <PDBx:method>single-crystal x-ray diffraction</PDBx:method>
 *  <PDBx:method_details> graphite monochromatized Cu K(alpha) fixed tube and
 *  Enraf-Nonius CAD4 diffractometer used</PDBx:method_details>
 *  </PDBx:exptl>
 *  </PDBx:exptlCategory>
 * </pre>
 */
public class Exptl 
{
		protected java.lang.Float absorpt_coefficient_mu;


	/**
	 *  The absorption coefficient mu in reciprocal millimetres
	 *  calculated from the atomic content of the cell, the density and
	 *  the radiation wavelength.
	 */
	public java.lang.Float getAbsorpt_coefficient_mu() 
	{
		return absorpt_coefficient_mu;
	}
 
	public void setAbsorpt_coefficient_mu(java.lang.Float absorpt_coefficient_mu)
	{
		this.absorpt_coefficient_mu = absorpt_coefficient_mu;
	}

 	protected java.lang.Float absorpt_correction_T_max;


	/**
	 *  The maximum transmission factor for the crystal and radiation.
	 *  The maximum and minimum transmission factors are also referred
	 *  to as the absorption correction
	 *  A or 1/A*.
	 */
	public java.lang.Float getAbsorpt_correction_T_max() 
	{
		return absorpt_correction_T_max;
	}
 
	public void setAbsorpt_correction_T_max(java.lang.Float absorpt_correction_T_max)
	{
		this.absorpt_correction_T_max = absorpt_correction_T_max;
	}

 	protected java.lang.Float absorpt_correction_T_min;


	/**
	 *  The minimum transmission factor for the crystal and radiation.
	 *  The maximum and minimum transmission factors are also referred
	 *  to as the absorption correction
	 *  A or 1/A*.
	 */
	public java.lang.Float getAbsorpt_correction_T_min() 
	{
		return absorpt_correction_T_min;
	}
 
	public void setAbsorpt_correction_T_min(java.lang.Float absorpt_correction_T_min)
	{
		this.absorpt_correction_T_min = absorpt_correction_T_min;
	}

 	protected java.lang.String absorpt_correction_type;


	/**
	 *  The absorption correction type and method. The value
	 *  'empirical' should NOT be used unless more detailed
	 *  information is not available.
	 */
	public java.lang.String getAbsorpt_correction_type() 
	{
		return absorpt_correction_type;
	}
 
	public void setAbsorpt_correction_type(java.lang.String absorpt_correction_type)
	{
		this.absorpt_correction_type = absorpt_correction_type;
	}

 	protected java.lang.String absorpt_process_details;


	/**
	 *  Description of the absorption process applied to the
	 *  intensities. A literature reference should be supplied for
	 *  psi-scan techniques.
	 *  Tompa analytical
	 */
	public java.lang.String getAbsorpt_process_details() 
	{
		return absorpt_process_details;
	}
 
	public void setAbsorpt_process_details(java.lang.String absorpt_process_details)
	{
		this.absorpt_process_details = absorpt_process_details;
	}

 	protected java.lang.Integer crystals_number;


	/**
	 *  The total number of crystals used in the  measurement of
	 *  intensities.
	 */
	public java.lang.Integer getCrystals_number() 
	{
		return crystals_number;
	}
 
	public void setCrystals_number(java.lang.Integer crystals_number)
	{
		this.crystals_number = crystals_number;
	}

 	protected java.lang.String details;


	/**
	 *  Any special information about the experimental work prior to the
	 *  intensity measurement. See also  attribute preparation in category exptl_crystal.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This data item is a pointer to  attribute id in category entry in the ENTRY category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method;


	/**
	 *  The method used in the experiment.
	 *  single-crystal x-ray diffraction
	 *  single-crystal neutron diffraction
	 *  single-crystal electron diffraction
	 *  fiber x-ray diffraction
	 *  fiber neutron diffraction
	 *  fiber electron diffraction
	 *  single-crystal joint x-ray and neutron diffraction
	 *  single-crystal joint x-ray and electron diffraction
	 *  solution nmr
	 *  solid-state nmr
	 *  theoretical model
	 *  other
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.String method_details;


	/**
	 *  A description of special aspects of the experimental method.
	 *  29 structures
	 *  minimized average structure
	 */
	public java.lang.String getMethod_details() 
	{
		return method_details;
	}
 
	public void setMethod_details(java.lang.String method_details)
	{
		this.method_details = method_details;
	}

 }
