package org.pdb.beans;

/**
 *  Data items in the EXPTL_CRYSTAL_GROW category record details
 *  about the conditions and methods used to grow the crystal.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:exptl_crystal_growCategory>
 *  <PDBx:exptl_crystal_grow crystal_id="1">
 *  <PDBx:method>hanging drop</PDBx:method>
 *  <PDBx:apparatus>Linbro plates</PDBx:apparatus>
 *  <PDBx:atmosphere>room air</PDBx:atmosphere>
 *  <PDBx:pH>4.7</PDBx:pH>
 *  <PDBx:temp>18(3).</PDBx:temp>
 *  <PDBx:time>approximately 2 days</PDBx:time>
 *  </PDBx:exptl_crystal_grow>
 *  </PDBx:exptl_crystal_growCategory>
 * </pre>
 */
public class Exptl_crystal_grow 
{
		protected java.lang.String apparatus;


	/**
	 *  The physical apparatus in which the crystal was grown.
	 *  Linbro plate
	 *  sandwich box
	 *  ACA plates
	 */
	public java.lang.String getApparatus() 
	{
		return apparatus;
	}
 
	public void setApparatus(java.lang.String apparatus)
	{
		this.apparatus = apparatus;
	}

 	protected java.lang.String atmosphere;


	/**
	 *  The nature of the gas or gas mixture in which the crystal was
	 *  grown.
	 *  room air
	 *  nitrogen
	 *  argon
	 */
	public java.lang.String getAtmosphere() 
	{
		return atmosphere;
	}
 
	public void setAtmosphere(java.lang.String atmosphere)
	{
		this.atmosphere = atmosphere;
	}

 	protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of special aspects of the crystal growth.
	 *  Solution 2 was prepared as a well solution and
	 *  mixed. A droplet containing 2 \ml of solution
	 *  1 was delivered onto a cover slip; 2 \ml of
	 *  solution 2 was added to the droplet without
	 *  mixing.
	 *  Crystal plates were originally stored at room
	 *  temperature for 1 week but no nucleation
	 *  occurred. They were then transferred to 4
	 *  degrees C, at which temperature well formed
	 *  single crystals grew in 2 days.
	 *  The dependence on pH for successful crystal
	 *  growth is very sharp. At pH 7.4 only showers
	 *  of tiny crystals grew, at pH 7.5 well formed
	 *  single crystals grew, at pH 7.6 no
	 *  crystallization occurred at all.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String method;


	/**
	 *  The method used to grow the crystals.
	 *  batch precipitation
	 *  batch dialysis
	 *  hanging drop vapor diffusion
	 *  sitting drop vapor diffusion
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.String method_ref;


	/**
	 *  A literature reference that describes the method used to grow
	 *  the crystals.
	 *  McPherson et al., 1988
	 */
	public java.lang.String getMethod_ref() 
	{
		return method_ref;
	}
 
	public void setMethod_ref(java.lang.String method_ref)
	{
		this.method_ref = method_ref;
	}

 	protected java.lang.Float pH;


	/**
	 *  The pH at which the crystal was grown. If more than one pH was
	 *  employed during the crystallization process, the final pH should
	 *  be noted here and the protocol involving multiple pH values
	 *  should be described in  attribute details in category exptl_crystal_grow.
	 *  7.4
	 *  7.6
	 *  4.3
	 */
	public java.lang.Float getPH() 
	{
		return pH;
	}
 
	public void setPH(java.lang.Float pH)
	{
		this.pH = pH;
	}

 	protected java.lang.String pdbx_details;


	/**
	 *  Text description of crystal grow procedure.
	 *  PEG 4000, potassium phosphate, magnesium chloride, cacodylate
	 */
	public java.lang.String getPdbx_details() 
	{
		return pdbx_details;
	}
 
	public void setPdbx_details(java.lang.String pdbx_details)
	{
		this.pdbx_details = pdbx_details;
	}

 	protected java.lang.String pdbx_pH_range;


	/**
	 *  The range of pH values at which the crystal was grown.   Used when
	 *  a point estimate of pH is not appropriate.
	 *  5.6 - 6.4
	 */
	public java.lang.String getPdbx_pH_range() 
	{
		return pdbx_pH_range;
	}
 
	public void setPdbx_pH_range(java.lang.String pdbx_pH_range)
	{
		this.pdbx_pH_range = pdbx_pH_range;
	}

 	protected java.lang.Float pressure;


	/**
	 *  The ambient pressure in kilopascals at which the crystal was
	 *  grown.
	 */
	public java.lang.Float getPressure() 
	{
		return pressure;
	}
 
	public void setPressure(java.lang.Float pressure)
	{
		this.pressure = pressure;
	}

 	protected java.lang.Float pressure_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute pressure in category exptl_crystal_grow.
	 */
	public java.lang.Float getPressure_esd() 
	{
		return pressure_esd;
	}
 
	public void setPressure_esd(java.lang.Float pressure_esd)
	{
		this.pressure_esd = pressure_esd;
	}

 	protected java.lang.String seeding;


	/**
	 *  A description of the protocol used for seeding the crystal
	 *  growth.
	 *  macroseeding
	 *  Microcrystals were introduced from a previous
	 *  crystal growth experiment by transfer with a
	 *  human hair.
	 */
	public java.lang.String getSeeding() 
	{
		return seeding;
	}
 
	public void setSeeding(java.lang.String seeding)
	{
		this.seeding = seeding;
	}

 	protected java.lang.String seeding_ref;


	/**
	 *  A literature reference that describes the protocol used to seed
	 *  the crystal.
	 *  Stura et al., 1989
	 */
	public java.lang.String getSeeding_ref() 
	{
		return seeding_ref;
	}
 
	public void setSeeding_ref(java.lang.String seeding_ref)
	{
		this.seeding_ref = seeding_ref;
	}

 	protected java.lang.Float temp;


	/**
	 *  The temperature in kelvins at which the crystal was grown.
	 *  If more than one temperature was employed during the
	 *  crystallization process, the final temperature should be noted
	 *  here and the protocol  involving multiple temperatures should be
	 *  described in  attribute details in category exptl_crystal_grow.
	 */
	public java.lang.Float getTemp() 
	{
		return temp;
	}
 
	public void setTemp(java.lang.Float temp)
	{
		this.temp = temp;
	}

 	protected java.lang.String temp_details;


	/**
	 *  A description of special aspects of temperature control during
	 *  crystal growth.
	 */
	public java.lang.String getTemp_details() 
	{
		return temp_details;
	}
 
	public void setTemp_details(java.lang.String temp_details)
	{
		this.temp_details = temp_details;
	}

 	protected java.lang.Float temp_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute temp in category exptl_crystal_grow.
	 */
	public java.lang.Float getTemp_esd() 
	{
		return temp_esd;
	}
 
	public void setTemp_esd(java.lang.Float temp_esd)
	{
		this.temp_esd = temp_esd;
	}

 	protected java.lang.String time;


	/**
	 *  The approximate time that the crystal took to grow to the size
	 *  used for data collection.
	 *  overnight
	 *  2-4 days
	 *  6 months
	 */
	public java.lang.String getTime() 
	{
		return time;
	}
 
	public void setTime(java.lang.String time)
	{
		this.time = time;
	}

 }
