package org.pdb.beans;

/**
 *  Data items in the EXPTL_CRYSTAL_GROW_COMP category record
 *  details about the components of the solutions that were 'mixed'
 *  (by whatever means) to produce the crystal.
 *  
 *  In general, solution 1 is the solution that contains the
 *  molecule to be crystallized and solution 2 is the solution
 *  that contains the precipitant. However, the number of solutions
 *  required to describe the crystallization protocol is not limited
 *  to 2.
 *  
 *  Details of the crystallization protocol should be given in
 *  attribute details in category exptl_crystal_grow_comp using the solutions
 *  described in EXPTL_CRYSTAL_GROW_COMP.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:exptl_crystal_grow_compCategory>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="1">
 *  <PDBx:sol_id>1</PDBx:sol_id>
 *  <PDBx:name>HIV-1 protease</PDBx:name>
 *  <PDBx:volume>0.002 ml</PDBx:volume>
 *  <PDBx:conc>6 mg/ml</PDBx:conc>
 *  <PDBx:details> The protein solution was in a buffer containing 25 mM NaCl,
 *  100 mM NaMES/ MES buffer, pH 7.5, 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="2">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>NaCl</PDBx:name>
 *  <PDBx:volume>0.200 ml</PDBx:volume>
 *  <PDBx:conc>4    M</PDBx:conc>
 *  <PDBx:details>in 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="3">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>Acetic Acid</PDBx:name>
 *  <PDBx:volume>0.047 ml</PDBx:volume>
 *  <PDBx:conc>100 mM</PDBx:conc>
 *  <PDBx:details>in 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="4">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>Na Acetate</PDBx:name>
 *  <PDBx:volume>0.053 ml</PDBx:volume>
 *  <PDBx:conc>100 mM</PDBx:conc>
 *  <PDBx:details> in 3 mM NaAzide. Buffer components were mixed to produce a
 *  pH of 4.7 according to a ratio calculated from the pKa. The
 *  actual pH of solution 2 was not measured.</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="5">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>water</PDBx:name>
 *  <PDBx:volume>0.700 ml</PDBx:volume>
 *  <PDBx:conc>neat</PDBx:conc>
 *  <PDBx:details>in 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  </PDBx:exptl_crystal_grow_compCategory>
 * </pre>
 */
public class Exptl_crystal_grow_comp 
{
		protected java.lang.String conc;


	/**
	 *  The concentration of the solution component.
	 *  200 \ml
	 *  0.1 ml
	 */
	public java.lang.String getConc() 
	{
		return conc;
	}
 
	public void setConc(java.lang.String conc)
	{
		this.conc = conc;
	}

 	protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.String details;


	/**
	 *  A description of any special aspects of the solution component.
	 *  When the solution component is the one that contains the
	 *  macromolecule, this could be the specification of the buffer in
	 *  which the macromolecule was stored. When the solution component
	 *  is a buffer component, this could be the methods (or formula)
	 *  used to achieve a desired pH.
	 *  in 3 mM NaAzide
	 *  The protein solution was in a buffer
	 *  containing 25 mM NaCl, 100 mM NaMES/MES
	 *  buffer, pH 7.5, 3 mM NaAzide
	 *  in 3 mM NaAzide. Buffer components were mixed
	 *  to produce a pH of 4.7 according to a ratio
	 *  calculated from the pKa. The actual pH of
	 *  solution 2 was not measured.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category exptl_crystal_grow_comp must uniquely identify
	 *  each item in the EXPTL_CRYSTAL_GROW_COMP list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  1
	 *  A
	 *  protein in buffer
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String name;


	/**
	 *  A common name for the component of the solution.
	 *  protein in buffer
	 *  acetic acid
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String sol_id;


	/**
	 *  An identifier for the solution to which the given solution
	 *  component belongs.
	 *  1
	 *  well solution
	 *  solution A
	 */
	public java.lang.String getSol_id() 
	{
		return sol_id;
	}
 
	public void setSol_id(java.lang.String sol_id)
	{
		this.sol_id = sol_id;
	}

 	protected java.lang.String volume;


	/**
	 *  The volume of the solution component.
	 *  200 \ml
	 *  0.1 ml
	 */
	public java.lang.String getVolume() 
	{
		return volume;
	}
 
	public void setVolume(java.lang.String volume)
	{
		this.volume = volume;
	}

 }
