package org.pdb.beans;

/**
 *  Data items in the GEOM_CONTACT category record details about
 *  interatomic contacts as calculated from the contents
 *  of the ATOM, CELL and SYMMETRY data.
 *  
 * <pre>
 *  Example 1 - based on data set CLPHO6 of Ferguson, Ruhl, McKervey & Browne
 *  [Acta Cryst. (1992), C48, 2262-2264].
 *  <PDBx:geom_contactCategory>
 *  <PDBx:geom_contact atom_site_id_1="O(1)" atom_site_id_2="O(2)" site_symmetry_1="" site_symmetry_2="">
 *  <PDBx:dist>2.735</PDBx:dist>
 *  <PDBx:dist_esd>0.003</PDBx:dist_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_contact>
 *  <PDBx:geom_contact atom_site_id_1="H(O1)" atom_site_id_2="O(2)" site_symmetry_1="" site_symmetry_2="">
 *  <PDBx:dist>1.82</PDBx:dist>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_contact>
 *  </PDBx:geom_contactCategory>
 * </pre>
 */
public class Geom_contact 
{
		protected java.lang.String atom_site_auth_asym_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_1() 
	{
		return atom_site_auth_asym_id_1;
	}
 
	public void setAtom_site_auth_asym_id_1(java.lang.String atom_site_auth_asym_id_1)
	{
		this.atom_site_auth_asym_id_1 = atom_site_auth_asym_id_1;
	}

 	protected java.lang.String atom_site_auth_asym_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_2() 
	{
		return atom_site_auth_asym_id_2;
	}
 
	public void setAtom_site_auth_asym_id_2(java.lang.String atom_site_auth_asym_id_2)
	{
		this.atom_site_auth_asym_id_2 = atom_site_auth_asym_id_2;
	}

 	protected java.lang.String atom_site_auth_atom_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_1() 
	{
		return atom_site_auth_atom_id_1;
	}
 
	public void setAtom_site_auth_atom_id_1(java.lang.String atom_site_auth_atom_id_1)
	{
		this.atom_site_auth_atom_id_1 = atom_site_auth_atom_id_1;
	}

 	protected java.lang.String atom_site_auth_atom_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_2() 
	{
		return atom_site_auth_atom_id_2;
	}
 
	public void setAtom_site_auth_atom_id_2(java.lang.String atom_site_auth_atom_id_2)
	{
		this.atom_site_auth_atom_id_2 = atom_site_auth_atom_id_2;
	}

 	protected java.lang.String atom_site_auth_comp_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_1() 
	{
		return atom_site_auth_comp_id_1;
	}
 
	public void setAtom_site_auth_comp_id_1(java.lang.String atom_site_auth_comp_id_1)
	{
		this.atom_site_auth_comp_id_1 = atom_site_auth_comp_id_1;
	}

 	protected java.lang.String atom_site_auth_comp_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_2() 
	{
		return atom_site_auth_comp_id_2;
	}
 
	public void setAtom_site_auth_comp_id_2(java.lang.String atom_site_auth_comp_id_2)
	{
		this.atom_site_auth_comp_id_2 = atom_site_auth_comp_id_2;
	}

 	protected java.lang.String atom_site_auth_seq_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_1() 
	{
		return atom_site_auth_seq_id_1;
	}
 
	public void setAtom_site_auth_seq_id_1(java.lang.String atom_site_auth_seq_id_1)
	{
		this.atom_site_auth_seq_id_1 = atom_site_auth_seq_id_1;
	}

 	protected java.lang.String atom_site_auth_seq_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_2() 
	{
		return atom_site_auth_seq_id_2;
	}
 
	public void setAtom_site_auth_seq_id_2(java.lang.String atom_site_auth_seq_id_2)
	{
		this.atom_site_auth_seq_id_2 = atom_site_auth_seq_id_2;
	}

 	protected java.lang.String atom_site_id_1;


	/**
	 *  The identifier of the first of the two atom sites that define the
	 *  contact.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_1() 
	{
		return atom_site_id_1;
	}
 
	public void setAtom_site_id_1(java.lang.String atom_site_id_1)
	{
		this.atom_site_id_1 = atom_site_id_1;
	}

 	protected java.lang.String atom_site_id_2;


	/**
	 *  The identifier of the second of the two atom sites that define
	 *  the contact.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_2() 
	{
		return atom_site_id_2;
	}
 
	public void setAtom_site_id_2(java.lang.String atom_site_id_2)
	{
		this.atom_site_id_2 = atom_site_id_2;
	}

 	protected java.lang.String atom_site_label_alt_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_1() 
	{
		return atom_site_label_alt_id_1;
	}
 
	public void setAtom_site_label_alt_id_1(java.lang.String atom_site_label_alt_id_1)
	{
		this.atom_site_label_alt_id_1 = atom_site_label_alt_id_1;
	}

 	protected java.lang.String atom_site_label_alt_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_2() 
	{
		return atom_site_label_alt_id_2;
	}
 
	public void setAtom_site_label_alt_id_2(java.lang.String atom_site_label_alt_id_2)
	{
		this.atom_site_label_alt_id_2 = atom_site_label_alt_id_2;
	}

 	protected java.lang.String atom_site_label_asym_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_1() 
	{
		return atom_site_label_asym_id_1;
	}
 
	public void setAtom_site_label_asym_id_1(java.lang.String atom_site_label_asym_id_1)
	{
		this.atom_site_label_asym_id_1 = atom_site_label_asym_id_1;
	}

 	protected java.lang.String atom_site_label_asym_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_2() 
	{
		return atom_site_label_asym_id_2;
	}
 
	public void setAtom_site_label_asym_id_2(java.lang.String atom_site_label_asym_id_2)
	{
		this.atom_site_label_asym_id_2 = atom_site_label_asym_id_2;
	}

 	protected java.lang.String atom_site_label_atom_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_1() 
	{
		return atom_site_label_atom_id_1;
	}
 
	public void setAtom_site_label_atom_id_1(java.lang.String atom_site_label_atom_id_1)
	{
		this.atom_site_label_atom_id_1 = atom_site_label_atom_id_1;
	}

 	protected java.lang.String atom_site_label_atom_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_2() 
	{
		return atom_site_label_atom_id_2;
	}
 
	public void setAtom_site_label_atom_id_2(java.lang.String atom_site_label_atom_id_2)
	{
		this.atom_site_label_atom_id_2 = atom_site_label_atom_id_2;
	}

 	protected java.lang.String atom_site_label_comp_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_1() 
	{
		return atom_site_label_comp_id_1;
	}
 
	public void setAtom_site_label_comp_id_1(java.lang.String atom_site_label_comp_id_1)
	{
		this.atom_site_label_comp_id_1 = atom_site_label_comp_id_1;
	}

 	protected java.lang.String atom_site_label_comp_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_2() 
	{
		return atom_site_label_comp_id_2;
	}
 
	public void setAtom_site_label_comp_id_2(java.lang.String atom_site_label_comp_id_2)
	{
		this.atom_site_label_comp_id_2 = atom_site_label_comp_id_2;
	}

 	protected java.lang.Integer atom_site_label_seq_id_1;


	/**
	 *  An optional identifier of the first of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_1() 
	{
		return atom_site_label_seq_id_1;
	}
 
	public void setAtom_site_label_seq_id_1(java.lang.Integer atom_site_label_seq_id_1)
	{
		this.atom_site_label_seq_id_1 = atom_site_label_seq_id_1;
	}

 	protected java.lang.Integer atom_site_label_seq_id_2;


	/**
	 *  An optional identifier of the second of the two atom sites that
	 *  define the contact.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_2() 
	{
		return atom_site_label_seq_id_2;
	}
 
	public void setAtom_site_label_seq_id_2(java.lang.Integer atom_site_label_seq_id_2)
	{
		this.atom_site_label_seq_id_2 = atom_site_label_seq_id_2;
	}

 	protected java.lang.Float dist;


	/**
	 *  The interatomic contact distance in angstroms.
	 */
	public java.lang.Float getDist() 
	{
		return dist;
	}
 
	public void setDist(java.lang.Float dist)
	{
		this.dist = dist;
	}

 	protected java.lang.Float dist_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute dist in category geom_contact.
	 */
	public java.lang.Float getDist_esd() 
	{
		return dist_esd;
	}
 
	public void setDist_esd(java.lang.Float dist_esd)
	{
		this.dist_esd = dist_esd;
	}

 	protected java.lang.Integer pdbx_PDB_model_num;


	/**
	 *  Pointer to  attribute pdbx_PDB_model_num in category atom_site
	 */
	public java.lang.Integer getPdbx_PDB_model_num() 
	{
		return pdbx_PDB_model_num;
	}
 
	public void setPdbx_PDB_model_num(java.lang.Integer pdbx_PDB_model_num)
	{
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_1;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_1() 
	{
		return pdbx_atom_site_PDB_ins_code_1;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_1(java.lang.String pdbx_atom_site_PDB_ins_code_1)
	{
		this.pdbx_atom_site_PDB_ins_code_1 = pdbx_atom_site_PDB_ins_code_1;
	}

 	protected java.lang.String pdbx_atom_site_PDB_ins_code_2;


	/**
	 *  Pointer to  attribute pdbx_PDB_ins_code in category atom_site.
	 */
	public java.lang.String getPdbx_atom_site_PDB_ins_code_2() 
	{
		return pdbx_atom_site_PDB_ins_code_2;
	}
 
	public void setPdbx_atom_site_PDB_ins_code_2(java.lang.String pdbx_atom_site_PDB_ins_code_2)
	{
		this.pdbx_atom_site_PDB_ins_code_2 = pdbx_atom_site_PDB_ins_code_2;
	}

 	protected java.lang.String publ_flag;


	/**
	 *  This code signals whether the contact distance is referred to
	 *  in a publication or should be placed in a list of significant
	 *  contact distances.
	 */
	public java.lang.String getPubl_flag() 
	{
		return publ_flag;
	}
 
	public void setPubl_flag(java.lang.String publ_flag)
	{
		this.publ_flag = publ_flag;
	}

 	protected java.lang.String site_symmetry_1;


	/**
	 *  The symmetry code of the first of the two atom sites that
	 *  define the contact.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_1() 
	{
		return site_symmetry_1;
	}
 
	public void setSite_symmetry_1(java.lang.String site_symmetry_1)
	{
		this.site_symmetry_1 = site_symmetry_1;
	}

 	protected java.lang.String site_symmetry_2;


	/**
	 *  The symmetry code of the second of the two atom sites that
	 *  define the contact.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_2() 
	{
		return site_symmetry_2;
	}
 
	public void setSite_symmetry_2(java.lang.String site_symmetry_2)
	{
		this.site_symmetry_2 = site_symmetry_2;
	}

 }
