package org.pdb.beans;

/**
 *  Data items in the GEOM_HBOND category record details about
 *  hydrogen bonds as calculated from the contents of the ATOM,
 *  CELL and SYMMETRY data.
 *  
 * <pre>
 *  Example 1 - based on C~14~H~13~ClN~2~O.H~2~O, reported by Palmer,
 *  Puddle & Lisgarten [Acta Cryst. (1993), C49, 1777-1779].
 *  <PDBx:geom_hbondCategory>
 *  <PDBx:geom_hbond atom_site_id_D="N6" atom_site_id_H="HN6" atom_site_id_A="OW">
 *  <PDBx:dist_DH>0.888</PDBx:dist_DH>
 *  <PDBx:dist_HA>1.921</PDBx:dist_HA>
 *  <PDBx:dist_DA>2.801</PDBx:dist_DA>
 *  <PDBx:angle_DHA>169.6</PDBx:angle_DHA>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_hbond>
 *  <PDBx:geom_hbond atom_site_id_D="OW" atom_site_id_H="HO2" atom_site_id_A="O7">
 *  <PDBx:dist_DH>0.917</PDBx:dist_DH>
 *  <PDBx:dist_HA>1.923</PDBx:dist_HA>
 *  <PDBx:dist_DA>2.793</PDBx:dist_DA>
 *  <PDBx:angle_DHA>153.5</PDBx:angle_DHA>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_hbond>
 *  <PDBx:geom_hbond atom_site_id_D="OW" atom_site_id_H="HO1" atom_site_id_A="N10">
 *  <PDBx:dist_DH>0.894</PDBx:dist_DH>
 *  <PDBx:dist_HA>1.886</PDBx:dist_HA>
 *  <PDBx:dist_DA>2.842</PDBx:dist_DA>
 *  <PDBx:angle_DHA>179.7</PDBx:angle_DHA>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_hbond>
 *  </PDBx:geom_hbondCategory>
 * </pre>
 */
public class Geom_hbond 
{
		protected java.lang.Float angle_DHA;


	/**
	 *  The angle in degrees defined by the donor-, hydrogen- and
	 *  acceptor-atom sites in a hydrogen bond.
	 */
	public java.lang.Float getAngle_DHA() 
	{
		return angle_DHA;
	}
 
	public void setAngle_DHA(java.lang.Float angle_DHA)
	{
		this.angle_DHA = angle_DHA;
	}

 	protected java.lang.Float angle_DHA_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  of  attribute angle_DHA in category geom_hbond.
	 */
	public java.lang.Float getAngle_DHA_esd() 
	{
		return angle_DHA_esd;
	}
 
	public void setAngle_DHA_esd(java.lang.Float angle_DHA_esd)
	{
		this.angle_DHA_esd = angle_DHA_esd;
	}

 	protected java.lang.String atom_site_auth_asym_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_A() 
	{
		return atom_site_auth_asym_id_A;
	}
 
	public void setAtom_site_auth_asym_id_A(java.lang.String atom_site_auth_asym_id_A)
	{
		this.atom_site_auth_asym_id_A = atom_site_auth_asym_id_A;
	}

 	protected java.lang.String atom_site_auth_asym_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_D() 
	{
		return atom_site_auth_asym_id_D;
	}
 
	public void setAtom_site_auth_asym_id_D(java.lang.String atom_site_auth_asym_id_D)
	{
		this.atom_site_auth_asym_id_D = atom_site_auth_asym_id_D;
	}

 	protected java.lang.String atom_site_auth_asym_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_asym_id_H() 
	{
		return atom_site_auth_asym_id_H;
	}
 
	public void setAtom_site_auth_asym_id_H(java.lang.String atom_site_auth_asym_id_H)
	{
		this.atom_site_auth_asym_id_H = atom_site_auth_asym_id_H;
	}

 	protected java.lang.String atom_site_auth_atom_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_A() 
	{
		return atom_site_auth_atom_id_A;
	}
 
	public void setAtom_site_auth_atom_id_A(java.lang.String atom_site_auth_atom_id_A)
	{
		this.atom_site_auth_atom_id_A = atom_site_auth_atom_id_A;
	}

 	protected java.lang.String atom_site_auth_atom_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_D() 
	{
		return atom_site_auth_atom_id_D;
	}
 
	public void setAtom_site_auth_atom_id_D(java.lang.String atom_site_auth_atom_id_D)
	{
		this.atom_site_auth_atom_id_D = atom_site_auth_atom_id_D;
	}

 	protected java.lang.String atom_site_auth_atom_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_atom_id_H() 
	{
		return atom_site_auth_atom_id_H;
	}
 
	public void setAtom_site_auth_atom_id_H(java.lang.String atom_site_auth_atom_id_H)
	{
		this.atom_site_auth_atom_id_H = atom_site_auth_atom_id_H;
	}

 	protected java.lang.String atom_site_auth_comp_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_A() 
	{
		return atom_site_auth_comp_id_A;
	}
 
	public void setAtom_site_auth_comp_id_A(java.lang.String atom_site_auth_comp_id_A)
	{
		this.atom_site_auth_comp_id_A = atom_site_auth_comp_id_A;
	}

 	protected java.lang.String atom_site_auth_comp_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_D() 
	{
		return atom_site_auth_comp_id_D;
	}
 
	public void setAtom_site_auth_comp_id_D(java.lang.String atom_site_auth_comp_id_D)
	{
		this.atom_site_auth_comp_id_D = atom_site_auth_comp_id_D;
	}

 	protected java.lang.String atom_site_auth_comp_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_comp_id_H() 
	{
		return atom_site_auth_comp_id_H;
	}
 
	public void setAtom_site_auth_comp_id_H(java.lang.String atom_site_auth_comp_id_H)
	{
		this.atom_site_auth_comp_id_H = atom_site_auth_comp_id_H;
	}

 	protected java.lang.String atom_site_auth_seq_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_A() 
	{
		return atom_site_auth_seq_id_A;
	}
 
	public void setAtom_site_auth_seq_id_A(java.lang.String atom_site_auth_seq_id_A)
	{
		this.atom_site_auth_seq_id_A = atom_site_auth_seq_id_A;
	}

 	protected java.lang.String atom_site_auth_seq_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_D() 
	{
		return atom_site_auth_seq_id_D;
	}
 
	public void setAtom_site_auth_seq_id_D(java.lang.String atom_site_auth_seq_id_D)
	{
		this.atom_site_auth_seq_id_D = atom_site_auth_seq_id_D;
	}

 	protected java.lang.String atom_site_auth_seq_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_auth_seq_id_H() 
	{
		return atom_site_auth_seq_id_H;
	}
 
	public void setAtom_site_auth_seq_id_H(java.lang.String atom_site_auth_seq_id_H)
	{
		this.atom_site_auth_seq_id_H = atom_site_auth_seq_id_H;
	}

 	protected java.lang.String atom_site_id_A;


	/**
	 *  The identifier of the acceptor-atom site that defines the
	 *  hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_A() 
	{
		return atom_site_id_A;
	}
 
	public void setAtom_site_id_A(java.lang.String atom_site_id_A)
	{
		this.atom_site_id_A = atom_site_id_A;
	}

 	protected java.lang.String atom_site_id_D;


	/**
	 *  The identifier of the donor-atom site that defines the hydrogen
	 *  bond.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_D() 
	{
		return atom_site_id_D;
	}
 
	public void setAtom_site_id_D(java.lang.String atom_site_id_D)
	{
		this.atom_site_id_D = atom_site_id_D;
	}

 	protected java.lang.String atom_site_id_H;


	/**
	 *  The identifier of the hydrogen-atom site that defines the
	 *  hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute id in category atom_site in the ATOM_SITE
	 *  category.
	 */
	public java.lang.String getAtom_site_id_H() 
	{
		return atom_site_id_H;
	}
 
	public void setAtom_site_id_H(java.lang.String atom_site_id_H)
	{
		this.atom_site_id_H = atom_site_id_H;
	}

 	protected java.lang.String atom_site_label_alt_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_A() 
	{
		return atom_site_label_alt_id_A;
	}
 
	public void setAtom_site_label_alt_id_A(java.lang.String atom_site_label_alt_id_A)
	{
		this.atom_site_label_alt_id_A = atom_site_label_alt_id_A;
	}

 	protected java.lang.String atom_site_label_alt_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_D() 
	{
		return atom_site_label_alt_id_D;
	}
 
	public void setAtom_site_label_alt_id_D(java.lang.String atom_site_label_alt_id_D)
	{
		this.atom_site_label_alt_id_D = atom_site_label_alt_id_D;
	}

 	protected java.lang.String atom_site_label_alt_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_alt_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_alt_id_H() 
	{
		return atom_site_label_alt_id_H;
	}
 
	public void setAtom_site_label_alt_id_H(java.lang.String atom_site_label_alt_id_H)
	{
		this.atom_site_label_alt_id_H = atom_site_label_alt_id_H;
	}

 	protected java.lang.String atom_site_label_asym_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_A() 
	{
		return atom_site_label_asym_id_A;
	}
 
	public void setAtom_site_label_asym_id_A(java.lang.String atom_site_label_asym_id_A)
	{
		this.atom_site_label_asym_id_A = atom_site_label_asym_id_A;
	}

 	protected java.lang.String atom_site_label_asym_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_D() 
	{
		return atom_site_label_asym_id_D;
	}
 
	public void setAtom_site_label_asym_id_D(java.lang.String atom_site_label_asym_id_D)
	{
		this.atom_site_label_asym_id_D = atom_site_label_asym_id_D;
	}

 	protected java.lang.String atom_site_label_asym_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_asym_id_H() 
	{
		return atom_site_label_asym_id_H;
	}
 
	public void setAtom_site_label_asym_id_H(java.lang.String atom_site_label_asym_id_H)
	{
		this.atom_site_label_asym_id_H = atom_site_label_asym_id_H;
	}

 	protected java.lang.String atom_site_label_atom_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_A() 
	{
		return atom_site_label_atom_id_A;
	}
 
	public void setAtom_site_label_atom_id_A(java.lang.String atom_site_label_atom_id_A)
	{
		this.atom_site_label_atom_id_A = atom_site_label_atom_id_A;
	}

 	protected java.lang.String atom_site_label_atom_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_D() 
	{
		return atom_site_label_atom_id_D;
	}
 
	public void setAtom_site_label_atom_id_D(java.lang.String atom_site_label_atom_id_D)
	{
		this.atom_site_label_atom_id_D = atom_site_label_atom_id_D;
	}

 	protected java.lang.String atom_site_label_atom_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_atom_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_atom_id_H() 
	{
		return atom_site_label_atom_id_H;
	}
 
	public void setAtom_site_label_atom_id_H(java.lang.String atom_site_label_atom_id_H)
	{
		this.atom_site_label_atom_id_H = atom_site_label_atom_id_H;
	}

 	protected java.lang.String atom_site_label_comp_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_A() 
	{
		return atom_site_label_comp_id_A;
	}
 
	public void setAtom_site_label_comp_id_A(java.lang.String atom_site_label_comp_id_A)
	{
		this.atom_site_label_comp_id_A = atom_site_label_comp_id_A;
	}

 	protected java.lang.String atom_site_label_comp_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_D() 
	{
		return atom_site_label_comp_id_D;
	}
 
	public void setAtom_site_label_comp_id_D(java.lang.String atom_site_label_comp_id_D)
	{
		this.atom_site_label_comp_id_D = atom_site_label_comp_id_D;
	}

 	protected java.lang.String atom_site_label_comp_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getAtom_site_label_comp_id_H() 
	{
		return atom_site_label_comp_id_H;
	}
 
	public void setAtom_site_label_comp_id_H(java.lang.String atom_site_label_comp_id_H)
	{
		this.atom_site_label_comp_id_H = atom_site_label_comp_id_H;
	}

 	protected java.lang.Integer atom_site_label_seq_id_A;


	/**
	 *  An optional identifier of the acceptor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_A() 
	{
		return atom_site_label_seq_id_A;
	}
 
	public void setAtom_site_label_seq_id_A(java.lang.Integer atom_site_label_seq_id_A)
	{
		this.atom_site_label_seq_id_A = atom_site_label_seq_id_A;
	}

 	protected java.lang.Integer atom_site_label_seq_id_D;


	/**
	 *  An optional identifier of the donor-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_D() 
	{
		return atom_site_label_seq_id_D;
	}
 
	public void setAtom_site_label_seq_id_D(java.lang.Integer atom_site_label_seq_id_D)
	{
		this.atom_site_label_seq_id_D = atom_site_label_seq_id_D;
	}

 	protected java.lang.Integer atom_site_label_seq_id_H;


	/**
	 *  An optional identifier of the hydrogen-atom site that defines
	 *  the hydrogen bond.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getAtom_site_label_seq_id_H() 
	{
		return atom_site_label_seq_id_H;
	}
 
	public void setAtom_site_label_seq_id_H(java.lang.Integer atom_site_label_seq_id_H)
	{
		this.atom_site_label_seq_id_H = atom_site_label_seq_id_H;
	}

 	protected java.lang.Float dist_DA;


	/**
	 *  The distance in angstroms between the donor- and acceptor-atom
	 *  sites in a hydrogen bond.
	 */
	public java.lang.Float getDist_DA() 
	{
		return dist_DA;
	}
 
	public void setDist_DA(java.lang.Float dist_DA)
	{
		this.dist_DA = dist_DA;
	}

 	protected java.lang.Float dist_DA_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  in angstroms of  attribute dist_DA in category geom_hbond.
	 */
	public java.lang.Float getDist_DA_esd() 
	{
		return dist_DA_esd;
	}
 
	public void setDist_DA_esd(java.lang.Float dist_DA_esd)
	{
		this.dist_DA_esd = dist_DA_esd;
	}

 	protected java.lang.Float dist_DH;


	/**
	 *  The distance in angstroms between the donor- and hydrogen-atom
	 *  sites in a hydrogen bond.
	 */
	public java.lang.Float getDist_DH() 
	{
		return dist_DH;
	}
 
	public void setDist_DH(java.lang.Float dist_DH)
	{
		this.dist_DH = dist_DH;
	}

 	protected java.lang.Float dist_DH_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  in angstroms of  attribute dist_DH in category geom_hbond.
	 */
	public java.lang.Float getDist_DH_esd() 
	{
		return dist_DH_esd;
	}
 
	public void setDist_DH_esd(java.lang.Float dist_DH_esd)
	{
		this.dist_DH_esd = dist_DH_esd;
	}

 	protected java.lang.Float dist_HA;


	/**
	 *  The distance in angstroms between the hydrogen- and acceptor-
	 *  atom sites in a hydrogen bond.
	 */
	public java.lang.Float getDist_HA() 
	{
		return dist_HA;
	}
 
	public void setDist_HA(java.lang.Float dist_HA)
	{
		this.dist_HA = dist_HA;
	}

 	protected java.lang.Float dist_HA_esd;


	/**
	 *  The standard uncertainty (estimated standard deviation)
	 *  in angstroms of  attribute dist_HA in category geom_hbond.
	 */
	public java.lang.Float getDist_HA_esd() 
	{
		return dist_HA_esd;
	}
 
	public void setDist_HA_esd(java.lang.Float dist_HA_esd)
	{
		this.dist_HA_esd = dist_HA_esd;
	}

 	protected java.lang.String publ_flag;


	/**
	 *  This code signals whether the hydrogen-bond information is
	 *  referred to in a publication or should be placed in a table of
	 *  significant hydrogen-bond geometry.
	 */
	public java.lang.String getPubl_flag() 
	{
		return publ_flag;
	}
 
	public void setPubl_flag(java.lang.String publ_flag)
	{
		this.publ_flag = publ_flag;
	}

 	protected java.lang.String site_symmetry_A;


	/**
	 *  The symmetry code of the acceptor-atom site that defines the
	 *  hydrogen bond.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_A() 
	{
		return site_symmetry_A;
	}
 
	public void setSite_symmetry_A(java.lang.String site_symmetry_A)
	{
		this.site_symmetry_A = site_symmetry_A;
	}

 	protected java.lang.String site_symmetry_D;


	/**
	 *  The symmetry code of the donor-atom site that defines the
	 *  hydrogen bond.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_D() 
	{
		return site_symmetry_D;
	}
 
	public void setSite_symmetry_D(java.lang.String site_symmetry_D)
	{
		this.site_symmetry_D = site_symmetry_D;
	}

 	protected java.lang.String site_symmetry_H;


	/**
	 *  The symmetry code of the hydrogen-atom site that defines the
	 *  hydrogen bond.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getSite_symmetry_H() 
	{
		return site_symmetry_H;
	}
 
	public void setSite_symmetry_H(java.lang.String site_symmetry_H)
	{
		this.site_symmetry_H = site_symmetry_H;
	}

 }
