package org.pdb.beans;

/**
 *  Data items in the NDB_STRUCT_NA_BASE_PAIR_STEP category record details
 *  of base pair step interactions.
 *  <PDBx:ndb_struct_na_base_pair_stepCategory>
 *  <PDBx:ndb_struct_na_base_pair_step model_number="1" i_label_comp_id_1="G" i_label_asym_id_1="A" i_label_seq_id_1="1" i_symmetry_1="1_555" j_label_comp_id_1="C" j_label_asym_id_1="A" j_label_seq_id_1="8" j_symmetry_1="7_555" i_label_comp_id_2="G" i_label_asym_id_2="A" i_label_seq_id_2="2" i_symmetry_2="1_555" j_label_comp_id_2="C" j_label_asym_id_2="A" j_label_seq_id_2="7" j_symmetry_2="7_555">
 *  <PDBx:shift>0.369</PDBx:shift>
 *  <PDBx:slide>-1.414</PDBx:slide>
 *  <PDBx:rise>3.339</PDBx:rise>
 *  <PDBx:tilt>3.056</PDBx:tilt>
 *  <PDBx:roll>9.755</PDBx:roll>
 *  <PDBx:twist>33.530</PDBx:twist>
 *  </PDBx:ndb_struct_na_base_pair_step>
 *  <PDBx:ndb_struct_na_base_pair_step model_number="1" i_label_comp_id_1="G" i_label_asym_id_1="A" i_label_seq_id_1="2" i_symmetry_1="1_555" j_label_comp_id_1="C" j_label_asym_id_1="A" j_label_seq_id_1="7" j_symmetry_1="7_555" i_label_comp_id_2="G" i_label_asym_id_2="A" i_label_seq_id_2="3" i_symmetry_2="1_555" j_label_comp_id_2="C" j_label_asym_id_2="A" j_label_seq_id_2="6" j_symmetry_2="7_555">
 *  <PDBx:shift>0.176</PDBx:shift>
 *  <PDBx:slide>-1.672</PDBx:slide>
 *  <PDBx:rise>3.371</PDBx:rise>
 *  <PDBx:tilt>-1.176</PDBx:tilt>
 *  <PDBx:roll>6.725</PDBx:roll>
 *  <PDBx:twist>30.004</PDBx:twist>
 *  </PDBx:ndb_struct_na_base_pair_step>
 *  </PDBx:ndb_struct_na_base_pair_stepCategory>
 */
public class Ndb_struct_na_base_pair_step 
{
		protected java.lang.Float helical_rise;


	/**
	 *  The value of the base pair step helical rise parameter.
	 */
	public java.lang.Float getHelical_rise() 
	{
		return helical_rise;
	}
 
	public void setHelical_rise(java.lang.Float helical_rise)
	{
		this.helical_rise = helical_rise;
	}

 	protected java.lang.Float helical_twist;


	/**
	 *  The value of the base pair step helical twist parameter.
	 */
	public java.lang.Float getHelical_twist() 
	{
		return helical_twist;
	}
 
	public void setHelical_twist(java.lang.Float helical_twist)
	{
		this.helical_twist = helical_twist;
	}

 	protected java.lang.String i_PDB_ins_code_1;


	/**
	 *  Describes the PDB insertion code of the i-th base in the
	 *  first base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in
	 *  the ATOM_SITE category.
	 */
	public java.lang.String getI_PDB_ins_code_1() 
	{
		return i_PDB_ins_code_1;
	}
 
	public void setI_PDB_ins_code_1(java.lang.String i_PDB_ins_code_1)
	{
		this.i_PDB_ins_code_1 = i_PDB_ins_code_1;
	}

 	protected java.lang.String i_PDB_ins_code_2;


	/**
	 *  Describes the PDB insertion code of the i-th base in the
	 *  second base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in
	 *  the ATOM_SITE category.
	 */
	public java.lang.String getI_PDB_ins_code_2() 
	{
		return i_PDB_ins_code_2;
	}
 
	public void setI_PDB_ins_code_2(java.lang.String i_PDB_ins_code_2)
	{
		this.i_PDB_ins_code_2 = i_PDB_ins_code_2;
	}

 	protected java.lang.String i_auth_asym_id_1;


	/**
	 *  Describes the author's asym id of the i-th base in the first
	 *  base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_auth_asym_id_1() 
	{
		return i_auth_asym_id_1;
	}
 
	public void setI_auth_asym_id_1(java.lang.String i_auth_asym_id_1)
	{
		this.i_auth_asym_id_1 = i_auth_asym_id_1;
	}

 	protected java.lang.String i_auth_asym_id_2;


	/**
	 *  Describes the author's asym id of the i-th base in the second
	 *  base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_auth_asym_id_2() 
	{
		return i_auth_asym_id_2;
	}
 
	public void setI_auth_asym_id_2(java.lang.String i_auth_asym_id_2)
	{
		this.i_auth_asym_id_2 = i_auth_asym_id_2;
	}

 	protected java.lang.String i_auth_seq_id_1;


	/**
	 *  Describes the author's sequence number of the i-th base in the
	 *  first base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_auth_seq_id_1() 
	{
		return i_auth_seq_id_1;
	}
 
	public void setI_auth_seq_id_1(java.lang.String i_auth_seq_id_1)
	{
		this.i_auth_seq_id_1 = i_auth_seq_id_1;
	}

 	protected java.lang.String i_auth_seq_id_2;


	/**
	 *  Describes the author's sequence number of the i-th base in the
	 *  second base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_auth_seq_id_2() 
	{
		return i_auth_seq_id_2;
	}
 
	public void setI_auth_seq_id_2(java.lang.String i_auth_seq_id_2)
	{
		this.i_auth_seq_id_2 = i_auth_seq_id_2;
	}

 	protected java.lang.String i_label_asym_id_1;


	/**
	 *  Describes the asym id of the i-th base in the first base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_label_asym_id_1() 
	{
		return i_label_asym_id_1;
	}
 
	public void setI_label_asym_id_1(java.lang.String i_label_asym_id_1)
	{
		this.i_label_asym_id_1 = i_label_asym_id_1;
	}

 	protected java.lang.String i_label_asym_id_2;


	/**
	 *  Describes the asym id of the i-th base in the second base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_label_asym_id_2() 
	{
		return i_label_asym_id_2;
	}
 
	public void setI_label_asym_id_2(java.lang.String i_label_asym_id_2)
	{
		this.i_label_asym_id_2 = i_label_asym_id_2;
	}

 	protected java.lang.String i_label_comp_id_1;


	/**
	 *  Describes the component id of the i-th base in the first base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_label_comp_id_1() 
	{
		return i_label_comp_id_1;
	}
 
	public void setI_label_comp_id_1(java.lang.String i_label_comp_id_1)
	{
		this.i_label_comp_id_1 = i_label_comp_id_1;
	}

 	protected java.lang.String i_label_comp_id_2;


	/**
	 *  Describes the component id of the i-th base in the second base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getI_label_comp_id_2() 
	{
		return i_label_comp_id_2;
	}
 
	public void setI_label_comp_id_2(java.lang.String i_label_comp_id_2)
	{
		this.i_label_comp_id_2 = i_label_comp_id_2;
	}

 	protected java.lang.Integer i_label_seq_id_1;


	/**
	 *  Describes the sequence number of the i-th base in the first base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getI_label_seq_id_1() 
	{
		return i_label_seq_id_1;
	}
 
	public void setI_label_seq_id_1(java.lang.Integer i_label_seq_id_1)
	{
		this.i_label_seq_id_1 = i_label_seq_id_1;
	}

 	protected java.lang.Integer i_label_seq_id_2;


	/**
	 *  Describes the sequence number of the i-th base in the second base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getI_label_seq_id_2() 
	{
		return i_label_seq_id_2;
	}
 
	public void setI_label_seq_id_2(java.lang.Integer i_label_seq_id_2)
	{
		this.i_label_seq_id_2 = i_label_seq_id_2;
	}

 	protected java.lang.String i_symmetry_1;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  coordinates of the i-th base to generate the first partner
	 *  in the first base pair of the step.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getI_symmetry_1() 
	{
		return i_symmetry_1;
	}
 
	public void setI_symmetry_1(java.lang.String i_symmetry_1)
	{
		this.i_symmetry_1 = i_symmetry_1;
	}

 	protected java.lang.String i_symmetry_2;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  coordinates of the i-th base to generate the first partner
	 *  in the second base pair of the step.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getI_symmetry_2() 
	{
		return i_symmetry_2;
	}
 
	public void setI_symmetry_2(java.lang.String i_symmetry_2)
	{
		this.i_symmetry_2 = i_symmetry_2;
	}

 	protected java.lang.Float inclination;


	/**
	 *  The value of the base pair step inclination parameter.
	 */
	public java.lang.Float getInclination() 
	{
		return inclination;
	}
 
	public void setInclination(java.lang.Float inclination)
	{
		this.inclination = inclination;
	}

 	protected java.lang.String j_PDB_ins_code_1;


	/**
	 *  Describes the PDB insertion code of the j-th base in the
	 *  first base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in
	 *  the ATOM_SITE category.
	 */
	public java.lang.String getJ_PDB_ins_code_1() 
	{
		return j_PDB_ins_code_1;
	}
 
	public void setJ_PDB_ins_code_1(java.lang.String j_PDB_ins_code_1)
	{
		this.j_PDB_ins_code_1 = j_PDB_ins_code_1;
	}

 	protected java.lang.String j_PDB_ins_code_2;


	/**
	 *  Describes the PDB insertion code of the j-th base in the
	 *  second base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_ins_code in category atom_site in
	 *  the ATOM_SITE category.
	 */
	public java.lang.String getJ_PDB_ins_code_2() 
	{
		return j_PDB_ins_code_2;
	}
 
	public void setJ_PDB_ins_code_2(java.lang.String j_PDB_ins_code_2)
	{
		this.j_PDB_ins_code_2 = j_PDB_ins_code_2;
	}

 	protected java.lang.String j_auth_asym_id_1;


	/**
	 *  Describes the author's asym id of the j-th base in the first
	 *  base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_auth_asym_id_1() 
	{
		return j_auth_asym_id_1;
	}
 
	public void setJ_auth_asym_id_1(java.lang.String j_auth_asym_id_1)
	{
		this.j_auth_asym_id_1 = j_auth_asym_id_1;
	}

 	protected java.lang.String j_auth_asym_id_2;


	/**
	 *  Describes the author's asym id of the j-th base in the second
	 *  base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_auth_asym_id_2() 
	{
		return j_auth_asym_id_2;
	}
 
	public void setJ_auth_asym_id_2(java.lang.String j_auth_asym_id_2)
	{
		this.j_auth_asym_id_2 = j_auth_asym_id_2;
	}

 	protected java.lang.String j_auth_seq_id_1;


	/**
	 *  Describes the author's sequence number of the j-th base in the
	 *  first base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_auth_seq_id_1() 
	{
		return j_auth_seq_id_1;
	}
 
	public void setJ_auth_seq_id_1(java.lang.String j_auth_seq_id_1)
	{
		this.j_auth_seq_id_1 = j_auth_seq_id_1;
	}

 	protected java.lang.String j_auth_seq_id_2;


	/**
	 *  Describes the author's sequence number of the j-th base in the
	 *  second base pair of the step.
	 *  
	 *  This data item is a pointer to  attribute auth_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_auth_seq_id_2() 
	{
		return j_auth_seq_id_2;
	}
 
	public void setJ_auth_seq_id_2(java.lang.String j_auth_seq_id_2)
	{
		this.j_auth_seq_id_2 = j_auth_seq_id_2;
	}

 	protected java.lang.String j_label_asym_id_1;


	/**
	 *  Describes the asym id of the j-th base in the first base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_label_asym_id_1() 
	{
		return j_label_asym_id_1;
	}
 
	public void setJ_label_asym_id_1(java.lang.String j_label_asym_id_1)
	{
		this.j_label_asym_id_1 = j_label_asym_id_1;
	}

 	protected java.lang.String j_label_asym_id_2;


	/**
	 *  Describes the asym id of the j-th base in the second base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_asym_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_label_asym_id_2() 
	{
		return j_label_asym_id_2;
	}
 
	public void setJ_label_asym_id_2(java.lang.String j_label_asym_id_2)
	{
		this.j_label_asym_id_2 = j_label_asym_id_2;
	}

 	protected java.lang.String j_label_comp_id_1;


	/**
	 *  Describes the component id of the j-th base in the first base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_label_comp_id_1() 
	{
		return j_label_comp_id_1;
	}
 
	public void setJ_label_comp_id_1(java.lang.String j_label_comp_id_1)
	{
		this.j_label_comp_id_1 = j_label_comp_id_1;
	}

 	protected java.lang.String j_label_comp_id_2;


	/**
	 *  Describes the component id of the j-th base in the second base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_comp_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.String getJ_label_comp_id_2() 
	{
		return j_label_comp_id_2;
	}
 
	public void setJ_label_comp_id_2(java.lang.String j_label_comp_id_2)
	{
		this.j_label_comp_id_2 = j_label_comp_id_2;
	}

 	protected java.lang.Integer j_label_seq_id_1;


	/**
	 *  Describes the sequence number of the j-th base in the first base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getJ_label_seq_id_1() 
	{
		return j_label_seq_id_1;
	}
 
	public void setJ_label_seq_id_1(java.lang.Integer j_label_seq_id_1)
	{
		this.j_label_seq_id_1 = j_label_seq_id_1;
	}

 	protected java.lang.Integer j_label_seq_id_2;


	/**
	 *  Describes the sequence number of the j-th base in the second base pair
	 *  of the step.
	 *  
	 *  This data item is a pointer to  attribute label_seq_id in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getJ_label_seq_id_2() 
	{
		return j_label_seq_id_2;
	}
 
	public void setJ_label_seq_id_2(java.lang.Integer j_label_seq_id_2)
	{
		this.j_label_seq_id_2 = j_label_seq_id_2;
	}

 	protected java.lang.String j_symmetry_1;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  coordinates of the j-th base to generate the second partner
	 *  in the first base pair of the step.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getJ_symmetry_1() 
	{
		return j_symmetry_1;
	}
 
	public void setJ_symmetry_1(java.lang.String j_symmetry_1)
	{
		this.j_symmetry_1 = j_symmetry_1;
	}

 	protected java.lang.String j_symmetry_2;


	/**
	 *  Describes the symmetry operation that should be applied to the
	 *  coordinates of the j-th base to generate the second partner
	 *  in the second base pair of the step.
	 *  no symmetry or translation to site
	 *  4th symmetry operation applied
	 *  4
	 *  7th symm. posn.; +a on x; -b on y
	 *  7_645
	 */
	public java.lang.String getJ_symmetry_2() 
	{
		return j_symmetry_2;
	}
 
	public void setJ_symmetry_2(java.lang.String j_symmetry_2)
	{
		this.j_symmetry_2 = j_symmetry_2;
	}

 	protected java.lang.Integer model_number;


	/**
	 *  Describes the model number of the the base pair step.
	 *  
	 *  This data item is a pointer to  attribute pdbx_PDB_model_num in category atom_site in the
	 *  ATOM_SITE category.
	 */
	public java.lang.Integer getModel_number() 
	{
		return model_number;
	}
 
	public void setModel_number(java.lang.Integer model_number)
	{
		this.model_number = model_number;
	}

 	protected java.lang.Float rise;


	/**
	 *  The value of the base pair step rise parameter.
	 */
	public java.lang.Float getRise() 
	{
		return rise;
	}
 
	public void setRise(java.lang.Float rise)
	{
		this.rise = rise;
	}

 	protected java.lang.Float roll;


	/**
	 *  The value of the base pair step roll parameter.
	 */
	public java.lang.Float getRoll() 
	{
		return roll;
	}
 
	public void setRoll(java.lang.Float roll)
	{
		this.roll = roll;
	}

 	protected java.lang.Float shift;


	/**
	 *  The value of the base pair step shift parameter.
	 */
	public java.lang.Float getShift() 
	{
		return shift;
	}
 
	public void setShift(java.lang.Float shift)
	{
		this.shift = shift;
	}

 	protected java.lang.Float slide;


	/**
	 *  The value of the base pair step slide parameter.
	 */
	public java.lang.Float getSlide() 
	{
		return slide;
	}
 
	public void setSlide(java.lang.Float slide)
	{
		this.slide = slide;
	}

 	protected java.lang.String step_name;


	/**
	 *  The text name of this step.
	 */
	public java.lang.String getStep_name() 
	{
		return step_name;
	}
 
	public void setStep_name(java.lang.String step_name)
	{
		this.step_name = step_name;
	}

 	protected java.lang.Integer step_number;


	/**
	 *  The sequence number of this step in the step sequence.
	 */
	public java.lang.Integer getStep_number() 
	{
		return step_number;
	}
 
	public void setStep_number(java.lang.Integer step_number)
	{
		this.step_number = step_number;
	}

 	protected java.lang.Float tilt;


	/**
	 *  The value of the base pair step tilt parameter.
	 */
	public java.lang.Float getTilt() 
	{
		return tilt;
	}
 
	public void setTilt(java.lang.Float tilt)
	{
		this.tilt = tilt;
	}

 	protected java.lang.Float tip;


	/**
	 *  The value of the base pair step twist parameter.
	 */
	public java.lang.Float getTip() 
	{
		return tip;
	}
 
	public void setTip(java.lang.Float tip)
	{
		this.tip = tip;
	}

 	protected java.lang.Float twist;


	/**
	 *  The value of the base pair step twist parameter.
	 */
	public java.lang.Float getTwist() 
	{
		return twist;
	}
 
	public void setTwist(java.lang.Float twist)
	{
		this.twist = twist;
	}

 	protected java.lang.Float x_displacement;


	/**
	 *  The value of the base pair step X displacement parameter.
	 */
	public java.lang.Float getX_displacement() 
	{
		return x_displacement;
	}
 
	public void setX_displacement(java.lang.Float x_displacement)
	{
		this.x_displacement = x_displacement;
	}

 	protected java.lang.Float y_displacement;


	/**
	 *  The value of the base pair step Y displacement parameter.
	 */
	public java.lang.Float getY_displacement() 
	{
		return y_displacement;
	}
 
	public void setY_displacement(java.lang.Float y_displacement)
	{
		this.y_displacement = y_displacement;
	}

 }
