package org.pdb.beans;

/**
 *  Data items in the PDBX_CONTACT_AUTHOR category record details
 *  about the Structural Genomics Project and name and initials
 *  for each Center.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_SG_projectCategory>
 *  <PDBx:pdbx_SG_project id="1">
 *  <PDBx:project_name>PSI, Protein Structure Initiative</PDBx:project_name>
 *  <PDBx:full_name_of_center>Berkeley Structural Genomics Center</PDBx:full_name_of_center>
 *  <PDBx:initial_of_center>BSGC</PDBx:initial_of_center>
 *  </PDBx:pdbx_SG_project>
 *  </PDBx:pdbx_SG_projectCategory>
 * </pre>
 */
public class Pdbx_SG_project 
{
		protected java.lang.String full_name_of_center;


	/**
	 *  The value identifies the full name of center.
	 *  Berkeley Structural Genomics Center
	 */
	public java.lang.String getFull_name_of_center() 
	{
		return full_name_of_center;
	}
 
	public void setFull_name_of_center(java.lang.String full_name_of_center)
	{
		this.full_name_of_center = full_name_of_center;
	}

 	protected java.lang.Integer id_;


	/**
	 *  A unique integer identifier for this center
	 *  1 2 3
	 */
	public java.lang.Integer getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.Integer id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String initial_of_center;


	/**
	 *  The value identifies the full name of center.
	 *  BSGC
	 */
	public java.lang.String getInitial_of_center() 
	{
		return initial_of_center;
	}
 
	public void setInitial_of_center(java.lang.String initial_of_center)
	{
		this.initial_of_center = initial_of_center;
	}

 	protected java.lang.String project_name;


	/**
	 *  The value identifies the Structural Genomics project.
	 *  PSI, Protein Structure Initiative
	 */
	public java.lang.String getProject_name() 
	{
		return project_name;
	}
 
	public void setProject_name(java.lang.String project_name)
	{
		this.project_name = project_name;
	}

 }
