package org.pdb.beans;

/**
 *  Data items in the PDBX_CHEM_COMP_ATOM_EDIT category provide
 *  atom level editing instructions to be applied to imported
 *  chemical components.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_chem_comp_atom_editCategory>
 *  <PDBx:pdbx_chem_comp_atom_edit ordinal="1">
 *  <PDBx:comp_id>LYS</PDBx:comp_id>
 *  <PDBx:edit_op>DELETE</PDBx:edit_op>
 *  <PDBx:atom_id>HN2</PDBx:atom_id>
 *  </PDBx:pdbx_chem_comp_atom_edit>
 *  </PDBx:pdbx_chem_comp_atom_editCategory>
 * </pre>
 */
public class Pdbx_chem_comp_atom_edit 
{
		protected java.lang.String atom_id;


	/**
	 *  The identifier for the target atom in imported component to be edited.
	 */
	public java.lang.String getAtom_id() 
	{
		return atom_id;
	}
 
	public void setAtom_id(java.lang.String atom_id)
	{
		this.atom_id = atom_id;
	}

 	protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute comp_id in category pdbx_chem_comp_import in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.String edit_atom_id;


	/**
	 *  The identifier for the edited atom in the generated component.
	 */
	public java.lang.String getEdit_atom_id() 
	{
		return edit_atom_id;
	}
 
	public void setEdit_atom_id(java.lang.String edit_atom_id)
	{
		this.edit_atom_id = edit_atom_id;
	}

 	protected java.lang.String edit_atom_value;


	/**
	 *  The value for the edited atomic property value in the generated component.
	 */
	public java.lang.String getEdit_atom_value() 
	{
		return edit_atom_value;
	}
 
	public void setEdit_atom_value(java.lang.String edit_atom_value)
	{
		this.edit_atom_value = edit_atom_value;
	}

 	protected java.lang.String edit_op;


	/**
	 *  The operation applied to the named imported component.
	 */
	public java.lang.String getEdit_op() 
	{
		return edit_op;
	}
 
	public void setEdit_op(java.lang.String edit_op)
	{
		this.edit_op = edit_op;
	}

 	protected java.lang.Integer ordinal;


	/**
	 *  This data item uniquely identifies and orders each  atom edit instruction.
	 */
	public java.lang.Integer getOrdinal() 
	{
		return ordinal;
	}
 
	public void setOrdinal(java.lang.Integer ordinal)
	{
		this.ordinal = ordinal;
	}

 }
