package org.pdb.beans;

/**
 *  Data items in the PDBX_CHEM_COMP_IMPORT category identify
 *  existing chemical components to be imported into the
 *  current component definition.  Components in this list
 *  can be edited by instructions in categories
 *  pdbx_chem_comp_atom_edit and pdbx_chem_comp_bond_edit.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_chem_comp_importCategory>
 *  <PDBx:pdbx_chem_comp_import comp_id="ATP"></PDBx:pdbx_chem_comp_import>
 *  </PDBx:pdbx_chem_comp_importCategory>
 * </pre>
 */
public class Pdbx_chem_comp_import 
{
		protected java.lang.String comp_id;


	/**
	 *  This data item is a pointer to  attribute id in category chem_comp in the CHEM_COMP
	 *  category.
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 }
