package org.pdb.beans;

/**
 *  Data items in the PDBX_CONSTRUCT category specify a sequence of
 *  nucleic acids or amino acids. It is a catch-all that may be used to
 *  provide details of sequences known to be relevant to the project as well
 *  as primers, plasmids, proteins and such like that are either used or
 *  produced during the protein production process. Molecules described
 *  here are not necessarily complete, so for instance it would be
 *  possible to include either a complete plasmid or just its insert.
 *  This category may be considered as an abbreviated form of _entity where
 *  the molecules described are not required to appear in the final co-ordinates.
 *  
 *  Note that the details provided here all pertain to a single entry as defined
 *  at deposition. It is anticipated that  attribute id in category pdbx_construct would also be
 *  composed of a sequence that is unique within a given site prefixed by a code
 *  that identifies that site and would, therefore, be GLOBALLY unique. Thus
 *  this category could also be used locally to store details about the different
 *  constructs used during protein production without reference to the entry_id
 *  (which only becomes a  meaningful concept during deposition).
 *  
 * <pre>
 *  Example 1 - hypothetical example
 *  <PDBx:pdbx_constructCategory>
 *  <PDBx:pdbx_construct id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>DNA</PDBx:type>
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:seq>  gatgctgtag gcataggctt ggttatgccg gtactgccgg gcctcttgcg ggatatcgtc
 *  gctcaaggcg cactcccgtt ctggataatg ttttttgcgc cgacatcata acggttctgg
 *  caaatattct gaaatgagct gttgacaatt aatcatcgat aagcttcttg
 *  # - - - - data truncated for brevity - - - -</PDBx:seq>
 *  </PDBx:pdbx_construct>
 *  </PDBx:pdbx_constructCategory>
 * </pre>
 */
public class Pdbx_construct 
{
		protected java.lang.String class_;


	/**
	 *  The primary function of the construct. This should be considered
	 *  as a guideline only.
	 */
	public java.lang.String getClass_() 
	{
		return class_;
	}
 
	public void setClass_(java.lang.String class_)
	{
		this.class_ = class_;
	}

 	protected java.lang.String date;


	/**
	 *  The date that the sequence was determined.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String details;


	/**
	 *  Additional details about the construct that cannot be
	 *  represented in the category  attribute  in category pdbx_construct_feature.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entity_id;


	/**
	 *  In cases where the construct IS found in the co-ordinates then this
	 *  item provides a pointer to  attribute id in category entity in the ENTITY category for
	 *  the corresponding molecule.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_construct uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_construct must uniquely identify a record
	 *  in the PDBX_CONSTRUCT list and should be arranged so that it is
	 *  composed of a site-speicific prefix combined with a value that is
	 *  unique within a given site.Note that this item need not be a
	 *  number; it can be any unique identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String name;


	/**
	 *  attribute name in category pdbx_construct provides a placeholder for the local name
	 *  of the construct, for example the plasmid name if this category
	 *  is used to list plasmids.
	 */
	public java.lang.String getName() 
	{
		return name;
	}
 
	public void setName(java.lang.String name)
	{
		this.name = name;
	}

 	protected java.lang.String organisation;


	/**
	 *  attribute organisation in category pdbx_construct describes the organisation in which
	 *  the  attribute id in category pdbx_construct is unique. This will normally be the lab
	 *  in which the constrcut originated. It is envisaged that this item
	 *  will permit a globally unique identifier to be constructed in cases
	 *  where this is not possible from the  attribute id in category pdbx_construct alone.
	 */
	public java.lang.String getOrganisation() 
	{
		return organisation;
	}
 
	public void setOrganisation(java.lang.String organisation)
	{
		this.organisation = organisation;
	}

 	protected java.lang.String robot_id;


	/**
	 *  In cases where the sequence has been determined by a robot this
	 *  data item provides a pointer to pdbx_robot_system.id in the
	 *  PDBX_ROBOT_SYSTEM category for the robot responsible
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.String seq;


	/**
	 *  sequence expressed as string of one-letter base codes or one
	 *  letter amino acid codes. Unusual residues may be represented
	 *  either using the appropriate one letter code wild cards or
	 *  by the three letter code in parentheses.
	 *  gatgctgtag gcataggctt ggttatgccg gtactgccgg gcctcttgcg ggatatcgtc
	 *  gctcaaggcg cactcccgtt ctggataatg ttttttgcgc cgacatcata acggttctgg
	 *  caaatattct gaaatgagct gttgacaatt aatcatcgat aagcttcttg
	 */
	public java.lang.String getSeq() 
	{
		return seq;
	}
 
	public void setSeq(java.lang.String seq)
	{
		this.seq = seq;
	}

 	protected java.lang.String type;


	/**
	 *  The type of nucleic acid sequence in the construct. Note that
	 *  to find all the DNA molecules it is necessary to search for
	 *  DNA + cDNA and for RNA, RNA + mRNA + tRNA.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
