package org.pdb.beans;

/**
 *  Data items in the PDBX_CONTACT_AUTHOR category record details
 *  about the name and address of the author to be contacted
 *  concerning the contents of this data block.  This category atomizes
 *  information to a greater degree than the standard AUDIT_CONTACT_AUTHOR
 *  category.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_contact_authorCategory>
 *  <PDBx:pdbx_contact_author id="1">
 *  <PDBx:name_salutation>Dr.</PDBx:name_salutation>
 *  <PDBx:name_first>Paula</PDBx:name_first>
 *  <PDBx:name_last>Fitzgerald</PDBx:name_last>
 *  <PDBx:name_mi>M.D.</PDBx:name_mi>
 *  <PDBx:address_1>Department of Biophysical Chemistry</PDBx:address_1>
 *  <PDBx:address_2>Merck Research Laboratories</PDBx:address_2>
 *  <PDBx:address_3>P. O. Box 2000, Ry80M203</PDBx:address_3>
 *  <PDBx:city>Rahway</PDBx:city>
 *  <PDBx:state_province>New Jersey</PDBx:state_province>
 *  <PDBx:postal_code>07065</PDBx:postal_code>
 *  <PDBx:country>UNITED STATES</PDBx:country>
 *  <PDBx:phone>908 594 5510</PDBx:phone>
 *  <PDBx:fax>908 594 6645</PDBx:fax>
 *  <PDBx:email>paula_fitzgerald@merck.com</PDBx:email>
 *  <PDBx:role>principal investigator/group leader</PDBx:role>
 *  <PDBx:organization_type>commercial</PDBx:organization_type>
 *  </PDBx:pdbx_contact_author>
 *  </PDBx:pdbx_contact_authorCategory>
 * </pre>
 */
public class Pdbx_contact_author 
{
		protected java.lang.String address_1;


	/**
	 *  The mailing address of the author of the data block to whom
	 *  correspondence should be addressed, line 1 of 3.
	 *  610 Taylor Road
	 */
	public java.lang.String getAddress_1() 
	{
		return address_1;
	}
 
	public void setAddress_1(java.lang.String address_1)
	{
		this.address_1 = address_1;
	}

 	protected java.lang.String address_2;


	/**
	 *  The mailing address of the author of the data block to whom
	 *  correspondence should be addressed, line 2 of 3.
	 *  Department of Chemistry and Chemical Biology
	 */
	public java.lang.String getAddress_2() 
	{
		return address_2;
	}
 
	public void setAddress_2(java.lang.String address_2)
	{
		this.address_2 = address_2;
	}

 	protected java.lang.String address_3;


	/**
	 *  The mailing address of the author of the data block to whom
	 *  correspondence should be addressed, line 3 of 3.
	 *  Busch Campus
	 */
	public java.lang.String getAddress_3() 
	{
		return address_3;
	}
 
	public void setAddress_3(java.lang.String address_3)
	{
		this.address_3 = address_3;
	}

 	protected java.lang.String city;


	/**
	 *  The mailing address of the author of the data block to whom
	 *  correspondence should be addressed, city.
	 *  Piscataway
	 */
	public java.lang.String getCity() 
	{
		return city;
	}
 
	public void setCity(java.lang.String city)
	{
		this.city = city;
	}

 	protected java.lang.String continent;


	/**
	 *  The continent of the author of the data block to whom
	 *  correspondence should be addressed.
	 *  AFRICA
	 *  ANTARTICA
	 *  ASIA
	 *  AUSTRALIA
	 *  EUROPE
	 *  NORTH AMERICA
	 *  SOUTH AMERICA
	 */
	public java.lang.String getContinent() 
	{
		return continent;
	}
 
	public void setContinent(java.lang.String continent)
	{
		this.continent = continent;
	}

 	protected java.lang.String country;


	/**
	 *  The country of the author of the data block to whom
	 *  correspondence should be addressed.
	 *  UNITED STATES
	 *  UNITED KINGDOM
	 *  AUSTRALIA
	 */
	public java.lang.String getCountry() 
	{
		return country;
	}
 
	public void setCountry(java.lang.String country)
	{
		this.country = country;
	}

 	protected java.lang.String email;


	/**
	 *  The electronic mail address of the author of the data block to
	 *  whom correspondence should be addressed, in a form recognisable
	 *  to international networks.
	 *  name@host.domain.country
	 *  bm@iucr.ac.uk
	 */
	public java.lang.String getEmail() 
	{
		return email;
	}
 
	public void setEmail(java.lang.String email)
	{
		this.email = email;
	}

 	protected java.lang.String fax;


	/**
	 *  The facsimile telephone number of the author of the data
	 *  block to whom correspondence should be addressed.
	 *  
	 *  The recommended style includes the international dialing
	 *  prefix, the area code in parentheses, followed by the
	 *  local number with no spaces.
	 *  12(34) 947 7334
	 *  732 445 0103
	 */
	public java.lang.String getFax() 
	{
		return fax;
	}
 
	public void setFax(java.lang.String fax)
	{
		this.fax = fax;
	}

 	protected java.lang.Integer id_;


	/**
	 *  A unique integer identifier for this author
	 *  1 2 3
	 */
	public java.lang.Integer getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.Integer id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.String name_first;


	/**
	 *  The first name of the author of the data block to whom correspondence
	 *  should be addressed.
	 *  Percival
	 *  Loyd
	 *  Susan
	 */
	public java.lang.String getName_first() 
	{
		return name_first;
	}
 
	public void setName_first(java.lang.String name_first)
	{
		this.name_first = name_first;
	}

 	protected java.lang.String name_last;


	/**
	 *  The last name of the author of the data block to whom correspondence
	 *  should be addressed.
	 *  Samuels
	 *  Rodgers
	 */
	public java.lang.String getName_last() 
	{
		return name_last;
	}
 
	public void setName_last(java.lang.String name_last)
	{
		this.name_last = name_last;
	}

 	protected java.lang.String name_mi;


	/**
	 *  The middle initial(s) of the author of the data block to whom correspondence
	 *  should be addressed.
	 *  T.
	 *  M.F.
	 */
	public java.lang.String getName_mi() 
	{
		return name_mi;
	}
 
	public void setName_mi(java.lang.String name_mi)
	{
		this.name_mi = name_mi;
	}

 	protected java.lang.String name_salutation;


	/**
	 *  The salutation of the author of the data block to whom correspondence
	 *  should be addressed.
	 *  Dr.
	 *  Prof.
	 *  Mr.
	 *  Ms.
	 *  Mrs.
	 */
	public java.lang.String getName_salutation() 
	{
		return name_salutation;
	}
 
	public void setName_salutation(java.lang.String name_salutation)
	{
		this.name_salutation = name_salutation;
	}

 	protected java.lang.String organization_type;


	/**
	 *  The organization type to which this author is affiliated.
	 *  academic
	 *  commercial
	 *  government
	 *  other
	 */
	public java.lang.String getOrganization_type() 
	{
		return organization_type;
	}
 
	public void setOrganization_type(java.lang.String organization_type)
	{
		this.organization_type = organization_type;
	}

 	protected java.lang.String phone;


	/**
	 *  The telephone number of the author of the data block to whom
	 *  correspondence should be addressed.
	 *  
	 *  The recommended style includes the international dialing
	 *  prefix, the area code in parentheses, followed by the
	 *  local number and any extension number prefixed by 'x',
	 *  with no spaces. The earlier convention of including
	 *  the international dialing prefixes in parentheses is no longer
	 *  recommended.
	 *  12 (34) 947 7330
	 *  947 732 0103 x8320
	 */
	public java.lang.String getPhone() 
	{
		return phone;
	}
 
	public void setPhone(java.lang.String phone)
	{
		this.phone = phone;
	}

 	protected java.lang.String postal_code;


	/**
	 *  The mailing address of the author of the data block to whom
	 *  correspondence should be addressed, zip code.
	 *  08854
	 */
	public java.lang.String getPostal_code() 
	{
		return postal_code;
	}
 
	public void setPostal_code(java.lang.String postal_code)
	{
		this.postal_code = postal_code;
	}

 	protected java.lang.String role;


	/**
	 *  The role of this author in the project depositing this data.
	 *  principal investigator/group leader
	 *  responsible scientist
	 *  investigator
	 */
	public java.lang.String getRole() 
	{
		return role;
	}
 
	public void setRole(java.lang.String role)
	{
		this.role = role;
	}

 	protected java.lang.String state_province;


	/**
	 *  The mailing address of the author of the data block to whom
	 *  correspondence should be addressed, state or province.
	 *  New Jersey
	 */
	public java.lang.String getState_province() 
	{
		return state_province;
	}
 
	public void setState_province(java.lang.String state_province)
	{
		this.state_province = state_province;
	}

 }
