package org.pdb.beans;

/**
 *  Data items in the PDBX_DOMAIN category record information
 *  about domain definitions.
 *  
 *  A domain need not correspond to a completely polypeptide chain;
 *  it can be composed of one or more segments in a single chain,
 *  or by segments from more than one chain.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_domainCategory>
 *  <PDBx:pdbx_domain id="d1">
 *  <PDBx:details>Chains A, B</PDBx:details>
 *  </PDBx:pdbx_domain>
 *  <PDBx:pdbx_domain id="d2">
 *  <PDBx:details>Asym_id D Residues 1-134</PDBx:details>
 *  </PDBx:pdbx_domain>
 *  </PDBx:pdbx_domainCategory>
 * </pre>
 */
public class Pdbx_domain 
{
		protected java.lang.String details;


	/**
	 *  A description of special aspects of the structural elements that
	 *  comprise a domain.
	 *  The loop between residues 18 and 23.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_domain must uniquely identify a
	 *  record in the PDBX_DOMAIN list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
