package org.pdb.beans;

/**
 *  Data items in the PDBX_ENTITY_ANNOTATION category specify
 *  additional annotation relevant to the molecular entities.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_entity_annotationCategory>
 *  <PDBx:pdbx_entity_annotation entity_id="1" type="molecular function">
 *  <PDBx:text>antigen binding</PDBx:text>
 *  <PDBx:support> Experimentally verified with fluroescent antigen using flow cytometry</PDBx:support>
 *  </PDBx:pdbx_entity_annotation>
 *  </PDBx:pdbx_entity_annotationCategory>
 * </pre>
 */
public class Pdbx_entity_annotation 
{
		protected java.lang.String entity_id;


	/**
	 *  This data item is a pointer to  attribute id in category entity in the ENTITY category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String support;


	/**
	 *  Text describing the experimentation or computational evidence for
	 *  the annotation.
	 *  fluoresence measurements using flow cytometry
	 *  kinase binding assay
	 */
	public java.lang.String getSupport() 
	{
		return support;
	}
 
	public void setSupport(java.lang.String support)
	{
		this.support = support;
	}

 	protected java.lang.String text;


	/**
	 *  Text describing the annotation for this entity.
	 *  antigen binding
	 *  glucose transporter activity
	 */
	public java.lang.String getText() 
	{
		return text;
	}
 
	public void setText(java.lang.String text)
	{
		this.text = text;
	}

 	protected java.lang.String type;


	/**
	 *  Type of annoation for this entity.
	 */
	public java.lang.String getType() 
	{
		return type;
	}
 
	public void setType(java.lang.String type)
	{
		this.type = type;
	}

 }
