package org.pdb.beans;

/**
 *  The PDBX_ENTITY_ASSEMBLY category provides a chemical description
 *  of the biological assembly studied in terms of its constituent
 *  entities.
 *  A complex composed of one copy of entities 1 and 2.
 *  <PDBx:pdbx_entity_assemblyCategory>
 *  <PDBx:pdbx_entity_assembly id="1" entity_id="1">
 *  <PDBx:biol_id>1</PDBx:biol_id>
 *  <PDBx:num_copies>1</PDBx:num_copies>
 *  </PDBx:pdbx_entity_assembly>
 *  <PDBx:pdbx_entity_assembly id="1" entity_id="2">
 *  <PDBx:biol_id>1</PDBx:biol_id>
 *  <PDBx:num_copies>1</PDBx:num_copies>
 *  </PDBx:pdbx_entity_assembly>
 *  </PDBx:pdbx_entity_assemblyCategory>
 */
public class Pdbx_entity_assembly 
{
		protected java.lang.String biol_id;


	/**
	 *  An  identifier for the assembly.
	 */
	public java.lang.String getBiol_id() 
	{
		return biol_id;
	}
 
	public void setBiol_id(java.lang.String biol_id)
	{
		this.biol_id = biol_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  An enity identifier. A reference to  attribute id in category entity.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String id_;


	/**
	 *  An  identifier for the assembly.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 	protected java.lang.Integer num_copies;


	/**
	 *  The number of copies of this entity in the assembly.
	 */
	public java.lang.Integer getNum_copies() 
	{
		return num_copies;
	}
 
	public void setNum_copies(java.lang.Integer num_copies)
	{
		this.num_copies = num_copies;
	}

 }
