package org.pdb.beans;

/**
 *  This category contains details for the chromatographic steps used in the
 *  purification of the protein.
 */
public class Pdbx_entity_src_gen_chrom 
{
		protected java.lang.Float column_temperature;


	/**
	 *  The temperature in degrees celsius at which this column was run.
	 */
	public java.lang.Float getColumn_temperature() 
	{
		return column_temperature;
	}
 
	public void setColumn_temperature(java.lang.Float column_temperature)
	{
		this.column_temperature = column_temperature;
	}

 	protected java.lang.String column_type;


	/**
	 *  The type of column used in this step.
	 */
	public java.lang.String getColumn_type() 
	{
		return column_type;
	}
 
	public void setColumn_type(java.lang.String column_type)
	{
		this.column_type = column_type;
	}

 	protected java.lang.Float column_volume;


	/**
	 *  The volume of the column used in this step.
	 */
	public java.lang.Float getColumn_volume() 
	{
		return column_volume;
	}
 
	public void setColumn_volume(java.lang.Float column_volume)
	{
		this.column_volume = column_volume;
	}

 	protected java.lang.String date;


	/**
	 *  The date of production step.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String elution_buffer_id;


	/**
	 *  This item is a pointer to pdbx_buffer.id in the PDBX_BUFFER category.
	 *  The referenced buffer is that with which the protein was eluted.
	 */
	public java.lang.String getElution_buffer_id() 
	{
		return elution_buffer_id;
	}
 
	public void setElution_buffer_id(java.lang.String elution_buffer_id)
	{
		this.elution_buffer_id = elution_buffer_id;
	}

 	protected java.lang.String elution_protocol;


	/**
	 *  Details of the elution protocol.
	 */
	public java.lang.String getElution_protocol() 
	{
		return elution_protocol;
	}
 
	public void setElution_protocol(java.lang.String elution_protocol)
	{
		this.elution_protocol = elution_protocol;
	}

 	protected java.lang.String end_construct_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT
	 *  category. The referenced sequence is expected to be the amino
	 *  acid sequence of the expressed product after the
	 *  chromatography step.
	 */
	public java.lang.String getEnd_construct_id() 
	{
		return end_construct_id;
	}
 
	public void setEnd_construct_id(java.lang.String end_construct_id)
	{
		this.end_construct_id = end_construct_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_chrom uniquely identifies
	 *  each protein contained in the project target complex proteins whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category. This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_chrom uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String equilibration_buffer_id;


	/**
	 *  This item is a pointer to pdbx_buffer.id in the PDBX_BUFFER category.
	 *  The referenced buffer is that in which the column was equilibrated.
	 */
	public java.lang.String getEquilibration_buffer_id() 
	{
		return equilibration_buffer_id;
	}
 
	public void setEquilibration_buffer_id(java.lang.String equilibration_buffer_id)
	{
		this.equilibration_buffer_id = equilibration_buffer_id;
	}

 	protected java.lang.Float flow_rate;


	/**
	 *  The rate at which the equilibration buffer flowed through the column.
	 */
	public java.lang.Float getFlow_rate() 
	{
		return flow_rate;
	}
 
	public void setFlow_rate(java.lang.Float flow_rate)
	{
		this.flow_rate = flow_rate;
	}

 	protected java.lang.Integer next_step_id;


	/**
	 *  This item unique identifier for the next production step. This allows
	 *  a workflow to have multiple entry points leading to a single product.
	 */
	public java.lang.Integer getNext_step_id() 
	{
		return next_step_id;
	}
 
	public void setNext_step_id(java.lang.Integer next_step_id)
	{
		this.next_step_id = next_step_id;
	}

 	protected java.lang.String post_treatment;


	/**
	 *  Details of any post-chromatographic treatment of the protein sample.
	 */
	public java.lang.String getPost_treatment() 
	{
		return post_treatment;
	}
 
	public void setPost_treatment(java.lang.String post_treatment)
	{
		this.post_treatment = post_treatment;
	}

 	protected java.lang.String robot_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id
	 *  in the PDBX_ROBOT_SYSTEM category.
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.String sample_conc_method;


	/**
	 *  The method used to determine the concentration of the protein solution put
	 *  onto the column.
	 */
	public java.lang.String getSample_conc_method() 
	{
		return sample_conc_method;
	}
 
	public void setSample_conc_method(java.lang.String sample_conc_method)
	{
		this.sample_conc_method = sample_conc_method;
	}

 	protected java.lang.Float sample_concentration;


	/**
	 *  The concentration of the protein solution put onto the column.
	 */
	public java.lang.Float getSample_concentration() 
	{
		return sample_concentration;
	}
 
	public void setSample_concentration(java.lang.Float sample_concentration)
	{
		this.sample_concentration = sample_concentration;
	}

 	protected java.lang.String sample_prep_details;


	/**
	 *  Details of the sample preparation prior to running the column.
	 */
	public java.lang.String getSample_prep_details() 
	{
		return sample_prep_details;
	}
 
	public void setSample_prep_details(java.lang.String sample_prep_details)
	{
		this.sample_prep_details = sample_prep_details;
	}

 	protected java.lang.Float sample_volume;


	/**
	 *  The volume of protein solution run on the column.
	 */
	public java.lang.Float getSample_volume() 
	{
		return sample_volume;
	}
 
	public void setSample_volume(java.lang.Float sample_volume)
	{
		this.sample_volume = sample_volume;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is the unique identifier for this chromatography step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.Float volume_pooled_fractions;


	/**
	 *  The total volume of all the fractions pooled to give the purified protein
	 *  solution.
	 */
	public java.lang.Float getVolume_pooled_fractions() 
	{
		return volume_pooled_fractions;
	}
 
	public void setVolume_pooled_fractions(java.lang.Float volume_pooled_fractions)
	{
		this.volume_pooled_fractions = volume_pooled_fractions;
	}

 	protected java.lang.String yield_method;


	/**
	 *  The method used to determine the yield
	 */
	public java.lang.String getYield_method() 
	{
		return yield_method;
	}
 
	public void setYield_method(java.lang.String yield_method)
	{
		this.yield_method = yield_method;
	}

 	protected java.lang.Float yield_pooled_fractions;


	/**
	 *  The yield in milligrams of protein recovered in the pooled fractions.
	 */
	public java.lang.Float getYield_pooled_fractions() 
	{
		return yield_pooled_fractions;
	}
 
	public void setYield_pooled_fractions(java.lang.Float yield_pooled_fractions)
	{
		this.yield_pooled_fractions = yield_pooled_fractions;
	}

 }
