package org.pdb.beans;

/**
 *  This category contains details for the cloning steps used in
 *  the overall protein production process. Each row in PDBX_ENTITY_SRC_GEN_CLONE
 *  should have an equivalent row in either PDBX_ENTITY_SRC_GEN_CLONE_LIGATION or
 *  PDBX_ENTITY_SRC_GEN_CLONE_RECOMBINATION.  If only summary information is
 *  provided data in the later two categories may be omitted.
 */
public class Pdbx_entity_src_gen_clone 
{
		protected java.lang.String date;


	/**
	 *  The date of this production step.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String end_construct_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT
	 *  category. The referenced nucleic acid sequence is that of the
	 *  cloned product.
	 */
	public java.lang.String getEnd_construct_id() 
	{
		return end_construct_id;
	}
 
	public void setEnd_construct_id(java.lang.String end_construct_id)
	{
		this.end_construct_id = end_construct_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_clone uniquely identifies
	 *  each protein contained in the project target protein complex whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category. This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_clone uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String gene_insert_method;


	/**
	 *  The method used to insert the gene into the vector. For 'Ligation', an
	 *  PDBX_ENTITY_SRC_GEN_CLONE_LIGATION entry with matching .step_id is expected. For
	 *  'Recombination', an PDBX_ENTITY_SRC_GEN_CLONE_RECOMBINATION entry with matching
	 *  .step_id is expected.
	 */
	public java.lang.String getGene_insert_method() 
	{
		return gene_insert_method;
	}
 
	public void setGene_insert_method(java.lang.String gene_insert_method)
	{
		this.gene_insert_method = gene_insert_method;
	}

 	protected java.lang.String marker;


	/**
	 *  The type of marker included to allow selection of transformed cells
	 */
	public java.lang.String getMarker() 
	{
		return marker;
	}
 
	public void setMarker(java.lang.String marker)
	{
		this.marker = marker;
	}

 	protected java.lang.Integer next_step_id;


	/**
	 *  This item unique identifier for the next production step.
	 *  This allows a workflow to have multiple entry points leading
	 *  to a single product.
	 */
	public java.lang.Integer getNext_step_id() 
	{
		return next_step_id;
	}
 
	public void setNext_step_id(java.lang.Integer next_step_id)
	{
		this.next_step_id = next_step_id;
	}

 	protected java.lang.String purification_details;


	/**
	 *  Details of any purification of the product.
	 */
	public java.lang.String getPurification_details() 
	{
		return purification_details;
	}
 
	public void setPurification_details(java.lang.String purification_details)
	{
		this.purification_details = purification_details;
	}

 	protected java.lang.String robot_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id in the
	 *  PDBX_ROBOT_SYSTEM category.
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is the unique identifier for this cloning step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.String summary;


	/**
	 *  Summary of ligation or recombionation cloning used, the associated
	 *  verification method and any purification of the product.
	 */
	public java.lang.String getSummary() 
	{
		return summary;
	}
 
	public void setSummary(java.lang.String summary)
	{
		this.summary = summary;
	}

 	protected java.lang.String transformation_method;


	/**
	 *  The method used to transform the expression cell line with the vector
	 */
	public java.lang.String getTransformation_method() 
	{
		return transformation_method;
	}
 
	public void setTransformation_method(java.lang.String transformation_method)
	{
		this.transformation_method = transformation_method;
	}

 	protected java.lang.String vector_details;


	/**
	 *  Details of any modifications made to the named vector.
	 */
	public java.lang.String getVector_details() 
	{
		return vector_details;
	}
 
	public void setVector_details(java.lang.String vector_details)
	{
		this.vector_details = vector_details;
	}

 	protected java.lang.String vector_name;


	/**
	 *  The name of the vector used in this cloning step.
	 */
	public java.lang.String getVector_name() 
	{
		return vector_name;
	}
 
	public void setVector_name(java.lang.String vector_name)
	{
		this.vector_name = vector_name;
	}

 	protected java.lang.String verification_method;


	/**
	 *  The method used to verify that the incorporated gene is correct
	 */
	public java.lang.String getVerification_method() 
	{
		return verification_method;
	}
 
	public void setVerification_method(java.lang.String verification_method)
	{
		this.verification_method = verification_method;
	}

 }
