package org.pdb.beans;

/**
 *  This category contains details for the recombination-based cloning steps
 *  used in the overall protein production process. It is assumed that these
 *  reactions will use commercially available kits.
 *  attribute clone_step_id in category pdbx_entity_src_gen_clone_recombination in this category
 *  must point at a defined  attribute step_id in category pdbx_entity_src_gen_clone.  The details in
 *  PDBX_ENTITY_SRC_GEN_CLONE_RECOMBINATION extend the details in PDBX_ENTITY_SRC_GEN_CLONE
 *  to cover recombination dependent cloning steps.
 */
public class Pdbx_entity_src_gen_clone_recombination 
{
		protected java.lang.String details;


	/**
	 *  Any details to be associated with this recombination step, e.g. the protocol
	 *  or differences from the manufacturer's specified protocol.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String entity_id;


	/**
	 *  This item is a pointer to  attribute entity_id in category pdbx_entity_src_gen_clone in the
	 *  PDBX_ENTITY_SRC_GEN_CLONE category.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  This item is a pointer to  attribute entry_id in category pdbx_entity_src_gen_clone in the
	 *  PDBX_ENTITY_SRC_GEN_CLONE category.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String recombination_enzymes;


	/**
	 *  The names of the enzymes used for this recombination step.
	 */
	public java.lang.String getRecombination_enzymes() 
	{
		return recombination_enzymes;
	}
 
	public void setRecombination_enzymes(java.lang.String recombination_enzymes)
	{
		this.recombination_enzymes = recombination_enzymes;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is a pointer to  attribute step_id in category pdbx_entity_src_gen_clone in the
	 *  PDBX_ENTITY_SRC_GEN_CLONE category.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.String system;


	/**
	 *  The name of the recombination system.
	 */
	public java.lang.String getSystem() 
	{
		return system;
	}
 
	public void setSystem(java.lang.String system)
	{
		this.system = system;
	}

 }
