package org.pdb.beans;

/**
 *  This category contains details for the EXPRESSION steps used in
 *  the overall protein production process. It is hoped that this category
 *  will cover all forms of cell-based expression by reading induction as
 *  induction/transformation/transfection.
 */
public class Pdbx_entity_src_gen_express 
{
		protected java.lang.String C_terminal_seq_tag;


	/**
	 *  Any C-terminal sequence tag as a string of one letter amino acid codes
	 */
	public java.lang.String getC_terminal_seq_tag() 
	{
		return C_terminal_seq_tag;
	}
 
	public void setC_terminal_seq_tag(java.lang.String C_terminal_seq_tag)
	{
		this.C_terminal_seq_tag = C_terminal_seq_tag;
	}

 	protected java.lang.String N_terminal_seq_tag;


	/**
	 *  Any N-terminal sequence tag as a string of one letter amino acid codes.
	 */
	public java.lang.String getN_terminal_seq_tag() 
	{
		return N_terminal_seq_tag;
	}
 
	public void setN_terminal_seq_tag(java.lang.String N_terminal_seq_tag)
	{
		this.N_terminal_seq_tag = N_terminal_seq_tag;
	}

 	protected java.lang.String culture_additives;


	/**
	 *  Any additives to the base media in which the expression host was grown.
	 */
	public java.lang.String getCulture_additives() 
	{
		return culture_additives;
	}
 
	public void setCulture_additives(java.lang.String culture_additives)
	{
		this.culture_additives = culture_additives;
	}

 	protected java.lang.String culture_base_media;


	/**
	 *  The name of the base media in which the expression host was grown.
	 */
	public java.lang.String getCulture_base_media() 
	{
		return culture_base_media;
	}
 
	public void setCulture_base_media(java.lang.String culture_base_media)
	{
		this.culture_base_media = culture_base_media;
	}

 	protected java.lang.Float culture_temperature;


	/**
	 *  The temperature in degrees celsius at which the expression host was allowed
	 *  to grow prior to induction/transformation/transfection.
	 */
	public java.lang.Float getCulture_temperature() 
	{
		return culture_temperature;
	}
 
	public void setCulture_temperature(java.lang.Float culture_temperature)
	{
		this.culture_temperature = culture_temperature;
	}

 	protected java.lang.Float culture_time;


	/**
	 *  The time in hours for which the expression host was allowed to grow
	 *  prior to induction/transformation/transfection.
	 */
	public java.lang.Float getCulture_time() 
	{
		return culture_time;
	}
 
	public void setCulture_time(java.lang.Float culture_time)
	{
		this.culture_time = culture_time;
	}

 	protected java.lang.Float culture_volume;


	/**
	 *  The volume of media in milliliters in which the expression host was grown.
	 */
	public java.lang.Float getCulture_volume() 
	{
		return culture_volume;
	}
 
	public void setCulture_volume(java.lang.Float culture_volume)
	{
		this.culture_volume = culture_volume;
	}

 	protected java.lang.String date;


	/**
	 *  The date of production step.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String end_construct_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT
	 *  category. The referenced sequence is expected to be the amino
	 *  acid sequence of the expressed product.
	 */
	public java.lang.String getEnd_construct_id() 
	{
		return end_construct_id;
	}
 
	public void setEnd_construct_id(java.lang.String end_construct_id)
	{
		this.end_construct_id = end_construct_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_express uniquely identifies
	 *  each protein contained in the project target complex proteins whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category.
	 *  This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_express uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String harvesting_details;


	/**
	 *  Details of the harvesting protocol.
	 */
	public java.lang.String getHarvesting_details() 
	{
		return harvesting_details;
	}
 
	public void setHarvesting_details(java.lang.String harvesting_details)
	{
		this.harvesting_details = harvesting_details;
	}

 	protected java.lang.String host_org_cell_line;


	/**
	 *  A specific line of cells used as the expression system
	 */
	public java.lang.String getHost_org_cell_line() 
	{
		return host_org_cell_line;
	}
 
	public void setHost_org_cell_line(java.lang.String host_org_cell_line)
	{
		this.host_org_cell_line = host_org_cell_line;
	}

 	protected java.lang.String host_org_common_name;


	/**
	 *  The common name of the organism that served as host for the
	 *  expression system. Where  attribute host_org_tax_id
	 *  in category pdbx_entity_src_gen_express is populated it is expected that this item may be derived by
	 *  look up against the taxonomy database.
	 */
	public java.lang.String getHost_org_common_name() 
	{
		return host_org_common_name;
	}
 
	public void setHost_org_common_name(java.lang.String host_org_common_name)
	{
		this.host_org_common_name = host_org_common_name;
	}

 	protected java.lang.String host_org_culture_collection;


	/**
	 *  Culture collection of the expression system
	 */
	public java.lang.String getHost_org_culture_collection() 
	{
		return host_org_culture_collection;
	}
 
	public void setHost_org_culture_collection(java.lang.String host_org_culture_collection)
	{
		this.host_org_culture_collection = host_org_culture_collection;
	}

 	protected java.lang.String host_org_details;


	/**
	 *  A description of special aspects of the organism that served as
	 *  host for the  expression system.
	 */
	public java.lang.String getHost_org_details() 
	{
		return host_org_details;
	}
 
	public void setHost_org_details(java.lang.String host_org_details)
	{
		this.host_org_details = host_org_details;
	}

 	protected java.lang.String host_org_scientific_name;


	/**
	 *  The scientific name of the organism that served as host for the
	 *  expression system. It is expected that either this item or
	 *  attribute host_org_tax_id in category pdbx_entity_src_gen_express should be populated.
	 */
	public java.lang.String getHost_org_scientific_name() 
	{
		return host_org_scientific_name;
	}
 
	public void setHost_org_scientific_name(java.lang.String host_org_scientific_name)
	{
		this.host_org_scientific_name = host_org_scientific_name;
	}

 	protected java.lang.String host_org_strain;


	/**
	 *  The strain of the organism that served as host for the expression
	 *  system. Where  attribute host_org_tax_id in category pdbx_entity_src_gen_express is
	 *  populated it is expected that this item may be derived by a
	 *  look up against the taxonomy database.
	 */
	public java.lang.String getHost_org_strain() 
	{
		return host_org_strain;
	}
 
	public void setHost_org_strain(java.lang.String host_org_strain)
	{
		this.host_org_strain = host_org_strain;
	}

 	protected java.lang.String host_org_tax_id;


	/**
	 *  The id for the NCBI taxonomy node corresponding to the organism that
	 *  served as host for the expression system.
	 */
	public java.lang.String getHost_org_tax_id() 
	{
		return host_org_tax_id;
	}
 
	public void setHost_org_tax_id(java.lang.String host_org_tax_id)
	{
		this.host_org_tax_id = host_org_tax_id;
	}

 	protected java.lang.String host_org_tissue;


	/**
	 *  The specific tissue which expressed the molecule.
	 */
	public java.lang.String getHost_org_tissue() 
	{
		return host_org_tissue;
	}
 
	public void setHost_org_tissue(java.lang.String host_org_tissue)
	{
		this.host_org_tissue = host_org_tissue;
	}

 	protected java.lang.String host_org_variant;


	/**
	 *  The vairant of the organism that served as host for the expression
	 *  system. Where  attribute host_org_tax_id in category pdbx_entity_src_gen_express is
	 *  populated it is expected that this item may be derived by a
	 *  look up against the taxonomy database.
	 */
	public java.lang.String getHost_org_variant() 
	{
		return host_org_variant;
	}
 
	public void setHost_org_variant(java.lang.String host_org_variant)
	{
		this.host_org_variant = host_org_variant;
	}

 	protected java.lang.String inducer;


	/**
	 *  The chemical name of the inducing agent.
	 */
	public java.lang.String getInducer() 
	{
		return inducer;
	}
 
	public void setInducer(java.lang.String inducer)
	{
		this.inducer = inducer;
	}

 	protected java.lang.Float inducer_concentration;


	/**
	 *  Concentration of the inducing agent.
	 */
	public java.lang.Float getInducer_concentration() 
	{
		return inducer_concentration;
	}
 
	public void setInducer_concentration(java.lang.Float inducer_concentration)
	{
		this.inducer_concentration = inducer_concentration;
	}

 	protected java.lang.String induction_details;


	/**
	 *  Details of induction/transformation/transfection.
	 */
	public java.lang.String getInduction_details() 
	{
		return induction_details;
	}
 
	public void setInduction_details(java.lang.String induction_details)
	{
		this.induction_details = induction_details;
	}

 	protected java.lang.Float induction_temperature;


	/**
	 *  The temperature in celsius at which the induced/transformed/transfected
	 *  cells were grown.
	 */
	public java.lang.Float getInduction_temperature() 
	{
		return induction_temperature;
	}
 
	public void setInduction_temperature(java.lang.Float induction_temperature)
	{
		this.induction_temperature = induction_temperature;
	}

 	protected java.lang.Float induction_timepoint;


	/**
	 *  The time in hours after induction/transformation/transfection at which
	 *  the optical density of the culture was measured.
	 */
	public java.lang.Float getInduction_timepoint() 
	{
		return induction_timepoint;
	}
 
	public void setInduction_timepoint(java.lang.Float induction_timepoint)
	{
		this.induction_timepoint = induction_timepoint;
	}

 	protected java.lang.Float multiplicity_of_infection;


	/**
	 *  The multiplicity of infection for genes introduced by transfection, eg.
	 *  for baculovirus-based expression.
	 */
	public java.lang.Float getMultiplicity_of_infection() 
	{
		return multiplicity_of_infection;
	}
 
	public void setMultiplicity_of_infection(java.lang.Float multiplicity_of_infection)
	{
		this.multiplicity_of_infection = multiplicity_of_infection;
	}

 	protected java.lang.Integer next_step_id;


	/**
	 *  This item unique identifier for the next production step. This allows
	 *  a workflow to have multiple entry points leading to a single product.
	 */
	public java.lang.Integer getNext_step_id() 
	{
		return next_step_id;
	}
 
	public void setNext_step_id(java.lang.Integer next_step_id)
	{
		this.next_step_id = next_step_id;
	}

 	protected java.lang.String plasmid_id;


	/**
	 *  This item is a pointer to  attribute id in category pdbx_construct in the
	 *  PDBX_CONSTRUCT category. The referenced entry will contain
	 *  the nucleotide sequence that is to be expressed, including tags.
	 */
	public java.lang.String getPlasmid_id() 
	{
		return plasmid_id;
	}
 
	public void setPlasmid_id(java.lang.String plasmid_id)
	{
		this.plasmid_id = plasmid_id;
	}

 	protected java.lang.String promoter_type;


	/**
	 *  The nature of the promoter controlling expression of the gene.
	 *  T7 LacZ
	 */
	public java.lang.String getPromoter_type() 
	{
		return promoter_type;
	}
 
	public void setPromoter_type(java.lang.String promoter_type)
	{
		this.promoter_type = promoter_type;
	}

 	protected java.lang.String robot_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id
	 *  in the PDBX_ROBOT_SYSTEM category.
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is the unique identifier for this expression step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.String storage_details;


	/**
	 *  Details of how the harvested culture was stored.
	 */
	public java.lang.String getStorage_details() 
	{
		return storage_details;
	}
 
	public void setStorage_details(java.lang.String storage_details)
	{
		this.storage_details = storage_details;
	}

 	protected java.lang.String summary;


	/**
	 *  Summary of the details of the expression steps used in protein production.
	 */
	public java.lang.String getSummary() 
	{
		return summary;
	}
 
	public void setSummary(java.lang.String summary)
	{
		this.summary = summary;
	}

 	protected java.lang.String vector_type;


	/**
	 *  Identifies the type of vector used (plasmid, virus, or cosmid)
	 *  in the expression system.
	 */
	public java.lang.String getVector_type() 
	{
		return vector_type;
	}
 
	public void setVector_type(java.lang.String vector_type)
	{
		this.vector_type = vector_type;
	}

 }
