package org.pdb.beans;

/**
 *  This category contains details for the fraction steps used in
 *  the overall protein production process. Examples of fractionation
 *  steps are centrifugation and magnetic bead pull-down purification.
 */
public class Pdbx_entity_src_gen_fract 
{
		protected java.lang.String date;


	/**
	 *  The date of this production step.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String details;


	/**
	 *  String value containing details of the fractionation.
	 */
	public java.lang.String getDetails() 
	{
		return details;
	}
 
	public void setDetails(java.lang.String details)
	{
		this.details = details;
	}

 	protected java.lang.String end_construct_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT
	 *  category. The referenced sequence is expected to be the amino
	 *  acid sequence of the expressed product after the fractionation
	 *  step.
	 */
	public java.lang.String getEnd_construct_id() 
	{
		return end_construct_id;
	}
 
	public void setEnd_construct_id(java.lang.String end_construct_id)
	{
		this.end_construct_id = end_construct_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_fract uniquely identifies
	 *  each protein contained in the project target protein complex whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category.  This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_fract uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String method;


	/**
	 *  This item describes the method of fractionation.
	 */
	public java.lang.String getMethod() 
	{
		return method;
	}
 
	public void setMethod(java.lang.String method)
	{
		this.method = method;
	}

 	protected java.lang.Integer next_step_id;


	/**
	 *  This item unique identifier for the next production step. This allows
	 *  a workflow to have multiple entry points leading to a single product.
	 */
	public java.lang.Integer getNext_step_id() 
	{
		return next_step_id;
	}
 
	public void setNext_step_id(java.lang.Integer next_step_id)
	{
		this.next_step_id = next_step_id;
	}

 	protected java.lang.String protein_location;


	/**
	 *  The fraction containing the protein of interest.
	 */
	public java.lang.String getProtein_location() 
	{
		return protein_location;
	}
 
	public void setProtein_location(java.lang.String protein_location)
	{
		this.protein_location = protein_location;
	}

 	protected java.lang.Float protein_volume;


	/**
	 *  The volume of the fraction containing the protein.
	 */
	public java.lang.Float getProtein_volume() 
	{
		return protein_volume;
	}
 
	public void setProtein_volume(java.lang.Float protein_volume)
	{
		this.protein_volume = protein_volume;
	}

 	protected java.lang.Float protein_yield;


	/**
	 *  The yield in milligrams of protein from the fractionation.
	 */
	public java.lang.Float getProtein_yield() 
	{
		return protein_yield;
	}
 
	public void setProtein_yield(java.lang.Float protein_yield)
	{
		this.protein_yield = protein_yield;
	}

 	protected java.lang.String protein_yield_method;


	/**
	 *  The method used to determine the yield
	 */
	public java.lang.String getProtein_yield_method() 
	{
		return protein_yield_method;
	}
 
	public void setProtein_yield_method(java.lang.String protein_yield_method)
	{
		this.protein_yield_method = protein_yield_method;
	}

 	protected java.lang.String robot_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id
	 *  in the PDBX_ROBOT_SYSTEM category.
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is the unique identifier for this fractionation step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.Float temperature;


	/**
	 *  The temperature in degrees celsius at which the fractionation was performed.
	 */
	public java.lang.Float getTemperature() 
	{
		return temperature;
	}
 
	public void setTemperature(java.lang.Float temperature)
	{
		this.temperature = temperature;
	}

 }
