package org.pdb.beans;

/**
 *  This category contains details for the DIGEST steps used in
 *  the overall protein production process. The digestion is assumed
 *  to be applied to the result of the previous production step, or the
 *  gene source if this is the first production step.
 *  
 * <pre>
 *  Example 1 - hypothetical example
 *  <PDBx:pdbx_entity_src_gen_prod_digestCategory>
 *  <PDBx:pdbx_entity_src_gen_prod_digest entry_id="111000111" entity_id="222000111" step_id="2">
 *  <PDBx:next_step_id>3</PDBx:next_step_id>
 *  <PDBx:end_construct_id>440050000123</PDBx:end_construct_id>
 *  <PDBx:robot_id>5</PDBx:robot_id>
 *  <PDBx:date>2002-07-12:15:13</PDBx:date>
 *  <PDBx:restriction_enzyme_1>NcoI</PDBx:restriction_enzyme_1>
 *  <PDBx:restriction_enzyme_2>BamII</PDBx:restriction_enzyme_2>
 *  <PDBx:purification_details>  No purification</PDBx:purification_details>
 *  </PDBx:pdbx_entity_src_gen_prod_digest>
 *  </PDBx:pdbx_entity_src_gen_prod_digestCategory>
 * </pre>
 */
public class Pdbx_entity_src_gen_prod_digest 
{
		protected java.lang.String date;


	/**
	 *  The date of this production step.
	 *  2003-12-25
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String end_construct_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the
	 *  PDBX_CONSTRUCT category. The referenced nucleic acid sequence
	 *  is that of the digest product
	 */
	public java.lang.String getEnd_construct_id() 
	{
		return end_construct_id;
	}
 
	public void setEnd_construct_id(java.lang.String end_construct_id)
	{
		this.end_construct_id = end_construct_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_prod_digest uniquely identifies
	 *  each protein contained in the project target protein complex whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category. This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_prod_digest uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.Integer next_step_id;


	/**
	 *  This item unique identifier for the next production step. This allows
	 *  a workflow to have multiple entry points leading to a single product.
	 */
	public java.lang.Integer getNext_step_id() 
	{
		return next_step_id;
	}
 
	public void setNext_step_id(java.lang.Integer next_step_id)
	{
		this.next_step_id = next_step_id;
	}

 	protected java.lang.String purification_details;


	/**
	 *  String value containing details of any purification of the
	 *  product of the digestion.
	 */
	public java.lang.String getPurification_details() 
	{
		return purification_details;
	}
 
	public void setPurification_details(java.lang.String purification_details)
	{
		this.purification_details = purification_details;
	}

 	protected java.lang.String restriction_enzyme_1;


	/**
	 *  The first enzyme used in the restriction digestion. The sites at
	 *  which this cuts can be derived from the sequence.
	 *  BamIII
	 */
	public java.lang.String getRestriction_enzyme_1() 
	{
		return restriction_enzyme_1;
	}
 
	public void setRestriction_enzyme_1(java.lang.String restriction_enzyme_1)
	{
		this.restriction_enzyme_1 = restriction_enzyme_1;
	}

 	protected java.lang.String restriction_enzyme_2;


	/**
	 *  The second enzyme used in the restriction digestion. The sites at
	 *  which this cuts can be derived from the sequence.
	 */
	public java.lang.String getRestriction_enzyme_2() 
	{
		return restriction_enzyme_2;
	}
 
	public void setRestriction_enzyme_2(java.lang.String restriction_enzyme_2)
	{
		this.restriction_enzyme_2 = restriction_enzyme_2;
	}

 	protected java.lang.String robot_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id
	 *  in the PDBX_ROBOT_SYSTEM category.
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is the unique identifier for this digestion step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.String summary;


	/**
	 *  Summary of the details of restriction digestion any purification of the
	 *  product of the digestion.
	 */
	public java.lang.String getSummary() 
	{
		return summary;
	}
 
	public void setSummary(java.lang.String summary)
	{
		this.summary = summary;
	}

 }
