package org.pdb.beans;

/**
 *  This category contains details for the PCR steps used in
 *  the overall protein production process. The PCR is assumed
 *  to be applied to the result of the previous production step, or the
 *  gene source if this is the first production step.
 *  
 * <pre>
 *  Example 1 - hypothetical example
 *  <PDBx:pdbx_entity_src_gen_prod_pcrCategory>
 *  <PDBx:pdbx_entity_src_gen_prod_pcr entry_id="111000111" entity_id="222000111" step_id="1">
 *  <PDBx:next_step_id>2</PDBx:next_step_id>
 *  <PDBx:end_construct_id>440050000111</PDBx:end_construct_id>
 *  <PDBx:robot_id>5</PDBx:robot_id>
 *  <PDBx:date>2002-07-12:15:13</PDBx:date>
 *  <PDBx:forward_primer_id>2</PDBx:forward_primer_id>
 *  <PDBx:reverse_primer_id>3</PDBx:reverse_primer_id>
 *  <PDBx:reaction_details>  Annealing temperature = 70 C
 *  Annealing time = 60 s
 *  Extending temperature = 74 C
 *  Extending time = 120 s
 *  Melting temperature = 95 C
 *  Melting time = 120 s
 *  Number of cycles = 40
 *  Polymerase = KOD
 *  Template = 10 pmol
 *  Primer = 25 pmol
 *  Total volume = 25 ul</PDBx:reaction_details>
 *  <PDBx:purification_details>  No purification</PDBx:purification_details>
 *  </PDBx:pdbx_entity_src_gen_prod_pcr>
 *  </PDBx:pdbx_entity_src_gen_prod_pcrCategory>
 * </pre>
 */
public class Pdbx_entity_src_gen_prod_pcr 
{
		protected java.lang.String date;


	/**
	 *  The date of this production step.
	 *  2003-12-25
	 *  2003-12-25:09:00
	 */
	public java.lang.String getDate() 
	{
		return date;
	}
 
	public void setDate(java.lang.String date)
	{
		this.date = date;
	}

 	protected java.lang.String end_construct_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT
	 *  category. The referenced nucleic acid sequence is that of the
	 *  PCR product.
	 */
	public java.lang.String getEnd_construct_id() 
	{
		return end_construct_id;
	}
 
	public void setEnd_construct_id(java.lang.String end_construct_id)
	{
		this.end_construct_id = end_construct_id;
	}

 	protected java.lang.String entity_id;


	/**
	 *  The value of  attribute entity_id in category pdbx_entity_src_gen_prod_pcr uniquely identifies
	 *  each protein contained in the project target protein complex whose
	 *  structure is to be determined. This data item is a pointer to  attribute id
	 *  in category entity in the ENTITY category. This item may be a site dependent bar code.
	 */
	public java.lang.String getEntity_id() 
	{
		return entity_id;
	}
 
	public void setEntity_id(java.lang.String entity_id)
	{
		this.entity_id = entity_id;
	}

 	protected java.lang.String entry_id;


	/**
	 *  The value of  attribute entry_id in category pdbx_entity_src_gen_prod_pcr uniquely identifies
	 *  a sample consisting of one or more proteins whose structure is
	 *  to be determined. This is a pointer to  attribute id in category entry.  This item may
	 *  be a site dependent bar code.
	 */
	public java.lang.String getEntry_id() 
	{
		return entry_id;
	}
 
	public void setEntry_id(java.lang.String entry_id)
	{
		this.entry_id = entry_id;
	}

 	protected java.lang.String forward_primer_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT category.
	 *  The referenced nucleic acid sequence is that of the forward primer.
	 */
	public java.lang.String getForward_primer_id() 
	{
		return forward_primer_id;
	}
 
	public void setForward_primer_id(java.lang.String forward_primer_id)
	{
		this.forward_primer_id = forward_primer_id;
	}

 	protected java.lang.Integer next_step_id;


	/**
	 *  This item unique identifier for the next production step.
	 *  This allows a workflow to have multiple entry points leading
	 *  to a single product.
	 */
	public java.lang.Integer getNext_step_id() 
	{
		return next_step_id;
	}
 
	public void setNext_step_id(java.lang.Integer next_step_id)
	{
		this.next_step_id = next_step_id;
	}

 	protected java.lang.String purification_details;


	/**
	 *  String value containing details of any purification of the
	 *  product of the PCR reaction.
	 */
	public java.lang.String getPurification_details() 
	{
		return purification_details;
	}
 
	public void setPurification_details(java.lang.String purification_details)
	{
		this.purification_details = purification_details;
	}

 	protected java.lang.String reaction_details;


	/**
	 *  String value containing details of the PCR reaction.
	 */
	public java.lang.String getReaction_details() 
	{
		return reaction_details;
	}
 
	public void setReaction_details(java.lang.String reaction_details)
	{
		this.reaction_details = reaction_details;
	}

 	protected java.lang.String reverse_primer_id;


	/**
	 *  This item is a pointer to pdbx_construct.id in the PDBX_CONSTRUCT category.
	 *  The referenced nucleic acid sequence is that of the reverse primer.
	 */
	public java.lang.String getReverse_primer_id() 
	{
		return reverse_primer_id;
	}
 
	public void setReverse_primer_id(java.lang.String reverse_primer_id)
	{
		this.reverse_primer_id = reverse_primer_id;
	}

 	protected java.lang.String robot_id;


	/**
	 *  This data item is a pointer to pdbx_robot_system.id in the
	 *  PDBX_ROBOT_SYSTEM category. The referenced robot is the
	 *  robot responsible for the PCR reaction (normally the heat
	 *  cycler).
	 */
	public java.lang.String getRobot_id() 
	{
		return robot_id;
	}
 
	public void setRobot_id(java.lang.String robot_id)
	{
		this.robot_id = robot_id;
	}

 	protected java.lang.Integer step_id;


	/**
	 *  This item is the unique identifier for this PCR step.
	 */
	public java.lang.Integer getStep_id() 
	{
		return step_id;
	}
 
	public void setStep_id(java.lang.Integer step_id)
	{
		this.step_id = step_id;
	}

 	protected java.lang.String summary;


	/**
	 *  Summary of the details of the PCR reaction any purification of the
	 *  product of the PCR reaction.
	 */
	public java.lang.String getSummary() 
	{
		return summary;
	}
 
	public void setSummary(java.lang.String summary)
	{
		this.summary = summary;
	}

 }
