package org.pdb.beans;

/**
 *  Data items in the PDBX_EXPTL_CRYSTAL_GROW_COMP category record
 *  details about the components of the solutions that were 'mixed'
 *  to produce the crystal.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_exptl_crystal_grow_compCategory>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="1">
 *  <PDBx:sol_id>protein</PDBx:sol_id>
 *  <PDBx:comp_name>protein</PDBx:comp_name>
 *  <PDBx:conc>25.</PDBx:conc>
 *  <PDBx:conc_units>mg/ml</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="2">
 *  <PDBx:sol_id>protein</PDBx:sol_id>
 *  <PDBx:comp_name>Tris HCl</PDBx:comp_name>
 *  <PDBx:conc>20.</PDBx:conc>
 *  <PDBx:conc_units>millimolar</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="3">
 *  <PDBx:sol_id>protein</PDBx:sol_id>
 *  <PDBx:comp_name>NaCl</PDBx:comp_name>
 *  <PDBx:conc>0.2</PDBx:conc>
 *  <PDBx:conc_units>molar</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="1">
 *  <PDBx:sol_id>precipitant</PDBx:sol_id>
 *  <PDBx:comp_name>PEG 4000</PDBx:comp_name>
 *  <PDBx:conc>12.5</PDBx:conc>
 *  <PDBx:conc_units>percent_weight_by_volume</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="2">
 *  <PDBx:sol_id>precipitant</PDBx:sol_id>
 *  <PDBx:comp_name>MES</PDBx:comp_name>
 *  <PDBx:conc>0.1</PDBx:conc>
 *  <PDBx:conc_units>molar</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  </PDBx:pdbx_exptl_crystal_grow_compCategory>
 * </pre>
 */
public class Pdbx_exptl_crystal_grow_comp 
{
		protected java.lang.String comp_id;


	/**
	 *  The value of  attribute comp_id in category exptl_crystal_grow_comp must uniquely identify
	 *  each item in the PDBX_EXPTL_CRYSTAL_GROW_COMP list.
	 *  
	 *  Note that this item need not be a number; it can be any unique
	 *  identifier.
	 *  1
	 *  2
	 */
	public java.lang.String getComp_id() 
	{
		return comp_id;
	}
 
	public void setComp_id(java.lang.String comp_id)
	{
		this.comp_id = comp_id;
	}

 	protected java.lang.String comp_name;


	/**
	 *  A common name for the component of the solution.
	 *  protein in buffer
	 *  acetic acid
	 */
	public java.lang.String getComp_name() 
	{
		return comp_name;
	}
 
	public void setComp_name(java.lang.String comp_name)
	{
		this.comp_name = comp_name;
	}

 	protected java.lang.Float conc;


	/**
	 *  The concentration value of the solution component.
	 *  200.
	 *  0.1
	 */
	public java.lang.Float getConc() 
	{
		return conc;
	}
 
	public void setConc(java.lang.Float conc)
	{
		this.conc = conc;
	}

 	protected java.lang.String conc_range;


	/**
	 *  The concentration range of the solution component.
	 *  200. - 230.
	 *  0.1 - 0.2
	 */
	public java.lang.String getConc_range() 
	{
		return conc_range;
	}
 
	public void setConc_range(java.lang.String conc_range)
	{
		this.conc_range = conc_range;
	}

 	protected java.lang.String conc_units;


	/**
	 *  The concentration units for the solution component.
	 *  millimolar
	 *  percent_weight_by_volume
	 *  milligrams_per_milliliter
	 */
	public java.lang.String getConc_units() 
	{
		return conc_units;
	}
 
	public void setConc_units(java.lang.String conc_units)
	{
		this.conc_units = conc_units;
	}

 	protected java.lang.String crystal_id;


	/**
	 *  This data item is a pointer to  attribute id in category exptl_crystal in the
	 *  EXPTL_CRYSTAL category.
	 */
	public java.lang.String getCrystal_id() 
	{
		return crystal_id;
	}
 
	public void setCrystal_id(java.lang.String crystal_id)
	{
		this.crystal_id = crystal_id;
	}

 	protected java.lang.String sol_id;


	/**
	 *  An identifier for the solution to which the given solution
	 *  component belongs.
	 */
	public java.lang.String getSol_id() 
	{
		return sol_id;
	}
 
	public void setSol_id(java.lang.String sol_id)
	{
		this.sol_id = sol_id;
	}

 }
