package org.pdb.beans;

/**
 *  Data items in the PDBX_FEATURE_ASSEMBLY category records
 *  information about properties pertaining to this
 *  structural assembly.
 *  
 * <pre>
 *  Example 1 - Biological process for functional assembly
 *  <PDBx:pdbx_feature_assemblyCategory>
 *  <PDBx:pdbx_feature_assembly id="1">
 *  <PDBx:assembly_id>b1</PDBx:assembly_id>
 *  <PDBx:feature_name>biological process</PDBx:feature_name>
 *  <PDBx:feature>nitrogen metabolism</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>GO</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>GO</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_assembly>
 *  </PDBx:pdbx_feature_assemblyCategory>
 * </pre>
 */
public class Pdbx_feature_assembly 
{
		protected java.lang.String assembly_id;


	/**
	 *  The value of  attribute assembly_id in category pdbx_feature_assembly references an
	 *  assembly definition in category STRUCT_BIOL
	 */
	public java.lang.String getAssembly_id() 
	{
		return assembly_id;
	}
 
	public void setAssembly_id(java.lang.String assembly_id)
	{
		this.assembly_id = assembly_id;
	}

 	protected java.lang.String feature;


	/**
	 *  The value of  attribute feature_name in category pdbx_feature_assembly.
	 */
	public java.lang.String getFeature() 
	{
		return feature;
	}
 
	public void setFeature(java.lang.String feature)
	{
		this.feature = feature;
	}

 	protected java.lang.String feature_assigned_by;


	/**
	 *  attribute feature_assigned_by in category pdbx_feature_assembly identifies
	 *  the individual, organization or program that assigned
	 *  the feature.
	 */
	public java.lang.String getFeature_assigned_by() 
	{
		return feature_assigned_by;
	}
 
	public void setFeature_assigned_by(java.lang.String feature_assigned_by)
	{
		this.feature_assigned_by = feature_assigned_by;
	}

 	protected java.lang.String feature_citation_id;


	/**
	 *  attribute feature_citation_id in category pdbx_feature_assembly is a
	 *  reference to a citation in the CITATION category
	 */
	public java.lang.String getFeature_citation_id() 
	{
		return feature_citation_id;
	}
 
	public void setFeature_citation_id(java.lang.String feature_citation_id)
	{
		this.feature_citation_id = feature_citation_id;
	}

 	protected java.lang.String feature_identifier;


	/**
	 *  attribute feature_identifier in category pdbx_feature_assembly_range is an
	 *  additional identifier used to identify or
	 *  accession this feature.
	 */
	public java.lang.String getFeature_identifier() 
	{
		return feature_identifier;
	}
 
	public void setFeature_identifier(java.lang.String feature_identifier)
	{
		this.feature_identifier = feature_identifier;
	}

 	protected java.lang.String feature_name;


	/**
	 *  attribute feature_name in category pdbx_feature_assembly identifies a feature
	 *  by name.
	 */
	public java.lang.String getFeature_name() 
	{
		return feature_name;
	}
 
	public void setFeature_name(java.lang.String feature_name)
	{
		this.feature_name = feature_name;
	}

 	protected java.lang.String feature_software_id;


	/**
	 *  attribute feature_software_id in category pdbx_feature_assembly is a
	 *  reference to an application described in the
	 *  SOFTWARE category.
	 */
	public java.lang.String getFeature_software_id() 
	{
		return feature_software_id;
	}
 
	public void setFeature_software_id(java.lang.String feature_software_id)
	{
		this.feature_software_id = feature_software_id;
	}

 	protected java.lang.String feature_type;


	/**
	 *  attribute feature_type in category pdbx_feature_assembly identifies the
	 *  type of feature.
	 */
	public java.lang.String getFeature_type() 
	{
		return feature_type;
	}
 
	public void setFeature_type(java.lang.String feature_type)
	{
		this.feature_type = feature_type;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_feature_assembly uniquely identifies a
	 *  feature in the PDBX_FEATURE_ASSEMBLY category.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
