package org.pdb.beans;

/**
 *  Data items in the PDBX_FEATURE_ENTRY category records
 *  information about properties pertaining to this
 *  structure entry.
 *  
 * <pre>
 *  Example 1 - Gene Ontology data by entry
 *  <PDBx:pdbx_feature_entryCategory>
 *  <PDBx:pdbx_feature_entry id="1">
 *  <PDBx:feature_name>molecular function</PDBx:feature_name>
 *  <PDBx:feature>DNA binding activity</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>GO</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>GO</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_entry>
 *  <PDBx:pdbx_feature_entry id="2">
 *  <PDBx:feature_name>biological process</PDBx:feature_name>
 *  <PDBx:feature>regulation of transcription, DNA-dependent</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>GO</PDBx:feature_assigned_by>
 *  <PDBx:feature_citation_id>GO</PDBx:feature_citation_id>
 *  </PDBx:pdbx_feature_entry>
 *  </PDBx:pdbx_feature_entryCategory>
 * </pre>
 */
public class Pdbx_feature_entry 
{
		protected java.lang.String feature;


	/**
	 *  The value of  attribute feature_name in category pdbx_feature_entry.
	 */
	public java.lang.String getFeature() 
	{
		return feature;
	}
 
	public void setFeature(java.lang.String feature)
	{
		this.feature = feature;
	}

 	protected java.lang.String feature_assigned_by;


	/**
	 *  attribute feature_assigned_by in category pdbx_feature_entry identifies
	 *  the individual, organization or program that
	 *  assigned the feature.
	 */
	public java.lang.String getFeature_assigned_by() 
	{
		return feature_assigned_by;
	}
 
	public void setFeature_assigned_by(java.lang.String feature_assigned_by)
	{
		this.feature_assigned_by = feature_assigned_by;
	}

 	protected java.lang.String feature_citation_id;


	/**
	 *  attribute feature_citation_id in category pdbx_feature_entry is a
	 *  reference to a citation in the CITATION category
	 */
	public java.lang.String getFeature_citation_id() 
	{
		return feature_citation_id;
	}
 
	public void setFeature_citation_id(java.lang.String feature_citation_id)
	{
		this.feature_citation_id = feature_citation_id;
	}

 	protected java.lang.String feature_identifier;


	/**
	 *  attribute feature_identifier in category pdbx_feature_entry is an
	 *  additional identifier used to identify or
	 *  accession this feature.
	 */
	public java.lang.String getFeature_identifier() 
	{
		return feature_identifier;
	}
 
	public void setFeature_identifier(java.lang.String feature_identifier)
	{
		this.feature_identifier = feature_identifier;
	}

 	protected java.lang.String feature_name;


	/**
	 *  attribute feature_name in category pdbx_feature_entry identifies a feature
	 *  by name.
	 */
	public java.lang.String getFeature_name() 
	{
		return feature_name;
	}
 
	public void setFeature_name(java.lang.String feature_name)
	{
		this.feature_name = feature_name;
	}

 	protected java.lang.String feature_software_id;


	/**
	 *  attribute feature_software_id in category pdbx_feature_entry is a
	 *  reference to an application described in the
	 *  SOFTWARE category.
	 */
	public java.lang.String getFeature_software_id() 
	{
		return feature_software_id;
	}
 
	public void setFeature_software_id(java.lang.String feature_software_id)
	{
		this.feature_software_id = feature_software_id;
	}

 	protected java.lang.String feature_type;


	/**
	 *  attribute feature_type in category pdbx_feature_entry identifies the
	 *  type of feature.
	 */
	public java.lang.String getFeature_type() 
	{
		return feature_type;
	}
 
	public void setFeature_type(java.lang.String feature_type)
	{
		this.feature_type = feature_type;
	}

 	protected java.lang.String id_;


	/**
	 *  The value of  attribute id in category pdbx_feature_entry uniquely identifies a
	 *  feature in the PDBX_FEATURE_ENTRY category.
	 */
	public java.lang.String getId_() 
	{
		return id_;
	}
 
	public void setId_(java.lang.String id_)
	{
		this.id_ = id_;
	}

 }
